/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.Toast;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library.core.InitialScreenshotHelper;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.internal.video.RequestPermissionActivityLauncher;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.k.d.b;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.memory.MemoryUtils;

public class ScreenshotProvider {
    public static synchronized void a(Activity activity, final ScreenshotCapturingListener screenshotCapturingListener) {
        if (activity != null && !activity.isFinishing()) {
            if (MemoryUtils.isLowMemory((Context)activity)) {
                Activity activity2 = activity;
                InstabugSDKLogger.e(InitialScreenshotHelper.class, "Couldn't take initial screenshot due to low memory");
                screenshotCapturingListener.onScreenshotCapturingFailed(new Throwable("Your activity is currently in low memory"));
                Toast.makeText((Context)activity2, (CharSequence)LocaleUtils.getLocaleStringResource(Instabug.getLocale((Context)activity2), R.string.instabug_str_capturing_screenshot_error, (Context)activity), (int)0).show();
                return;
            }
            InstabugSDKLogger.d("ScreemshotProvider", "start capture screenshot");
            com.instabug.library.k.b.a(activity).a(new b(){

                @Override
                public void a(Bitmap bitmap) {
                    screenshotCapturingListener.onScreenshotCapturedSuccessfully(bitmap);
                }

                @Override
                public void a(Throwable throwable) {
                    screenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                }
            }, R.id.instabug_decor_view, R.id.instabug_extra_screenshot_button, R.id.instabug_floating_button, R.id.instabug_in_app_notification, R.id.instabug_intro_dialog);
        } else if (screenshotCapturingListener != null) {
            screenshotCapturingListener.onScreenshotCapturingFailed(new Exception("Can't capture screenshot due to null activity"));
        }
    }

    public static synchronized void a(boolean bl, Activity activity, ScreenshotCapturingListener screenshotCapturingListener) {
        InstabugSDKLogger.d("ScreemshotProvider", "start capture screenshot Using MediaProjection");
        if (activity != null && !activity.isFinishing()) {
            if (SettingsManager.getInstance().isScreenCurrentlyRecorded()) {
                AutoScreenRecordingEventBus.getInstance().post(ScreenRecordingService.Action.STOP_TRIM_KEEP);
            }
            RequestPermissionActivityLauncher.start(activity, false, bl, screenshotCapturingListener);
        }
    }

    public static interface ScreenshotCapturingListener {
        public void onScreenshotCapturedSuccessfully(Bitmap var1);

        public void onScreenshotCapturingFailed(Throwable var1);
    }
}

