/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.content.Context;
import android.net.Uri;
import android.os.Process;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.m.b.a.e;
import com.instabug.library.model.a;
import com.instabug.library.model.k;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.b;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.VisualUserStep;
import com.instabug.library.visualusersteps.h;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class State
implements Cacheable,
Serializable {
    public static final String KEY_APP_PACKAGE_NAME = "bundle_id";
    public static final String KEY_APP_VERSION = "app_version";
    private static final String KEY_BATTERY_LEVEL = "battery_level";
    private static final String KEY_BATTERY_STATUS = "battery_state";
    public static final String KEY_CARRIER = "carrier";
    public static final String KEY_CONSOLE_LOG = "console_log";
    public static final String KEY_CURRENT_VIEW = "current_view";
    public static final String KEY_DENSITY = "density";
    public static final String KEY_DEVICE = "device";
    public static final String KEY_DEVICE_ROOTED = "device_rooted";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_NAME = "name";
    public static final String KEY_PUSH_TOKEN = "push_token";
    public static final String KEY_INSTABUG_LOG = "instabug_log";
    public static final String KEY_LOCALE = "locale";
    private static final String KEY_MEMORY_FREE = "memory_free";
    private static final String KEY_MEMORY_TOTAL = "memory_total";
    private static final String KEY_MEMORY_USED = "memory_used";
    public static final String KEY_ORIENTATION = "orientation";
    public static final String KEY_OS = "os";
    public static final String KEY_REPORTED_AT = "reported_at";
    public static final String KEY_SCREEN_SIZE = "screen_size";
    public static final String KEY_SDK_VERSION = "sdk_version";
    public static final String KEY_STORAGE_FREE = "storage_free";
    public static final String KEY_STORAGE_TOTAL = "storage_total";
    public static final String KEY_STORAGE_USED = "storage_used";
    public static final String KEY_TAGS = "tags";
    public static final String KEY_USER_DATA = "user_data";
    public static final String KEY_USER_STEPS = "user_steps";
    public static final String KEY_WIFI_SSID = "wifi_ssid";
    public static final String KEY_WIFI_STATE = "wifi_state";
    public static final String KEY_USER_ATTRIBUTES = "user_attributes";
    public static final String KEY_NETWORK_LOGS = "network_log";
    public static final String KEY_USER_EVENTS = "user_events";
    public static final String KEY_VISUAL_USER_STEPS = "user_repro_steps";
    public static final String KEY_SESSIONS_PROFILER = "sessions_profiler";
    private static final String KEY_APP_STATUS = "app_status";
    @VisibleForTesting
    static final String VALUE_APP_STATUS_FOREGROUND = "foreground";
    @VisibleForTesting
    static final String VALUE_APP_STATUS_BACKGROUND = "background";
    private static final String TAG = "State";
    private long duration;
    private boolean isDeviceRooted;
    private int batteryLevel;
    private boolean wifiState;
    private long usedMemory;
    private long freeMemory;
    private long totalMemory;
    private long usedStorage;
    public long freeStorage;
    private long totalStorage;
    @Nullable
    private String sdkVersion;
    @Nullable
    private String locale;
    @Nullable
    private String device;
    @Nullable
    private String OS;
    @Nullable
    private String carrier;
    @Nullable
    private String appPackageName;
    @Nullable
    private String appVersion;
    @Nullable
    private String batteryState;
    @Nullable
    private String wifiSSID;
    @Nullable
    private String screenDensity;
    @Nullable
    private String screenSize;
    @Nullable
    private String ScreenOrientation;
    @Nullable
    private String currentView;
    @Nullable
    private String instabugLog;
    @Nullable
    private ArrayList<a> consoleLog;
    @Nullable
    private ArrayList<k> userSteps;
    @Nullable
    private ArrayList<VisualUserStep> visualUserSteps;
    @Nullable
    private e sessionProfilerTimeline;
    @Nullable
    private String userEmail;
    @Nullable
    private String userName;
    @Nullable
    private String pushToken;
    @Nullable
    private String userData;
    private long reportedAt;
    @Nullable
    private String tags;
    @Nullable
    private String networkLogs;
    @Nullable
    private String userAttributes;
    @Nullable
    private String userEvents;
    @Nullable
    private Uri uri;
    @Nullable
    private String appStatus;
    @Nullable
    private String customUserAttribute;

    public static State getState(Context context) {
        return new Builder(context).build(true);
    }

    private State setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
        return this;
    }

    private State setIsDeviceRooted(boolean isDeviceRooted) {
        this.isDeviceRooted = isDeviceRooted;
        return this;
    }

    private State setWifiState(boolean wifiState) {
        this.wifiState = wifiState;
        return this;
    }

    private State setWifiSSID(String wifiSSID) {
        this.wifiSSID = wifiSSID;
        return this;
    }

    private State setUsedMemory(long usedMemory) {
        this.usedMemory = usedMemory;
        return this;
    }

    private State setUsedStorage(long usedStorage) {
        this.usedStorage = usedStorage;
        return this;
    }

    private long getFreeStorage() {
        return this.freeStorage;
    }

    private State setFreeStorage(long freeStorage) {
        this.freeStorage = freeStorage;
        return this;
    }

    private State setTotalStorage(long totalStorage) {
        this.totalStorage = totalStorage;
        return this;
    }

    private State setAppStatus(String appStatus) {
        this.appStatus = appStatus;
        return this;
    }

    private State setConsoleLog(ArrayList<a> consoleLogs) {
        this.consoleLog = consoleLogs;
        return this;
    }

    private State setUserSteps(ArrayList<k> userSteps) {
        this.userSteps = userSteps;
        return this;
    }

    private State setReportedAt(long reportedAt) {
        this.reportedAt = reportedAt;
        return this;
    }

    private static String getTagsAsString(List<String> tags) {
        List<String> list;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (tags != null && list.size() > 0) {
            int n = list.size();
            for (int i2 = 0; i2 < n; ++i2) {
                stringBuilder2.append(list.get(i2));
                if (i2 == n - 1) continue;
                stringBuilder2.append(", ");
            }
        }
        return stringBuilder2.toString();
    }

    private State setNetworkLogs(String networkLogs) {
        this.networkLogs = networkLogs;
        return this;
    }

    private void setVisualUserSteps(@Nullable ArrayList<VisualUserStep> visualUserSteps) {
        this.visualUserSteps = visualUserSteps;
    }

    @Nullable
    private String getSessionProfilerTimeline() {
        Serializable this_ = ((State)this_).sessionProfilerTimeline;
        return this_ == null ? null : ((e)this_).b().toString();
    }

    private State setSessionProfilerTimeline(e sessionProfilerTimeline) {
        this.sessionProfilerTimeline = sessionProfilerTimeline;
        return this;
    }

    @Nullable
    public String getCustomUserAttribute() {
        return this.customUserAttribute;
    }

    public void setCustomUserAttribute(@Nullable String customUserAttribute) {
        this.customUserAttribute = customUserAttribute;
    }

    @Nullable
    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    public State setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public State setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    public String getDevice() {
        return this.device;
    }

    public State setDevice(String device) {
        this.device = device;
        return this;
    }

    public boolean isDeviceRooted() {
        return this.isDeviceRooted;
    }

    @Nullable
    public String getOS() {
        return this.OS;
    }

    public State setOS(String OS) {
        this.OS = OS;
        return this;
    }

    @Nullable
    public String getCarrier() {
        return this.carrier;
    }

    public State setCarrier(String carrier) {
        this.carrier = carrier;
        return this;
    }

    @Nullable
    public String getAppPackageName() {
        return this.appPackageName;
    }

    public State setAppPackageName(String appPackageName) {
        this.appPackageName = appPackageName;
        return this;
    }

    @Nullable
    public String getAppVersion() {
        return this.appVersion;
    }

    public State setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    public void setUri(@Nullable Uri uri) {
        this.uri = uri;
    }

    public State setBatteryLevel(int batteryLevel) {
        this.batteryLevel = batteryLevel;
        return this;
    }

    @Nullable
    public String getBatteryState() {
        return this.batteryState;
    }

    public State setBatteryState(String batteryState) {
        this.batteryState = batteryState;
        return this;
    }

    public boolean isWifiEnable() {
        return this.wifiState;
    }

    @Nullable
    public String getWifiSSID() {
        return this.wifiSSID;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public State setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
        return this;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public State setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
        return this;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public long getTotalStorage() {
        return this.totalStorage;
    }

    @Nullable
    public String getScreenDensity() {
        return this.screenDensity;
    }

    public State setScreenDensity(String screenDensity) {
        this.screenDensity = screenDensity;
        return this;
    }

    @Nullable
    public String getScreenSize() {
        return this.screenSize;
    }

    public State setScreenSize(String screenSize) {
        this.screenSize = screenSize;
        return this;
    }

    @Nullable
    public String getScreenOrientation() {
        return this.ScreenOrientation;
    }

    public State setScreenOrientation(String screenOrientation) {
        this.ScreenOrientation = screenOrientation;
        return this;
    }

    @Nullable
    public String getCurrentView() {
        return this.currentView;
    }

    public State setCurrentView(String currentView) {
        this.currentView = currentView;
        return this;
    }

    @Nullable
    String getAppStatus() {
        return this.appStatus;
    }

    @Nullable
    public String getInstabugLog() {
        return this.instabugLog;
    }

    public void setInstabugLog(@Nullable String instabugLog) {
        this.instabugLog = instabugLog;
    }

    public void updateConsoleLog() {
        this.setConsoleLog(Builder.getConsoleLog());
    }

    public void updateConsoleLog(ArrayList<a> logs) {
        this.setConsoleLog(Builder.getConsoleLog(logs));
    }

    public JSONArray getConsoleLog() {
        return a.a(this.consoleLog);
    }

    public JSONArray getUserSteps() {
        return k.a(this.userSteps);
    }

    @Nullable
    public String getUserEmail() {
        return this.userEmail;
    }

    public State setUserEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    public State setUserName(@Nullable String userName) {
        this.userName = userName;
        return this;
    }

    @Nullable
    public String getPushToken() {
        return this.pushToken;
    }

    public State setPushToken(@Nullable String pushToken) {
        this.pushToken = pushToken;
        return this;
    }

    @Nullable
    public String getUserData() {
        return this.userData;
    }

    public State setUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public long getReportedAt() {
        return this.reportedAt;
    }

    @Nullable
    public String getTags() {
        return this.tags;
    }

    public State setTags(String tags) {
        this.tags = tags;
        return this;
    }

    public State setTags(List<String> tags) {
        this.tags = State.getTagsAsString(tags);
        return this;
    }

    @Nullable
    public String getUserAttributes() {
        return this.userAttributes;
    }

    public State setUserAttributes(String userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    @Nullable
    public String getNetworkLogs() {
        return this.networkLogs;
    }

    @Nullable
    public String getUserEvents() {
        return this.userEvents;
    }

    public State setUserEvents(String userEvents) {
        this.userEvents = userEvents;
        return this;
    }

    public String getVisualUserSteps() {
        return VisualUserStep.toJsonString(this.visualUserSteps);
    }

    public ArrayList<StateItem> getStateItems() {
        ArrayList<StateItem> arrayList = new ArrayList<StateItem>();
        arrayList.add(new StateItem().setKey(KEY_APP_PACKAGE_NAME).setValue(this.getAppPackageName()));
        arrayList.add(new StateItem().setKey(KEY_APP_VERSION).setValue(this.getAppVersion()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_LEVEL).setValue(this.getBatteryLevel()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_STATUS).setValue(this.getBatteryState()));
        arrayList.add(new StateItem().setKey(KEY_CARRIER).setValue(this.getCarrier()));
        arrayList.add(new StateItem().setKey(KEY_CURRENT_VIEW).setValue(this.getCurrentView()));
        arrayList.add(new StateItem().setKey(KEY_DENSITY).setValue(this.getScreenDensity()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE).setValue(this.getDevice()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE_ROOTED).setValue(this.isDeviceRooted()));
        arrayList.add(new StateItem().setKey(KEY_DURATION).setValue(this.getDuration()));
        arrayList.add(new StateItem().setKey(KEY_EMAIL).setValue(this.getUserEmail()));
        arrayList.add(new StateItem().setKey(KEY_NAME).setValue(this.getUserName()));
        arrayList.add(new StateItem().setKey(KEY_PUSH_TOKEN).setValue(this.getPushToken()));
        arrayList.add(new StateItem().setKey(KEY_LOCALE).setValue(this.getLocale()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_FREE).setValue(this.getFreeMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_TOTAL).setValue(this.getTotalMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_USED).setValue(this.getUsedMemory()));
        arrayList.add(new StateItem().setKey(KEY_ORIENTATION).setValue(this.getScreenOrientation()));
        arrayList.add(new StateItem().setKey(KEY_OS).setValue(this.getOS()));
        arrayList.add(new StateItem().setKey(KEY_REPORTED_AT).setValue(this.getReportedAt()));
        arrayList.add(new StateItem().setKey(KEY_SCREEN_SIZE).setValue(this.getScreenSize()));
        arrayList.add(new StateItem().setKey(KEY_SDK_VERSION).setValue(this.getSdkVersion()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_FREE).setValue(this.getFreeStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_TOTAL).setValue(this.getTotalStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_USED).setValue(this.getUsedStorage()));
        arrayList.add(new StateItem().setKey(KEY_TAGS).setValue(this.getTags()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_SSID).setValue(this.getWifiSSID()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_STATE).setValue(this.isWifiEnable()));
        arrayList.add(new StateItem().setKey(KEY_USER_ATTRIBUTES).setValue(this.getUserAttributes()));
        arrayList.add(new StateItem().setKey(KEY_APP_STATUS).setValue(this.getAppStatus()));
        return arrayList;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        ArrayList<StateItem> arrayList = ((State)this_).getStateItems();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            jSONObject2.put(arrayList.get(i2).getKey(), arrayList.get(i2).getValue());
        }
        Serializable this_ = ((State)this_).getLogsItems();
        for (int i3 = 0; i3 < ((ArrayList)this_).size(); ++i3) {
            jSONObject2.put(((StateItem)((ArrayList)this_).get(i3)).getKey(), ((StateItem)((ArrayList)this_).get(i3)).getValue());
        }
        return jSONObject2.toString();
    }

    @Override
    public void fromJson(String stateAsJson) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject(stateAsJson).has(KEY_APP_PACKAGE_NAME)) {
            this.setAppPackageName(jSONObject2.getString(KEY_APP_PACKAGE_NAME));
        }
        if (jSONObject2.has(KEY_APP_VERSION)) {
            this.setAppVersion(jSONObject2.getString(KEY_APP_VERSION));
        }
        if (jSONObject2.has(KEY_BATTERY_LEVEL)) {
            this.setBatteryLevel(jSONObject2.getInt(KEY_BATTERY_LEVEL));
        }
        if (jSONObject2.has(KEY_BATTERY_STATUS)) {
            this.setBatteryState(jSONObject2.getString(KEY_BATTERY_STATUS));
        }
        if (jSONObject2.has(KEY_CARRIER)) {
            this.setCarrier(jSONObject2.getString(KEY_CARRIER));
        }
        if (jSONObject2.has(KEY_CONSOLE_LOG)) {
            this.setConsoleLog(a.a(new JSONArray(jSONObject2.getString(KEY_CONSOLE_LOG))));
        }
        if (jSONObject2.has(KEY_CURRENT_VIEW)) {
            this.setCurrentView(jSONObject2.getString(KEY_CURRENT_VIEW));
        }
        if (jSONObject2.has(KEY_DENSITY)) {
            this.setScreenDensity(jSONObject2.getString(KEY_DENSITY));
        }
        if (jSONObject2.has(KEY_DEVICE)) {
            this.setDevice(jSONObject2.getString(KEY_DEVICE));
        }
        if (jSONObject2.has(KEY_DEVICE_ROOTED)) {
            this.setIsDeviceRooted(jSONObject2.getBoolean(KEY_DEVICE_ROOTED));
        }
        if (jSONObject2.has(KEY_DURATION)) {
            this.setDuration(jSONObject2.getLong(KEY_DURATION));
        }
        if (jSONObject2.has(KEY_EMAIL)) {
            this.setUserEmail(jSONObject2.getString(KEY_EMAIL));
        }
        if (jSONObject2.has(KEY_NAME)) {
            this.setUserName(jSONObject2.getString(KEY_NAME));
        }
        if (jSONObject2.has(KEY_PUSH_TOKEN)) {
            this.setPushToken(jSONObject2.getString(KEY_PUSH_TOKEN));
        }
        if (jSONObject2.has(KEY_INSTABUG_LOG)) {
            this.setInstabugLog(jSONObject2.getString(KEY_INSTABUG_LOG));
        }
        if (jSONObject2.has(KEY_LOCALE)) {
            this.setLocale(jSONObject2.getString(KEY_LOCALE));
        }
        if (jSONObject2.has(KEY_MEMORY_FREE)) {
            this.setFreeMemory(jSONObject2.getLong(KEY_MEMORY_FREE));
        }
        if (jSONObject2.has(KEY_MEMORY_TOTAL)) {
            this.setTotalMemory(jSONObject2.getLong(KEY_MEMORY_TOTAL));
        }
        if (jSONObject2.has(KEY_MEMORY_USED)) {
            this.setUsedMemory(jSONObject2.getLong(KEY_MEMORY_USED));
        }
        if (jSONObject2.has(KEY_ORIENTATION)) {
            this.setScreenOrientation(jSONObject2.getString(KEY_ORIENTATION));
        }
        if (jSONObject2.has(KEY_OS)) {
            this.setOS(jSONObject2.getString(KEY_OS));
        }
        if (jSONObject2.has(KEY_APP_STATUS)) {
            this.setAppStatus(jSONObject2.getString(KEY_APP_STATUS));
        }
        if (jSONObject2.has(KEY_REPORTED_AT)) {
            this.setReportedAt(jSONObject2.getLong(KEY_REPORTED_AT));
        }
        if (jSONObject2.has(KEY_SCREEN_SIZE)) {
            this.setScreenSize(jSONObject2.getString(KEY_SCREEN_SIZE));
        }
        if (jSONObject2.has(KEY_SDK_VERSION)) {
            this.setSdkVersion(jSONObject2.getString(KEY_SDK_VERSION));
        }
        if (jSONObject2.has(KEY_STORAGE_FREE)) {
            this.setFreeStorage(jSONObject2.getLong(KEY_STORAGE_FREE));
        }
        if (jSONObject2.has(KEY_STORAGE_TOTAL)) {
            this.setTotalStorage(jSONObject2.getLong(KEY_STORAGE_TOTAL));
        }
        if (jSONObject2.has(KEY_STORAGE_USED)) {
            this.setUsedStorage(jSONObject2.getLong(KEY_STORAGE_USED));
        }
        if (jSONObject2.has(KEY_TAGS)) {
            this.setTags(jSONObject2.getString(KEY_TAGS));
        }
        if (jSONObject2.has(KEY_USER_DATA)) {
            this.setUserData(jSONObject2.getString(KEY_USER_DATA));
        }
        if (jSONObject2.has(KEY_USER_STEPS)) {
            this.setUserSteps(k.a(new JSONArray(jSONObject2.getString(KEY_USER_STEPS))));
        }
        if (jSONObject2.has(KEY_WIFI_SSID)) {
            this.setWifiSSID(jSONObject2.getString(KEY_WIFI_SSID));
        }
        if (jSONObject2.has(KEY_WIFI_STATE)) {
            this.setWifiState(jSONObject2.getBoolean(KEY_WIFI_STATE));
        }
        if (jSONObject2.has(KEY_USER_ATTRIBUTES)) {
            this.setUserAttributes(jSONObject2.getString(KEY_USER_ATTRIBUTES));
        }
        if (jSONObject2.has(KEY_NETWORK_LOGS)) {
            this.setNetworkLogs(jSONObject2.getString(KEY_NETWORK_LOGS));
        }
        if (jSONObject2.has(KEY_USER_EVENTS)) {
            this.setUserEvents(jSONObject2.getString(KEY_USER_EVENTS));
        }
        if (jSONObject2.has(KEY_VISUAL_USER_STEPS)) {
            this.setVisualUserSteps(VisualUserStep.fromJson(new JSONArray(jSONObject2.getString(KEY_VISUAL_USER_STEPS))));
        }
        if (jSONObject2.has(KEY_SESSIONS_PROFILER)) {
            this.setSessionProfilerTimeline(e.a(new JSONObject(jSONObject2.getString(KEY_SESSIONS_PROFILER))));
        }
    }

    public ArrayList<StateItem> getLogsItems() {
        ArrayList<StateItem> arrayList;
        ArrayList<StateItem> arrayList2 = arrayList;
        new ArrayList<StateItem>().add(new StateItem().setKey(KEY_CONSOLE_LOG).setValue(this.getConsoleLog().toString()));
        arrayList2.add(new StateItem().setKey(KEY_INSTABUG_LOG).setValue(this.getInstabugLog()));
        arrayList2.add(new StateItem().setKey(KEY_USER_DATA).setValue(this.getUserData()));
        arrayList2.add(new StateItem().setKey(KEY_NETWORK_LOGS).setValue(this.getNetworkLogs()));
        arrayList2.add(new StateItem().setKey(KEY_USER_EVENTS).setValue(this.getUserEvents()));
        if (d.c().a((Object)Feature.TRACK_USER_STEPS) == Feature.State.ENABLED) {
            arrayList2.add(new StateItem().setKey(KEY_USER_STEPS).setValue(this.getUserSteps().toString()));
        }
        if (d.c().a((Object)Feature.REPRO_STEPS) == Feature.State.ENABLED) {
            arrayList2.add(new StateItem().setKey(KEY_VISUAL_USER_STEPS).setValue(this.getVisualUserSteps()));
        }
        if (d.c().a((Object)Feature.SESSION_PROFILER) == Feature.State.ENABLED && this.sessionProfilerTimeline != null) {
            arrayList2.add(new StateItem().setKey(KEY_SESSIONS_PROFILER).setValue(this.getSessionProfilerTimeline()));
        }
        return arrayList2;
    }

    @NonNull
    public String toString() {
        try {
            return this_.toJson();
        }
        catch (JSONException jSONException) {
            Object this_ = jSONException;
            jSONException.printStackTrace();
            InstabugSDKLogger.e(TAG, "Something went wrong while getting state.toString()" + this_.getMessage(), (Throwable)this_);
            return "error";
        }
    }

    public boolean equals(Object state) {
        if (state instanceof State) {
            State state2;
            return String.valueOf((state2 = (State)state2).getAppVersion()).equals(String.valueOf(this.getAppVersion())) && state2.getBatteryLevel() == this.getBatteryLevel() && String.valueOf(state2.getBatteryState()).equals(String.valueOf(this.getBatteryState())) && String.valueOf(state2.getCarrier()).equals(String.valueOf(this.getCarrier())) && String.valueOf(state2.getAppStatus()).equals(String.valueOf(this.getAppStatus())) && String.valueOf(state2.getConsoleLog()).equals(String.valueOf(this.getConsoleLog())) && String.valueOf(state2.getCurrentView()).equals(String.valueOf(this.getCurrentView())) && state2.getDuration() == this.getDuration() && String.valueOf(state2.getDevice()).equals(String.valueOf(this.getDevice())) && state2.getFreeMemory() == this.getFreeMemory() && state2.getFreeStorage() == this.getFreeStorage() && String.valueOf(state2.getLocale()).equals(String.valueOf(this.getLocale())) && String.valueOf(state2.getOS()).equals(String.valueOf(this.getOS())) && state2.getReportedAt() == this.getReportedAt() && String.valueOf(state2.getScreenDensity()).equals(String.valueOf(this.getScreenDensity())) && String.valueOf(state2.getScreenOrientation()).equals(String.valueOf(this.getScreenOrientation())) && String.valueOf(state2.getScreenSize()).equals(String.valueOf(this.getScreenSize())) && String.valueOf(state2.getSdkVersion()).equals(String.valueOf(this.getSdkVersion())) && state2.getTotalMemory() == this.getTotalMemory() && state2.getTotalStorage() == this.getTotalStorage() && String.valueOf(state2.getTags()).equals(String.valueOf(this.getTags())) && state2.getUsedMemory() == this.getUsedMemory() && state2.getUsedStorage() == this.getUsedStorage() && String.valueOf(state2.getUserData()).equals(String.valueOf(this.getUserData())) && String.valueOf(state2.getUserEmail()).equals(String.valueOf(this.getUserEmail())) && String.valueOf(state2.getUserName()).equals(String.valueOf(this.getUserName())) && String.valueOf(state2.getPushToken()).equals(String.valueOf(this.getPushToken())) && String.valueOf(state2.getUserSteps()).equals(String.valueOf(this.getUserSteps())) && String.valueOf(state2.getWifiSSID()).equals(String.valueOf(this.getWifiSSID())) && state2.isDeviceRooted() == this.isDeviceRooted() && state2.isWifiEnable() == this.isWifiEnable() && String.valueOf(state2.getInstabugLog()).equals(String.valueOf(this.getInstabugLog())) && String.valueOf(state2.getUserAttributes()).equals(String.valueOf(this.getUserAttributes())) && String.valueOf(state2.getNetworkLogs()).equals(String.valueOf(this.getNetworkLogs())) && String.valueOf(state2.getUserEvents()).equals(String.valueOf(this.getUserEvents())) && String.valueOf(state2.getVisualUserSteps()).equals(String.valueOf(this.getVisualUserSteps())) && String.valueOf(state2.getSessionProfilerTimeline()).equals(String.valueOf(this.getSessionProfilerTimeline()));
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.getReportedAt()).hashCode();
    }

    public void updateVisualUserSteps() {
        this.setVisualUserSteps(Builder.getVisualUserSteps());
    }

    public static class Builder
    implements Serializable {
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        private static ArrayList<a> getConsoleLog(ArrayList<a> consoleLogs) {
            ArrayList<a> arrayList = Builder.getConsoleLog();
            arrayList.addAll(consoleLogs);
            return arrayList;
        }

        /*
         * Unable to fully structure code
         */
        private static ArrayList<a> getConsoleLog() {
            var0 = v0;
            v0 = new ArrayList<a>();
            if (d.c().a((Object)Feature.CONSOLE_LOGS) == Feature.State.ENABLED) {
                block17: {
                    var1_1 = 700;
                    var2_4 = Runtime.getRuntime().exec("logcat -v time -d " + Process.myPid());
                    var3_5 = v1;
                    v1 = new BufferedReader(new InputStreamReader(var2_4.getInputStream(), Charset.forName("UTF-8")));
                    var2_4 = v2;
                    v2 = new ArrayList<E>();
                    ** while ((var4_7 = var3_5.readLine()) != null)
lbl-1000:
                    // 1 sources

                    {
                        var2_4.add(var4_7);
                        continue;
                    }
lbl19:
                    // 2 sources

                    v3 = var2_4;
                    v4 = v3;
                    var3_5.close();
                    v3.trimToSize();
                    var3_6 = 0;
                    if (v4.size() <= var1_1) break block17;
                    var3_6 = var2_4.size() - var1_1;
                }
                while (true) {
                    block18: {
                        if (var3_6 >= var2_4.size()) break;
                        if (((String)var2_4.get(var3_6)).length() <= 18) break block18;
                        v5 = var0;
                        var1_2 = v6;
                        var1_2();
                        var1_2.a(((String)var2_4.get(var3_6)).substring(18));
                        v6.a(a.b(((String)var2_4.get(var3_6)).substring(0, 18)));
                        v5.add(v6);
                    }
                    ++var3_6;
                }
                try {
                    var2_4.clear();
                    return var0;
                }
                catch (IOException var1_3) {
                    InstabugSDKLogger.e("State", "Could not read logcat log", var1_3);
                    return var0;
                }
            }
            return var0;
        }

        private String getInstabugLog() {
            if (d.c().a((Object)Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
                return InstabugLog.getLogs();
            }
            return null;
        }

        private ArrayList<k> getUserSteps() {
            return com.instabug.library.tracking.e.c().b();
        }

        private static ArrayList<VisualUserStep> getVisualUserSteps() {
            return h.d().a();
        }

        private e getSessionProfilerTimeline() {
            return com.instabug.library.m.a.d().a();
        }

        private String getUserEmail() {
            return b.i();
        }

        private String getUserName() {
            return b.j();
        }

        private String getPushNotificationToken() {
            return InstabugCore.getPushNotificationToken();
        }

        private String getUserData() {
            return SettingsManager.getInstance().getUserData();
        }

        private long getReportedAt() {
            return InstabugDateFormatter.getCurrentUTCTimeStampInSeconds();
        }

        private String getTags() {
            return SettingsManager.getInstance().getTagsAsString();
        }

        private String getUserEvents() {
            try {
                return UserEvent.toJson(InstabugUserEventLogger.getInstance().getUserEvents()).toString();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(State.TAG, "Got error while parsing user events logs", jSONException);
                return "";
            }
        }

        /*
         * WARNING - void declaration
         */
        public State build(boolean withInstabugLogs) {
            void var1_1;
            State state = new State().setSdkVersion(DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()).setIsDeviceRooted(DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context));
            String string2 = InstabugCore.getStartedActivitiesCount() > 0 ? State.VALUE_APP_STATUS_FOREGROUND : State.VALUE_APP_STATUS_BACKGROUND;
            State state2 = state.setAppStatus(string2).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)).setWifiState(DeviceStateProvider.getWifiState(this.context)).setWifiSSID(DeviceStateProvider.getWifiSSID(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)).setUsedMemory(DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)).setFreeStorage(DeviceStateProvider.getFreeStorage()).setUsedStorage(DeviceStateProvider.getUsedStorage()).setTotalStorage(DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(DeviceStateProvider.getCurrentView()).setConsoleLog(Builder.getConsoleLog()).setUserSteps(this.getUserSteps()).setUserEmail(this.getUserEmail()).setUserName(this.getUserName()).setPushToken(this.getPushNotificationToken()).setUserData(this.getUserData()).setReportedAt(this.getReportedAt()).setTags(this.getTags()).setUserAttributes(UserAttributesDbHelper.getSDKUserAttributes()).setNetworkLogs(this.getNetworkLogs()).setUserEvents(this.getUserEvents()).setSessionProfilerTimeline(this.getSessionProfilerTimeline());
            if (var1_1 != false) {
                state2.setInstabugLog(this.getInstabugLog());
            }
            return state2;
        }

        public State buildInternalState() {
            State state = new State().setSdkVersion(DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()).setIsDeviceRooted(DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context));
            String string2 = InstabugCore.getStartedActivitiesCount() > 0 ? State.VALUE_APP_STATUS_FOREGROUND : State.VALUE_APP_STATUS_BACKGROUND;
            return state.setAppStatus(string2).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)).setWifiState(DeviceStateProvider.getWifiState(this.context)).setWifiSSID(DeviceStateProvider.getWifiSSID(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)).setUsedMemory(DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)).setFreeStorage(DeviceStateProvider.getFreeStorage()).setUsedStorage(DeviceStateProvider.getUsedStorage()).setTotalStorage(DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(DeviceStateProvider.getCurrentView()).setReportedAt(this.getReportedAt());
        }

        /*
         * WARNING - void declaration
         */
        public String formatSessionDuration(long d22) {
            void var1_2;
            StringBuilder stringBuilder;
            long l2 = d22;
            Serializable this_ = stringBuilder;
            stringBuilder = new StringBuilder();
            int d22 = (int)l2 % 60;
            long l3 = l2 / 60L;
            int n = (int)l3 % 60;
            int n2 = (int)(l3 / 60L) % 60;
            if (n2 <= 9) {
                ((StringBuilder)this_).append("0");
            }
            Serializable serializable = this_;
            ((StringBuilder)serializable).append(n2);
            ((StringBuilder)serializable).append(":");
            if (n <= 9) {
                ((StringBuilder)this_).append("0");
            }
            Serializable serializable2 = this_;
            ((StringBuilder)serializable2).append(n);
            ((StringBuilder)serializable2).append(":");
            if (var1_2 <= 9) {
                ((StringBuilder)this_).append("0");
            }
            Serializable serializable3 = this_;
            ((StringBuilder)serializable3).append((int)var1_2);
            return ((StringBuilder)serializable3).toString();
        }

        String getNetworkLogs() {
            return com.instabug.library.logging.b.a();
        }
    }

    public static class StateItem<V>
    implements Serializable {
        @Nullable
        String key;
        @Nullable
        V value;

        @Nullable
        public String getKey() {
            return this.key;
        }

        public StateItem<V> setKey(String key) {
            this.key = key;
            return this;
        }

        @Nullable
        public V getValue() {
            return this.value;
        }

        public StateItem<V> setValue(V value) {
            this.value = value;
            return this;
        }

        @NonNull
        public String toString() {
            return "key: " + this.getKey() + ", value: " + this.getValue();
        }
    }

    @Keep
    public static enum Action {
        FINISHED,
        ERROR;

    }
}

