/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.Nullable;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.concurrent.atomic.AtomicInteger;

public class SQLiteDatabaseWrapper {
    public static final String TAG = "SQLiteDatabaseWrapper";
    private AtomicInteger mOpenCounter = new AtomicInteger();
    @Nullable
    private SQLiteDatabase database;
    private SQLiteOpenHelper databaseHelper;

    SQLiteDatabaseWrapper(SQLiteOpenHelper helper) {
        this.databaseHelper = helper;
    }

    private boolean databaseInitializedAndOpen() {
        SQLiteDatabaseWrapper this_ = this_.database;
        return this_ != null && this_.isOpen();
    }

    private void logOperationFailedWarning() {
        SQLiteDatabaseWrapper this_ = this_.database;
        if (this_ == null) {
            InstabugSDKLogger.w(TAG, "Attempted to do operation on an uninitialized database. Falling back silently");
        } else if (!this_.isOpen()) {
            InstabugSDKLogger.w(TAG, "Attempted to do operation on a closed database. Falling back silently");
        } else {
            InstabugSDKLogger.w(TAG, "Failed to do database operation. Falling back silently");
        }
    }

    synchronized void open() {
        if (this.mOpenCounter.incrementAndGet() == 1) {
            try {
                this.database = this.databaseHelper.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                InstabugSDKLogger.e(this, "Error while opening the DB: " + sQLiteException.getMessage(), sQLiteException);
            }
        }
    }

    public synchronized void close() {
        if (this.mOpenCounter.decrementAndGet() == 0) {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase == null) {
                this.logOperationFailedWarning();
            } else if (sQLiteDatabase.isOpen()) {
                this.database.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beginTransaction() {
        try {
            if (this.databaseInitializedAndOpen()) {
                this.database.beginTransaction();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB transaction failed: " + exception.getMessage(), exception);
            this.logOperationFailedWarning();
            return;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB transaction failed: " + sQLException.getMessage(), sQLException);
            this.logOperationFailedWarning();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.insert((String)var1_1, (String)var2_3, (ContentValues)var3_4);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB insertion failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insertWithOnConflict(String tableName, String nullColumnHack, ContentValues values) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.insertWithOnConflict((String)var1_1, (String)var2_3, (ContentValues)var3_4, 4);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB insertion with on conflict failed: " + sQLException.getMessage(), sQLException);
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insertWithOnConflictReplace(String tableName, String nullColumnHack, ContentValues values) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.insertWithOnConflict((String)var1_1, (String)var2_3, (ContentValues)var3_4, 5);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB insertion with on conflict replace failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execSQL(String sql) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var1_1;
                this.database.execSQL((String)var1_1);
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB execution a sql failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTransactionSuccessful() {
        try {
            if (this.databaseInitializedAndOpen()) {
                this.database.setTransactionSuccessful();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB transaction not successful due to: " + sQLException.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void endTransaction() {
        try {
            if (this.databaseInitializedAndOpen()) {
                this.database.endTransaction();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB end transaction not successful due to: " + sQLException.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Cursor rawQuery(String sql, String[] selectionArgs) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var2_3;
                void var1_1;
                return this.database.rawQuery((String)var1_1, (String[])var2_3);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB raw query failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String table, String whereClause, String[] whereArgs) {
        block5: {
            block4: {
                void var3_4;
                void var2_3;
                void var1_1;
                if (!this.databaseInitializedAndOpen()) break block4;
                this.database.delete((String)var1_1, (String)var2_3, (String[])var3_4);
                break block5;
            }
            try {
                this.logOperationFailedWarning();
            }
            catch (SQLException sQLException) {
                InstabugSDKLogger.e(TAG, "DB deletion failed: " + sQLException.getMessage());
                this.logOperationFailedWarning();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var4_5;
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.update((String)var1_1, (ContentValues)var2_3, (String)var3_4, (String[])var4_5);
            }
            this.logOperationFailedWarning();
            return -1;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB update failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var7_8;
                void var6_7;
                void var5_6;
                void var4_5;
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.query((String)var1_1, (String[])var2_3, (String)var3_4, (String[])var4_5, (String)var5_6, (String)var6_7, (String)var7_8);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB query failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var8_9;
                void var7_8;
                void var6_7;
                void var5_6;
                void var4_5;
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.query((String)var1_1, (String[])var2_3, (String)var3_4, (String[])var4_5, (String)var5_6, (String)var6_7, (String)var7_8, (String)var8_9);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB query failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long queryNumEntries(String tableName) {
        try {
            if (this.databaseInitializedAndOpen()) {
                void var1_1;
                return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)var1_1);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (SQLException sQLException) {
            InstabugSDKLogger.e(TAG, "DB query num entries failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }
}

