/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AttachmentManager {
    public static final String TAG = "AttachmentManager";
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    public static File getAttachmentDirectory(Context context) {
        File file;
        Object object;
        if (context == null && Instabug.isBuilt()) {
            object = Instabug.getApplicationContext();
        }
        if (object == null) {
            return null;
        }
        if (object.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                object = AttachmentManager.getInternalStoragePath(object);
            }
        } else {
            object = AttachmentManager.getInternalStoragePath(object);
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getNewDirectory(Context context, String directoryName) {
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context) + "/" + directoryName + "/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        context = AttachmentManager.getVideoRecordingVideosDirectory(context);
        Object object = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.getDefault());
        object = "video-" + ((DateFormat)object).format(new Date()) + ".mp4";
        return new File((File)context, (String)object);
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context) + "/frames/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoRecordingVideosDirectory(Context context) {
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context) + "/videos/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getAutoScreenRecordingVideosDirectory(Context context) {
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context) + "/auto_recording/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getAutoScreenRecordingFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        context = AttachmentManager.getAutoScreenRecordingVideosDirectory(context);
        Object object = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object = "auto-recording-" + ((DateFormat)object).format(new Date()) + ".mp4";
        return new File((File)context, (String)object);
    }

    private static String getInternalStoragePath(Context context) {
        InstabugSDKLogger.w(TAG, "External storage not available, saving file to internal storage.");
        return context.getFilesDir().getAbsolutePath();
    }

    private static void saveBytesToFile(byte[] data, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(data);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    private static File getAttachmentFile(Context context, String fileName) {
        File file;
        context = AttachmentManager.getAttachmentDirectory(context);
        File file2 = file;
        if (new File((File)context, fileName).exists()) {
            void var1_1;
            Context context2;
            File file3;
            file2 = file3;
            file3 = new File((File)context2, String.valueOf(System.currentTimeMillis()) + "_" + (String)var1_1);
        }
        return file2;
    }

    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        Object object = AttachmentManager.getAttachmentFile(context, fileName);
        try {
            AttachmentManager.saveBytesToFile(data, (File)object);
        }
        catch (IOException iOException) {
            object = iOException;
            InstabugSDKLogger.e(TAG, iOException.getMessage(), (Throwable)object);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFromUriIntoFile(Context context, Uri source, File target) throws IOException {
        void var1_1;
        int n;
        BufferedOutputStream bufferedOutputStream;
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2 = bufferedInputStream;
        bufferedInputStream = new BufferedInputStream(context.getContentResolver().openInputStream(source));
        InstabugSDKLogger.d(TAG, "Target file path: " + target.getPath());
        source = bufferedOutputStream;
        bufferedOutputStream = new BufferedOutputStream(context.getContentResolver().openOutputStream(Uri.fromFile((File)target)));
        Object object = new byte[32768];
        while ((n = bufferedInputStream2.read((byte[])object)) > 0) {
            var1_1.write((byte[])object, 0, n);
        }
        var1_1.close();
        bufferedInputStream2.close();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        void var1_1;
        if (activity != null && var1_1 != null) {
            Activity activity2;
            if ((activity2 = activity2.managedQuery((Uri)var1_1, new String[]{"_data"}, null, null, null)) != null) {
                Activity activity3 = activity2;
                int n = activity3.getColumnIndexOrThrow("_data");
                activity2.moveToFirst();
                return activity3.getString(n);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileUri(Context context, Uri originalUri, String fileNameWithExtension) {
        File file;
        block4: {
            Context context2;
            void var1_2;
            if (originalUri == null) {
                return null;
            }
            String string2 = var1_2.getLastPathSegment().toLowerCase();
            if (file != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(var1_2)) {
                string2 = file;
            }
            file = AttachmentManager.getAttachmentFile(context2, string2);
            try {
                AttachmentManager.copyFromUriIntoFile(context2, (Uri)var1_2, file);
                if (AttachmentManager.validateFileSize((Uri)var1_2, file)) break block4;
                return null;
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
                return null;
            }
        }
        return Uri.fromFile((File)file);
    }

    public static Uri getNewFileUri(Context context, Uri originalUri) {
        return AttachmentManager.getNewFileUri(context, originalUri, null);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateFileSize(Uri uri, File attachmentFile) {
        if (SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri)) {
            double d2;
            void var1_2;
            double d3 = (double)var1_2.length() / 1048576.0;
            if (d2 > 50.0) {
                InstabugSDKLogger.w(TAG, "Attachment size is" + d3 + ", exceeds " + 50.0 + " MBs file size limit, ignoring attachment");
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void saveBitmap(Bitmap bitmap, Context context, a callback) {
        block5: {
            context /* !! */  = AttachmentManager.getAttachmentDirectory(context /* !! */ );
            var3_4 = v0;
            v0 = new File((File)context /* !! */ , "bug_" + System.currentTimeMillis() + "_.jpg");
            InstabugSDKLogger.v("AttachmentManager", "image path: " + var3_4.toString());
            var1_2 = v1;
            var1_2(new FileOutputStream(var3_4));
            var0.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)var1_2);
            v1.close();
            var0 = Uri.fromFile((File)v0);
            if (var0 == null) ** GOTO lbl17
            try {
                var2_3.onSuccess((Uri)var0);
                break block5;
lbl17:
                // 1 sources

                var2_3.onError(new Throwable("Uri equal null"));
            }
            catch (IOException var0_1) {
                var2_3.onError(var0_1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void saveBitmap(Bitmap bitmap, File attachmentDirectory, a callback) {
        block11: {
            block12: {
                block10: {
                    var3_4 = v0;
                    v0 = new File(attachmentDirectory, "frame_" + System.currentTimeMillis() + "_.jpg");
                    InstabugSDKLogger.v("AttachmentManager", "video frame path: " + var3_4.toString());
                    var1_2 = v1;
                    v1 = new BufferedOutputStream(new FileOutputStream(var3_4));
                    if (bitmap.getWidth() <= var0.getHeight()) break block10;
                    v2 = var0.getWidth();
lbl10:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
                }
                v2 = var0.getHeight();
                ** continue;
                var4_5 = v2;
                if (var4_5 <= 640) break block12;
                v3 = AttachmentManager.resizeBitmap(var0, 640).compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_2);
lbl20:
                // 2 sources

                while (true) {
                    ** GOTO lbl26
                    break;
                }
            }
            v3 = AttachmentManager.resizeBitmap(var0, 320).compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_2);
            ** continue;
lbl26:
            // 1 sources

            var1_2.close();
            var0 = Uri.fromFile((File)var3_4);
            if (var0 == null) ** GOTO lbl32
            try {
                var2_3.onSuccess((Uri)var0);
                break block11;
lbl32:
                // 1 sources

                var2_3.onError(new Throwable("Uri equal null"));
            }
            catch (IOException var0_1) {
                var2_3.onError(var0_1);
            }
        }
    }

    private static Bitmap resizeBitmap(Bitmap image, int maxSize) {
        Bitmap bitmap;
        int n;
        int n2;
        float f2;
        Bitmap bitmap2 = image;
        int n3 = bitmap2.getWidth();
        float f3 = (float)n3 / (float)bitmap2.getHeight();
        if (f2 > 1.0f) {
            n = (int)((float)n2 / f3);
            void v2 = n2;
            n2 = n;
            n = v2;
        } else {
            n = (int)((float)n2 * f3);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)n2, (boolean)false);
    }

    public static void deleteRecursive(File fileOrDirectory) {
        File file;
        if (fileOrDirectory.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                int n = fileArray.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    AttachmentManager.deleteRecursive(fileArray[i2]);
                }
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static interface a {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

