/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.Pair;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.k.e.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public final class ScreenshotTaker {
    private ScreenshotTaker() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Observable<Bitmap> getScreenshotBitmap(Activity activity, @Nullable @IdRes int[] ignoredViewsIds) {
        void var1_1;
        Activity activity2;
        if (activity == null) throw new IllegalArgumentException("Parameter activity cannot be null.");
        View view = activity2.getWindow().getDecorView();
        List<RootViewInfo> list = FieldHelper.getRootViews(activity2, (int[])var1_1);
        InstabugSDKLogger.d(ScreenshotTaker.class, "viewRoots count: " + list.size());
        try {
            activity2 = (long)(view.getWidth() * view.getHeight() * 4) < a.a((Context)activity2) ? Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            return ScreenshotTaker.drawRootsToBitmap(list, (Bitmap)activity2, (int[])var1_1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    private static Observable<Bitmap> drawRootsToBitmap(List<RootViewInfo> viewRoots, final Bitmap bitmap, final @Nullable @IdRes int[] ignoredViewsIds) {
        return Observable.fromIterable(viewRoots).flatMap((Function)new Function<RootViewInfo, ObservableSource<Bitmap>>(){

            public ObservableSource<Bitmap> a(RootViewInfo rootViewInfo) throws Exception {
                return ScreenshotTaker.drawRootToBitmap(rootViewInfo, bitmap, ignoredViewsIds);
            }
        });
    }

    private static Observable<Bitmap> drawRootToBitmap(final RootViewInfo rootViewInfo, final Bitmap bitmap, final @Nullable @IdRes int[] ignoredViewsIds) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Pair<Canvas, HashMap<View, Integer>>>(){

            public void subscribe(ObservableEmitter<Pair<Canvas, HashMap<View, Integer>>> observableEmitter) throws Exception {
                HashMap<View, Integer> hashMap;
                Canvas canvas;
                if ((rootViewInfo.getLayoutParams().flags & 2) == 2) {
                    new Canvas(bitmap).drawARGB((int)(rootViewInfo.getLayoutParams().dimAmount * 255.0f), 0, 0, 0);
                }
                Canvas canvas2 = canvas;
                canvas2(bitmap);
                canvas.translate((float)rootViewInfo.getLeft(), (float)rootViewInfo.getTop());
                HashMap<View, Integer> hashMap2 = hashMap;
                hashMap = new HashMap<View, Integer>();
                if (ignoredViewsIds != null) {
                    for (int i2 = 0; i2 < ignoredViewsIds.length; ++i2) {
                        View view = rootViewInfo.getView().findViewById(ignoredViewsIds[i2]);
                        if (view == null) continue;
                        View view2 = view;
                        hashMap2.put(view2, view2.getVisibility());
                    }
                }
                observableEmitter.onNext((Object)new Pair((Object)canvas2, hashMap2));
            }
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).map((Function)new Function<Pair<Canvas, HashMap<View, Integer>>, Pair<Canvas, HashMap<View, Integer>>>(){

            public Pair<Canvas, HashMap<View, Integer>> a(Pair<Canvas, HashMap<View, Integer>> pair) throws Exception {
                Iterator iterator = ((HashMap)pair.second).keySet().iterator();
                while (iterator.hasNext()) {
                    ((View)iterator.next()).setVisibility(4);
                }
                rootViewInfo.getView().draw((Canvas)pair.first);
                return pair;
            }
        }).observeOn(Schedulers.single()).map((Function)new Function<Pair<Canvas, HashMap<View, Integer>>, HashMap<View, Integer>>(){

            public HashMap<View, Integer> a(Pair<Canvas, HashMap<View, Integer>> pair) throws Exception {
                c c2 = this;
                ScreenshotTaker.drawUnDrawableViews(c2.rootViewInfo.getView(), (Canvas)pair.first);
                BitmapUtils.maskBitmap(c2.bitmap, SettingsManager.getInstance(), (Canvas)pair.first);
                return (HashMap)pair.second;
            }
        }).observeOn(AndroidSchedulers.mainThread()).map((Function)new Function<HashMap<View, Integer>, Bitmap>(){

            public Bitmap a(HashMap<View, Integer> object) throws Exception {
                for (Map.Entry entry : ((HashMap)((Object)object)).entrySet()) {
                    ((View)entry.getKey()).setVisibility(((Integer)entry.getValue()).intValue());
                }
                return bitmap;
            }
        });
    }

    public static boolean isVisible(View view) {
        View view2;
        if (!view.isShown()) {
            return false;
        }
        Rect rect = new Rect();
        view2.getGlobalVisibleRect(rect);
        int n = DisplayUtils.getDisplayWidthInPx(Instabug.getApplicationContext());
        int n2 = DisplayUtils.getDisplayHeightInPx(Instabug.getApplicationContext());
        return rect.intersect(new Rect(0, 0, n, n2));
    }

    public static Rect getVisibleRect(@Nullable View childView) {
        View view;
        Rect rect;
        Rect rect2 = rect;
        rect = new Rect();
        if (childView != null && view.getVisibility() == 0 && view.getRootView().getParent() != null) {
            if (!view.getGlobalVisibleRect(rect2)) {
                return new Rect(0, 0, 0, 0);
            }
            return rect2;
        }
        return new Rect(0, 0, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static ArrayList<View> drawUnDrawableViews(View v, Canvas canvas) {
        ArrayList<View> arrayList;
        View view;
        if (!(v instanceof ViewGroup)) {
            ArrayList<View> arrayList2 = new ArrayList<View>();
            arrayList2.add(view);
            return arrayList2;
        }
        ArrayList<View> arrayList3 = arrayList;
        arrayList = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)view;
        for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
            void var1_1;
            ArrayList<View> arrayList4;
            View view2 = viewGroup.getChildAt(i2);
            ArrayList<View> arrayList5 = arrayList4;
            arrayList5();
            arrayList5.add(view);
            arrayList4.addAll(ScreenshotTaker.drawUnDrawableViews(view2, (Canvas)var1_1));
            int[] nArray = new int[2];
            view2.getLocationOnScreen(nArray);
            if (Build.VERSION.SDK_INT >= 14 && view2 instanceof TextureView) {
                ScreenshotTaker.drawTextureView((TextureView)view2, nArray, (Canvas)var1_1);
            }
            if (view2 instanceof GLSurfaceView) {
                ScreenshotTaker.drawGLSurfaceView((GLSurfaceView)view2, nArray, (Canvas)var1_1);
            }
            if (Build.VERSION.SDK_INT >= 11 && view2 instanceof WebView) {
                ScreenshotTaker.drawWebView((WebView)view2, (Canvas)var1_1);
            }
            arrayList3.addAll(arrayList5);
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    public static void drawGLSurfaceView(GLSurfaceView surfaceView, int[] locationOnScreen, Canvas canvas) {
        InstabugSDKLogger.d(ScreenshotTaker.class, "Drawing GLSurfaceView");
        if (surfaceView.getWindowToken() != null) {
            void var1_1;
            void var2_2;
            Paint paint;
            CountDownLatch countDownLatch;
            Object object;
            final int n = object.getWidth();
            final int n2 = object.getHeight();
            int[] nArray = new int[n * (n2 + 0)];
            final IntBuffer intBuffer = IntBuffer.wrap(nArray);
            intBuffer.position(0);
            final CountDownLatch countDownLatch2 = countDownLatch;
            countDownLatch2(1);
            object.queueEvent(new Runnable(){

                @Override
                public void run() {
                    EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                    eGL10.eglWaitGL();
                    GL10 gL10 = (GL10)eGL10.eglGetCurrentContext().getGL();
                    gL10.glFinish();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    f f2 = this;
                    int n3 = f2.n;
                    int n22 = f2.n2 + 0;
                    IntBuffer intBuffer2 = f2.intBuffer;
                    gL10.glReadPixels(0, 0, n3, n22, 6408, 5121, (Buffer)intBuffer2);
                    countDownLatch2.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            object = new int[n * n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                for (int i2 = 0; i2 < n; ++i2) {
                    int n5 = nArray[n3 * n + i2];
                    int n6 = n5 >> 16 & 0xFF;
                    int n7 = n5 << 16 & 0xFF0000;
                    n6 = n5 & 0xFF00FF00 | n7 | n6;
                    object[(n2 - n4 - 1) * n + i2] = (GLSurfaceView)n6;
                }
                ++n3;
                ++n4;
            }
            Bitmap bitmap = Bitmap.createBitmap((int[])object, (int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            object = paint;
            new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            var2_2.drawBitmap(bitmap, (float)var1_1[0], (float)var1_1[1], (Paint)object);
            bitmap.recycle();
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public static void drawTextureView(TextureView textureView, int[] locationOnScreen, Canvas canvas) {
        block7: {
            Paint paint;
            void var1_2;
            void var2_3;
            InstabugSDKLogger.d(ScreenshotTaker.class, "Drawing TextureView");
            TextureView textureView2 = textureView.getBitmap();
            if (textureView2 == null) break block7;
            TextureView textureView3 = textureView2;
            void v1 = var2_3;
            TextureView textureView4 = textureView2;
            void v3 = var1_2;
            textureView2 = paint;
            new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            float f2 = (float)v3[0];
            float f3 = (float)var1_2[1];
            try {
                v1.drawBitmap((Bitmap)textureView4, f2, f3, (Paint)textureView2);
                textureView3.recycle();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(ScreenshotTaker.class, ScreenshotTaker.class.getSimpleName(), outOfMemoryError);
            }
        }
    }

    @TargetApi(value=11)
    public static void drawWebView(WebView webView, Canvas canvas) {
        int n = webView.getLayerType();
        if (n == 2) {
            WebView webView2;
            WebView webView3 = webView2;
            webView3.setLayerType(0, null);
            webView3.setDrawingCacheEnabled(true);
            webView3.buildDrawingCache(true);
            Object object = webView3.getDrawingCache();
            if (object != null) {
                Paint paint;
                Paint paint2;
                Bitmap bitmap = object;
                void v2 = paint2;
                Bitmap bitmap2 = object;
                paint2 = paint;
                new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                int[] nArray = new int[2];
                object = nArray;
                webView2.getLocationOnScreen((int[])object);
                v2.drawBitmap(bitmap2, (float)nArray[0], (float)object[1], paint2);
                bitmap.recycle();
            }
            webView2.setDrawingCacheEnabled(false);
            webView2.setLayerType(n, null);
        }
    }
}

