/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class ScaleImageView
extends ImageView
implements View.OnTouchListener {
    private Context mContext;
    private float MAX_SCALE = 5.0f;
    private Matrix mMatrix;
    private final float[] mMatrixValues = new float[9];
    private int mWidth;
    private int mHeight;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private float mScale;
    private float mMinScale;
    private float mPrevDistance;
    private boolean isScaling;
    private int mPrevMoveX;
    private int mPrevMoveY;
    private GestureDetector mDetector;

    public ScaleImageView(Context context, AttributeSet attr2) {
        super(context, attr2);
        this.mContext = context;
        this.initialize();
    }

    public ScaleImageView(Context context) {
        super(context);
        this.mContext = context;
        this.initialize();
    }

    private void initialize() {
        ScaleImageView scaleImageView = this;
        scaleImageView.setScaleType(ImageView.ScaleType.MATRIX);
        scaleImageView.mMatrix = new Matrix();
        Drawable drawable2 = scaleImageView.getDrawable();
        if (drawable2 != null) {
            ScaleImageView scaleImageView2 = this;
            this.mIntrinsicWidth = drawable2.getIntrinsicWidth();
            scaleImageView2.mIntrinsicHeight = drawable2.getIntrinsicHeight();
            scaleImageView2.setOnTouchListener(scaleImageView2);
        }
        this.mDetector = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent motionEvent) {
                a a2 = this;
                a2.ScaleImageView.this.maxZoomTo((int)motionEvent.getX(), (int)motionEvent.getY());
                a2.ScaleImageView.this.cutting();
                return super.onDoubleTap(motionEvent);
            }
        });
    }

    private float distance(float x0, float x1, float y0, float y1) {
        float f2 = x0 - x1;
        float f3 = this = y0 - y1;
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    private float dispDistance() {
        int n = this.mWidth;
        int n2 = this.mHeight;
        return (float)Math.sqrt(n * n + n2 * n2);
    }

    public void setImageBitmap(Bitmap bm) {
        ScaleImageView scaleImageView = this;
        super.setImageBitmap(bm);
        scaleImageView.initialize();
    }

    public void setImageResource(int resId) {
        ScaleImageView scaleImageView = this;
        super.setImageResource(resId);
        scaleImageView.initialize();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setFrame(int l2, int t, int r, int b2) {
        void var2_3;
        void var1_1;
        float f2;
        void var4_5;
        boolean bl;
        void var3_4;
        int n;
        int n2;
        float f3;
        int n3;
        this.mWidth = n3 = r - l2;
        this.mHeight = b2 - t;
        this.mMatrix.reset();
        float f4 = this.mScale = (float)n3 / (float)this.mIntrinsicWidth;
        int n4 = this.mIntrinsicHeight;
        int n5 = this.mHeight;
        if (f3 * (float)n2 > (float)n) {
            ScaleImageView scaleImageView = this;
            scaleImageView.mScale = (float)n5 / (float)n4;
            float f5 = this.mScale;
            scaleImageView.mMatrix.postScale(f5, f5);
            bl = (var3_4 - scaleImageView.mWidth) / 2;
            n4 = 0;
        } else {
            ScaleImageView scaleImageView = this;
            float f6 = f4;
            scaleImageView.mMatrix.postScale(f6, f6);
            n4 = (var4_5 - scaleImageView.mHeight) / 2;
            bl = false;
        }
        ScaleImageView scaleImageView = this;
        scaleImageView.mMatrix.postTranslate((float)bl, (float)n4);
        scaleImageView.setImageMatrix(scaleImageView.mMatrix);
        this.mMinScale = f2 = scaleImageView.mScale;
        scaleImageView.zoomTo(f2, this.mWidth / 2, this.mHeight / 2);
        scaleImageView.cutting();
        return super.setFrame((int)var1_1, (int)var2_3, (int)var3_4, (int)var4_5);
    }

    protected float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    protected float getScale() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 0);
    }

    public float getTranslateX() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 2);
    }

    protected float getTranslateY() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 5);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void maxZoomTo(int x, int y) {
        void var2_2;
        void var1_1;
        if (this.mMinScale != this.getScale()) {
            float f2;
            float f3 = this.mMinScale;
            if (this.getScale() - f2 > 0.1f) {
                this.zoomTo(f3 / this.getScale(), (int)var1_1, (int)var2_2);
                return;
            }
        }
        ScaleImageView scaleImageView = this;
        scaleImageView.zoomTo(scaleImageView.MAX_SCALE / this.getScale(), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void zoomTo(float scale, int x, int y) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.getScale() * scale < this.mMinScale) {
            return;
        }
        if (var1_1 >= 1.0f && this.getScale() * var1_1 > this.MAX_SCALE) {
            return;
        }
        ScaleImageView scaleImageView = this;
        void v1 = var1_1;
        scaleImageView.mMatrix.postScale((float)v1, (float)v1);
        int n = this.mWidth;
        float f2 = -((float)n * var1_1 - (float)n) / 2.0f;
        n = this.mHeight;
        scaleImageView.mMatrix.postTranslate(f2, -((float)n * var1_1 - (float)n) / 2.0f);
        scaleImageView.mMatrix.postTranslate((float)(-(var2_2 - this.mWidth / 2)) * var1_1, 0.0f);
        scaleImageView.mMatrix.postTranslate(0.0f, (float)(-(var3_3 - this.mHeight / 2)) * var1_1);
        scaleImageView.setImageMatrix(scaleImageView.mMatrix);
    }

    public void cutting() {
        int n;
        ScaleImageView scaleImageView = this;
        int n2 = (int)((float)scaleImageView.mIntrinsicWidth * this.getScale());
        int n3 = (int)((float)scaleImageView.mIntrinsicHeight * this.getScale());
        if (scaleImageView.getTranslateX() < (float)(-(n2 - this.mWidth))) {
            this.mMatrix.postTranslate(-(this.getTranslateX() + (float)n2 - (float)this.mWidth), 0.0f);
        }
        if (this.getTranslateX() > 0.0f) {
            this.mMatrix.postTranslate(-this.getTranslateX(), 0.0f);
        }
        if (this.getTranslateY() < (float)(-(n3 - this.mHeight))) {
            this.mMatrix.postTranslate(0.0f, -(this.getTranslateY() + (float)n3 - (float)this.mHeight));
        }
        if (this.getTranslateY() > 0.0f) {
            this.mMatrix.postTranslate(0.0f, -this.getTranslateY());
        }
        if (n2 < (n = this.mWidth)) {
            this.mMatrix.postTranslate((float)(n - n2) / 2.0f, 0.0f);
        }
        if (n3 < (n2 = this.mHeight)) {
            this.mMatrix.postTranslate(0.0f, (float)(n2 - n3) / 2.0f);
        }
        ScaleImageView scaleImageView2 = this;
        scaleImageView2.setImageMatrix(scaleImageView2.mMatrix);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouchEvent(MotionEvent event) {
        block10: {
            int n;
            void var1_2;
            block7: {
                block8: {
                    block9: {
                        if (this.mDetector.onTouchEvent(event)) {
                            return true;
                        }
                        void v0 = var1_2;
                        n = v0.getPointerCount();
                        int n2 = v0.getAction();
                        if (n2 == 0) break block7;
                        if (n2 == 1) break block8;
                        if (n2 == 2) break block9;
                        if (n2 == 5) break block7;
                        if (n2 == 6) break block8;
                        if (n2 == 261) break block7;
                        if (n2 == 262) break block8;
                        break block10;
                    }
                    if (n >= 2 && this.isScaling) {
                        float f2;
                        ScaleImageView scaleImageView = this;
                        this.mPrevDistance = f2 = scaleImageView.distance(var1_2.getX(0), var1_2.getX(1), var1_2.getY(0), var1_2.getY(1));
                        float f3 = (f2 - this.mPrevDistance) / this.dispDistance() + 1.0f;
                        scaleImageView.zoomTo(f3 * f3, this.mWidth / 2, this.mHeight / 2);
                        scaleImageView.cutting();
                    } else if (!this.isScaling) {
                        ScaleImageView scaleImageView = this;
                        ScaleImageView scaleImageView2 = this;
                        int n3 = scaleImageView2.mPrevMoveX - (int)var1_2.getX();
                        int n4 = scaleImageView2.mPrevMoveY - (int)var1_2.getY();
                        this.mPrevMoveX = (int)var1_2.getX();
                        scaleImageView.mPrevMoveY = (int)var1_2.getY();
                        scaleImageView.mMatrix.postTranslate((float)(-n3), (float)(-n4));
                        scaleImageView.cutting();
                    }
                    break block10;
                }
                if (var1_2.getPointerCount() <= 1) {
                    this.isScaling = false;
                }
                break block10;
            }
            if (n >= 2) {
                this.mPrevDistance = this.distance(var1_2.getX(0), var1_2.getX(1), var1_2.getY(0), var1_2.getY(1));
                this.isScaling = true;
            } else {
                this.mPrevMoveX = (int)var1_2.getX();
                this.mPrevMoveY = (int)var1_2.getY();
            }
        }
        return true;
    }

    public boolean onTouch(View v, MotionEvent event) {
        return super.onTouchEvent(event);
    }
}

