/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.internal.video.ScreenRecordingContract;
import com.instabug.library.internal.video.ScreenRecordingEvent;
import com.instabug.library.internal.video.ScreenRecordingFileHolder;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.c.c;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.e;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.io.File;

public class InternalScreenRecordHelper
implements ScreenRecordingContract,
c.k {
    private static InternalScreenRecordHelper INSTANCE;
    private final Subject<Boolean> stopSubject = BehaviorSubject.createDefault((Object)false);
    @Nullable
    private c fab;
    private boolean canStopRecording;
    @Nullable
    private ScreenRecordingFileHolder fileHolder;
    private boolean isCurrentlyRecording = false;
    @Nullable
    private Intent resultDataIntent;

    private InternalScreenRecordHelper() {
    }

    public static InternalScreenRecordHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalScreenRecordHelper();
        }
        return INSTANCE;
    }

    private void resetFab() {
        c c2 = this.fab;
        if (c2 != null) {
            c2.b();
            this.fab.a();
        }
    }

    static /* synthetic */ boolean access$102(InternalScreenRecordHelper x0, boolean x1) {
        x0.canStopRecording = x1;
        return x1;
    }

    public void init() {
        InvocationManager.getInstance().switchOffInvocation();
        this.fileHolder = ScreenRecordingFileHolder.getInstance();
        if (this.fab == null) {
            this.fab = new c(this);
        }
        this.fab.a();
    }

    @Override
    public void start() {
        this.isCurrentlyRecording = true;
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity != null) {
            if (Build.VERSION.SDK_INT >= 29) {
                Activity activity2 = activity;
                activity2.startForegroundService(ScreenRecordingService.a((Context)activity2, -1, this.resultDataIntent, true));
            } else {
                Activity activity3 = activity;
                activity3.startService(ScreenRecordingService.a((Context)activity3, -1, this.resultDataIntent, true));
            }
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (InternalScreenRecordHelper.this.isRecording()) {
                    InternalScreenRecordHelper.this.stopSubject.onNext((Object)true);
                }
            }
        }, 1000L);
    }

    public void pause() {
    }

    @Override
    public void stop() {
        if (this.canStopRecording) {
            ScreenRecordingEventBus.getInstance().post(new ScreenRecordingEvent(1, this.getAutoScreenRecordingFileUri()));
            this.release();
        }
    }

    public void release() {
        c c2 = this.fab;
        if (c2 != null) {
            c2.b();
        }
        InvocationManager.getInstance().switchOnInvocation();
        if (Instabug.getApplicationContext() != null) {
            e.b(Instabug.getApplicationContext());
        }
        this.stopSubject.onNext((Object)false);
        this.isCurrentlyRecording = false;
    }

    @Override
    @Nullable
    public Uri getAutoScreenRecordingFileUri() {
        ScreenRecordingFileHolder this_ = ((InternalScreenRecordHelper)((Object)this_)).fileHolder;
        return this_ == null ? null : this_.getAutoScreenRecordingFileUri();
    }

    @Override
    public void delete() {
        ScreenRecordingFileHolder this_ = ((InternalScreenRecordHelper)((Object)this_)).fileHolder;
        if (this_ != null) {
            this_.delete();
        }
    }

    @Override
    public void clear() {
        ((InternalScreenRecordHelper)((Object)this_)).isCurrentlyRecording = false;
        ScreenRecordingFileHolder this_ = ((InternalScreenRecordHelper)((Object)this_)).fileHolder;
        if (this_ != null) {
            this_.clear();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean isRecording() {
        return this.isCurrentlyRecording;
    }

    public void cancel() {
        if (this.isRecording()) {
            this.resetFab();
        }
    }

    public Observable<Boolean> getIsStoppableObservable() {
        return this.stopSubject.hide().doOnNext((Consumer)new Consumer<Boolean>(){

            public void a(Boolean bl) {
                InternalScreenRecordHelper.access$102(InternalScreenRecordHelper.this, bl);
            }
        });
    }

    void onRecordingFinished() {
        ScreenRecordingEventBus.getInstance().post(new ScreenRecordingEvent(2, this.getAutoScreenRecordingFileUri()));
    }

    void onRecordingError() {
        ScreenRecordingEventBus.getInstance().post(new ScreenRecordingEvent(4, null));
    }

    /*
     * WARNING - void declaration
     */
    void setAutoScreenRecordingFile(File autoScreenRecordingFile) {
        ScreenRecordingFileHolder this_ = ((InternalScreenRecordHelper)((Object)this_)).fileHolder;
        if (this_ != null) {
            void var1_1;
            this_.setAutoScreenRecordingFile((File)var1_1);
        }
    }

    void startTimerOnRecordingFAB() {
        c this_ = ((InternalScreenRecordHelper)((Object)this_)).fab;
        if (this_ != null) {
            this_.c();
        }
    }

    public void setResultDataIntent(@Nullable Intent resultDataIntent) {
        this.resultDataIntent = resultDataIntent;
    }
}

