/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import com.instabug.library.internal.storage.cache.CacheChangedListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Cache<K, V> {
    private final List<CacheChangedListener<V>> listeners;
    private String id;
    private int appVersion;

    public Cache(String cacheId) {
        this(cacheId, 1);
    }

    protected Cache(String cacheId, int appVersion) {
        Cache cache = this;
        this.appVersion = -1;
        this.id = cacheId;
        cache.appVersion = appVersion;
        cache.listeners = new ArrayList<CacheChangedListener<V>>();
    }

    public abstract V get(K var1);

    public abstract V put(K var1, V var2);

    public abstract V delete(K var1);

    public abstract List<V> getValues();

    public abstract long size();

    /*
     * WARNING - void declaration
     */
    public void notifyItemRemoved(V removedElement) {
        Iterator<CacheChangedListener<V>> this_ = ((Cache)((Object)this_)).listeners.iterator();
        while (this_.hasNext()) {
            void var1_1;
            ((CacheChangedListener)this_.next()).onCachedItemRemoved(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyItemAdded(V addedElement) {
        Iterator<CacheChangedListener<V>> this_ = ((Cache)((Object)this_)).listeners.iterator();
        while (this_.hasNext()) {
            void var1_1;
            ((CacheChangedListener)this_.next()).onCachedItemAdded(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyItemUpdated(V oldElement, V updatedElement) {
        Iterator<CacheChangedListener<V>> this_ = ((Cache)((Object)this_)).listeners.iterator();
        while (this_.hasNext()) {
            void var2_2;
            void var1_1;
            ((CacheChangedListener)this_.next()).onCachedItemUpdated(var1_1, var2_2);
        }
    }

    public void notifyCacheInvalidated() {
        Iterator<CacheChangedListener<V>> this_ = ((Cache)((Object)this_)).listeners.iterator();
        while (this_.hasNext()) {
            ((CacheChangedListener)this_.next()).onCacheInvalidated();
        }
    }

    public abstract void invalidate();

    public String getId() {
        return this.id;
    }

    public int getAppVersion() {
        return this.appVersion;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addOnCacheChangedListener(CacheChangedListener<V> cacheChangedListener) {
        void var1_1;
        return !this.listeners.contains(cacheChangedListener) && this.listeners.add((CacheChangedListener<V>)var1_1);
    }

    public boolean removeOnCacheChangedListener(CacheChangedListener<V> cacheChangedListener) {
        return this.listeners.remove(cacheChangedListener);
    }
}

