/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.media;

import android.media.MediaPlayer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class AudioPlayer {
    public static final String TAG = "AudioPlayer";
    @NonNull
    private final Map<String, OnStopListener> onStopListeners = new HashMap<String, OnStopListener>();
    @Nullable
    private String filePath;
    @Nullable
    private MediaPlayer mediaPlayer;
    @Nullable
    private e onGetDurationListener;
    @Nullable
    private MediaPlayer.OnCompletionListener onCompletionListener;

    /*
     * WARNING - void declaration
     */
    private void prepare(d actionOnPrepared) {
        block3: {
            void var1_2;
            AudioPlayer audioPlayer = this;
            audioPlayer.mediaPlayer = new MediaPlayer();
            audioPlayer.mediaPlayer.setDataSource(this.filePath);
            audioPlayer.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener((d)var1_2){
                final /* synthetic */ d a;
                {
                    this.a = d2;
                }

                public void onPrepared(MediaPlayer mediaPlayer) {
                    AudioPlayer.this.doAction(this.a);
                }
            });
            audioPlayer.mediaPlayer.prepareAsync();
            if (audioPlayer.onCompletionListener == null) break block3;
            try {
                this.mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, "Playing audio file failed", iOException);
            }
        }
    }

    private void notifyOnStopListeners() {
        Iterator<OnStopListener> this_ = ((AudioPlayer)((Object)this_)).onStopListeners.values().iterator();
        while (this_.hasNext()) {
            ((OnStopListener)this_.next()).onStop();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void stream(String filePath, d actionOnPrepared) {
        void var2_2;
        void var1_1;
        if (filePath == null) {
            InstabugSDKLogger.e(TAG, "Audio file path can not be null");
            return;
        }
        if (var1_1.equals(this.filePath)) {
            this.doAction((d)var2_2);
        } else {
            this.filePath = var1_1;
            this.prepare((d)var2_2);
        }
    }

    private void doAction(d action) {
        int n = c.a[action.ordinal()];
        if (n != 1) {
            if (n != 2) {
                e e2;
                if (n == 3 && (e2 = this.onGetDurationListener) != null && (this = this.mediaPlayer) != null) {
                    e2.a(this.getDuration());
                }
            } else {
                MediaPlayer mediaPlayer = this.mediaPlayer;
                if (mediaPlayer != null && mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                }
            }
        } else {
            MediaPlayer mediaPlayer = this.mediaPlayer;
            if (mediaPlayer != null && !mediaPlayer.isPlaying()) {
                this.mediaPlayer.start();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getFormattedDurationText(long durationInMillis2) {
        void var0_1;
        int n = (int)(durationInMillis2 / 3600000L);
        long l2 = durationInMillis2;
        int durationInMillis2 = (int)(l2 % 3600000L / 60000L);
        int n2 = (int)(l2 % 60000L / 1000L);
        if (n > 0) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n;
            objectArray2[1] = (int)var0_1;
            objectArray[2] = n2;
            return String.format(Locale.getDefault(), "%02d:%02d:%02d", objectArray2);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = (int)var0_1;
        objectArray[1] = n2;
        return String.format(Locale.getDefault(), "%02d:%02d", objectArray3);
    }

    public void addOnStopListener(OnStopListener onStopListener) {
        AudioPlayer audioPlayer = this;
        audioPlayer.onStopListeners.put(onStopListener.getFilePath(), onStopListener);
        if (audioPlayer.onCompletionListener == null) {
            this.onCompletionListener = new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    AudioPlayer.this.notifyOnStopListeners();
                }
            };
            MediaPlayer mediaPlayer = this.mediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            }
        }
    }

    public void getDurationAsync(String filePath, e onGetDurationListener) {
        this.stream(filePath, d.GET_DURATION);
        this.onGetDurationListener = onGetDurationListener;
    }

    public void start(String filePath) {
        this.pause();
        this.stream(filePath, d.START);
    }

    public void pause() {
        AudioPlayer audioPlayer = this;
        audioPlayer.notifyOnStopListeners();
        audioPlayer.doAction(d.PAUSE);
    }

    public void release() {
        this.filePath = null;
        MediaPlayer mediaPlayer = this.mediaPlayer;
        if (mediaPlayer != null) {
            if (mediaPlayer.isPlaying()) {
                this.mediaPlayer.stop();
            }
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    public static abstract class OnStopListener {
        private String filePath;

        public OnStopListener(String filePath) {
            this.filePath = filePath;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public abstract void onStop();
    }

    public static interface e {
        public void a(int var1);
    }

    static enum d {
        START,
        PAUSE,
        GET_DURATION;

    }
}

