/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.network.e;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TaskDebouncer;
import io.reactivex.Observer;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

public class a {
    private static volatile a c;
    private final TaskDebouncer a;
    private NetworkManager b = new NetworkManager();

    public static a a() {
        if (c == null) {
            c = new a();
        }
        return c;
    }

    private a() {
        this.a = new TaskDebouncer(TimeUnit.SECONDS.toMillis(2L));
    }

    private void b(Context object, final Request.Callbacks<String, Throwable> callbacks) {
        a a2 = this;
        a a3 = a2;
        InstabugSDKLogger.d("FeaturesService", "Getting enabled features for this application");
        object = a2.a((Context)object, this.b);
        try {
            a3.b.doRequest((Request)object).subscribeOn(Schedulers.io()).subscribe((Observer)new DisposableObserver<RequestResponse>(){

                public void onStart() {
                    InstabugSDKLogger.addVerboseLog("FeaturesService", "getAppFeatures request started");
                }

                public void onComplete() {
                    InstabugSDKLogger.addVerboseLog("FeaturesService", "getAppFeatures request completed");
                }

                public void onError(Throwable throwable) {
                    InstabugSDKLogger.e("FeaturesService", "getAppFeatures request got error: " + throwable.getMessage());
                    callbacks.onFailed(throwable);
                }

                public void a(RequestResponse requestResponse) {
                    callbacks.onSucceeded(a.this.a(requestResponse));
                }
            });
        }
        catch (JSONException jSONException) {
            callbacks.onFailed(jSONException);
        }
    }

    @Nullable
    private String a(RequestResponse requestResponse) {
        int n = requestResponse.getResponseCode();
        InstabugSDKLogger.d("FeaturesService", "getAppFeatures: " + requestResponse.toString());
        if (n != 200) {
            if (n != 304) {
                InstabugSDKLogger.d("FeaturesService", "Caught unhandled case with code (" + n + ")");
                return null;
            }
            InstabugSDKLogger.d("FeaturesService", "Features list did not get modified. Moving on...");
            return null;
        }
        RequestResponse requestResponse2 = requestResponse;
        SettingsManager.getInstance().setFeaturesHash(requestResponse2.getHeaders().get("If-Match"));
        return (String)requestResponse2.getResponseBody();
    }

    public void a(final Context context, final Request.Callbacks<String, Throwable> callbacks) {
        this.a.debounce(new Runnable(){

            @Override
            public void run() {
                a.this.b(context, callbacks);
            }
        });
    }

    @VisibleForTesting
    Request a(Context object, NetworkManager networkManager) throws JSONException {
        Request.RequestParameter requestParameter;
        Context context = object;
        String string2 = SettingsManager.getInstance().getFeaturesHash();
        object = requestParameter;
        requestParameter = new Request.RequestParameter("If-Match", string2);
        Request request = networkManager.buildRequest(context, Request.Endpoint.APP_SETTINGS, Request.RequestMethod.Get);
        request.addHeader((Request.RequestParameter)object);
        return request;
    }
}

