/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics;

import android.content.Context;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.analytics.util.a;
import com.instabug.library.analytics.util.b;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.model.e;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.threading.PoolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE", "DLS_DEAD_LOCAL_STORE"})
public class AnalyticsObserver {
    private static final String LAST_UPLOADED_AT = "analytics_last_uploaded";
    private static AnalyticsObserver INSTANCE;
    private static String HAVE_BEEN_CLEANED = "have_been_cleaned";
    private LinkedHashMap<String, Api> loggingApisLinkedHashMap = new LinkedHashMap();
    private List<Api> sdkApisArrayList = Collections.synchronizedList(new ArrayList());

    public static AnalyticsObserver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnalyticsObserver();
        }
        return INSTANCE;
    }

    private AnalyticsObserver() {
        Consumer<e.a> consumer;
        Consumer<e.a> consumer2 = consumer;
        consumer = new Consumer<e.a>(){

            public void a(final e.a a2) {
                PoolProvider.postIOTask(new Runnable(){

                    @Override
                    public void run() {
                        AnalyticsObserver.this.handleAPIsUsageWithSessionStateChanged(a2);
                        b.a();
                    }
                });
            }
        };
        SessionStateEventBus.getInstance().subscribe(consumer2);
    }

    private void catchApiUsage(String apiName, boolean isDeprecated, Api.Parameter ... parameters) {
        this.sdkApisArrayList.add(this.createApiUsageInfo(apiName, isDeprecated, parameters));
    }

    /*
     * WARNING - void declaration
     */
    private void catchLoggingApiUsage(String apiName, boolean isDeprecated, Api.Parameter ... parameters) {
        void var1_1;
        if (((AnalyticsObserver)((Object)this_)).loggingApisLinkedHashMap.containsKey(apiName)) {
            AnalyticsObserver analyticsObserver = this_;
            Api this_ = analyticsObserver.loggingApisLinkedHashMap.get(var1_1);
            this_.incrementCount();
            analyticsObserver.loggingApisLinkedHashMap.put((String)var1_1, this_);
        } else {
            void var3_3;
            void var2_2;
            ((AnalyticsObserver)((Object)this_)).loggingApisLinkedHashMap.put((String)var1_1, ((AnalyticsObserver)((Object)this_)).createApiUsageInfo((String)var1_1, (boolean)var2_2, (Api.Parameter[])var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Api createApiUsageInfo(String apiName, boolean isDeprecated, Api.Parameter ... parameters) {
        ArrayList<Api.Parameter> arrayList;
        Api api;
        Api this_ = api;
        this_();
        this_.setApiName(apiName);
        api.setDeprecated(isDeprecated);
        if (parameters != null) {
            void var3_3;
            ArrayList<Api.Parameter> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<Api.Parameter>(Arrays.asList(var3_3));
        } else {
            ArrayList arrayList3;
            arrayList = arrayList3;
            arrayList3 = new ArrayList();
        }
        Api api2 = this_;
        api2.setParameters(arrayList);
        return api2;
    }

    private String getCallerMethodName() {
        return Thread.currentThread().getStackTrace()[4].getMethodName();
    }

    private void handleAPIsUsageWithSessionStateChanged(e.a sessionState) {
        long l = SettingsManager.getInstance().getSessionStartedAt();
        if (sessionState == e.a.FINISH) {
            ArrayList<Api> arrayList;
            AnalyticsObserver analyticsObserver = this;
            ArrayList<Api> arrayList2 = arrayList;
            arrayList2();
            arrayList2.addAll(this.sdkApisArrayList);
            a.a(arrayList, l);
            a.a(analyticsObserver.loggingApisLinkedHashMap.values(), l);
            analyticsObserver.sdkApisArrayList.clear();
            analyticsObserver.loggingApisLinkedHashMap.clear();
        }
    }

    public static long getLastUploadedAt(Context context) {
        return context.getSharedPreferences("instabug", 0).getLong(LAST_UPLOADED_AT, 0L);
    }

    public static void setLastUploadedAt(long analyticsUploadedAt, Context context) {
        context.getSharedPreferences("instabug", 0).edit().putLong(LAST_UPLOADED_AT, analyticsUploadedAt).apply();
    }

    public static boolean haveBeenCleanedBefore(Context context) {
        return context.getSharedPreferences("instabug", 0).getBoolean(HAVE_BEEN_CLEANED, false);
    }

    public static void setBeingCleaned(boolean isCleaned, Context context) {
        context.getSharedPreferences("instabug", 0).edit().putBoolean(HAVE_BEEN_CLEANED, isCleaned).apply();
    }

    public void catchApiUsage(Api.Parameter ... parameters) {
        AnalyticsObserver analyticsObserver = this;
        analyticsObserver.catchApiUsage(analyticsObserver.getCallerMethodName(), false, parameters);
    }

    public void catchDeprecatedApiUsage(Api.Parameter ... parameters) {
        AnalyticsObserver analyticsObserver = this;
        analyticsObserver.catchApiUsage(analyticsObserver.getCallerMethodName(), true, parameters);
    }

    public void catchLoggingApiUsage(Api.Parameter ... parameters) {
        AnalyticsObserver analyticsObserver = this;
        analyticsObserver.catchLoggingApiUsage(analyticsObserver.getCallerMethodName(), false, parameters);
    }

    public void catchDeprecatedLoggingApiUsage(Api.Parameter ... parameters) {
        AnalyticsObserver analyticsObserver = this;
        analyticsObserver.catchLoggingApiUsage(analyticsObserver.getCallerMethodName(), true, parameters);
    }
}

