/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom.pagerindicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.instabug.library.R;
import com.instabug.library.ui.custom.pagerindicator.Dot;
import com.instabug.library.ui.custom.pagerindicator.SelectionIndicator;
import com.instabug.library.view.ViewUtils;
import java.util.ArrayList;

public final class DotIndicator
extends RelativeLayout
implements SelectionIndicator {
    private static final String TAG = "[DotIndicator]";
    private static final int DEFAULT_NUMBER_OF_DOTS = 1;
    private static final int DEFAULT_SELECTED_DOT_INDEX = 0;
    private static final int DEFAULT_UNSELECTED_DOT_DIAMETER_DP = 6;
    private static final int DEFAULT_SELECTED_DOT_DIAMETER_DP = 9;
    private static final int DEFAULT_UNSELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SPACING_BETWEEN_DOTS_DP = 7;
    private static final int DEFAULT_DOT_TRANSITION_DURATION_MS = 200;
    private final ArrayList<Dot> dots;
    private int numberOfDots;
    private int selectedDotIndex;
    private int unselectedDotDiameterPx;
    private int selectedDotDiameterPx;
    private int unselectedDotColor;
    private int selectedDotColor;
    private int spacingBetweenDotsPx;
    private int dotTransitionDuration;

    public DotIndicator(Context context) {
        DotIndicator dotIndicator = this;
        super(context);
        dotIndicator.dots = new ArrayList();
        dotIndicator.init(null, 0, 0);
    }

    public DotIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.dots = new ArrayList();
        this.init(attrs, 0, 0);
    }

    public DotIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.dots = new ArrayList();
        this.init(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public DotIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.dots = new ArrayList();
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    private void init(AttributeSet attrs2, int defStyleAttr, int defStyleRes) {
        DotIndicator dotIndicator = this_;
        attrs2 = dotIndicator.getContext().obtainStyledAttributes(attrs2, R.styleable.IBDotIndicator, defStyleAttr, defStyleRes);
        DotIndicator dotIndicator2 = this_;
        int this_ = ViewUtils.convertDpToPx(dotIndicator2.getContext(), 9.0f);
        int attrs2 = ViewUtils.convertDpToPx(dotIndicator2.getContext(), 6.0f);
        defStyleAttr = ViewUtils.convertDpToPx(dotIndicator2.getContext(), 7.0f);
        this_.numberOfDots = attrs2.getInt(R.styleable.IBDotIndicator_ibViewPagerNumberOfDots, 1);
        this_.selectedDotIndex = attrs2.getInt(R.styleable.IBDotIndicator_ibViewPagerSelectedDotIndex, 0);
        this_.unselectedDotDiameterPx = attrs2.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerUnselectedDotDiameter, attrs2);
        this_.selectedDotDiameterPx = attrs2.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerSelectedDotDiameter, this_);
        this_.unselectedDotColor = attrs2.getColor(R.styleable.IBDotIndicator_ibViewPagerUnselectedDotColor, -1);
        this_.selectedDotColor = attrs2.getColor(R.styleable.IBDotIndicator_ibViewPagerSelectedDotColor, -1);
        this_.spacingBetweenDotsPx = attrs2.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerSpacingBetweenDots, defStyleAttr);
        this_.dotTransitionDuration = attrs2.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerTransitionDuration, 200);
        attrs2.recycle();
        dotIndicator.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        dotIndicator.setGravity(17);
        dotIndicator.reflectParametersInView();
    }

    private void reflectParametersInView() {
        DotIndicator dotIndicator = this;
        dotIndicator.removeAllViews();
        dotIndicator.dots.clear();
        for (int i2 = 0; i2 < this.numberOfDots; ++i2) {
            RelativeLayout.LayoutParams layoutParams;
            Dot dot;
            Dot dot2 = dot;
            dot2(this.getContext());
            dot.setInactiveDiameterPx(this.unselectedDotDiameterPx).setActiveDiameterPx(this.selectedDotDiameterPx).setActiveColor(this.selectedDotColor).setInactiveColor(this.unselectedDotColor).setTransitionDuration(this.dotTransitionDuration);
            if (i2 == this.selectedDotIndex) {
                dot2.setActive(false);
            } else {
                dot2.setInactive(false);
            }
            DotIndicator dotIndicator2 = this;
            int n = Math.max(dotIndicator2.selectedDotDiameterPx, this.unselectedDotDiameterPx);
            int n2 = i2 * (dotIndicator2.spacingBetweenDotsPx + this.unselectedDotDiameterPx);
            RelativeLayout.LayoutParams layoutParams2 = layoutParams;
            int n3 = n;
            layoutParams2(n3, n3);
            layoutParams.setMargins(n2, 0, 0, 0);
            if (Build.VERSION.SDK_INT >= 17) {
                layoutParams2.setMarginStart(n2);
            }
            DotIndicator dotIndicator3 = this;
            Dot dot3 = dot2;
            dot3.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            dotIndicator3.addView((View)dot3);
            dotIndicator3.dots.add(i2, dot2);
        }
    }

    public void redrawDots() {
        this.reflectParametersInView();
    }

    public void setUnselectedDotDiameterPx(int unselectedDotDiameterPx) {
        this.unselectedDotDiameterPx = unselectedDotDiameterPx;
        this.reflectParametersInView();
    }

    public void setUnselectedDotDiameterDp(int unselectedDotDiameterDp) {
        DotIndicator dotIndicator = this;
        dotIndicator.setUnselectedDotDiameterPx(ViewUtils.convertDpToPx(dotIndicator.getContext(), unselectedDotDiameterDp));
    }

    public int getUnselectedDotDiameter() {
        return this.unselectedDotDiameterPx;
    }

    public void setSelectedDotDiameterPx(int selectedDotDiameterPx) {
        this.selectedDotDiameterPx = selectedDotDiameterPx;
        this.reflectParametersInView();
    }

    public void setSelectedDotDiameterDp(int selectedDotDiameterDp) {
        DotIndicator dotIndicator = this;
        dotIndicator.setSelectedDotDiameterPx(ViewUtils.convertDpToPx(dotIndicator.getContext(), selectedDotDiameterDp));
    }

    public int getSelectedDotDiameter() {
        return this.selectedDotDiameterPx;
    }

    public int getUnselectedDotColor() {
        return this.unselectedDotColor;
    }

    public void setUnselectedDotColor(int unselectedDotColor) {
        this.unselectedDotColor = unselectedDotColor;
        this.reflectParametersInView();
    }

    public int getSelectedDotColor() {
        return this.selectedDotColor;
    }

    public void setSelectedDotColor(int selectedDotColor) {
        this.selectedDotColor = selectedDotColor;
        this.reflectParametersInView();
    }

    public void setSpacingBetweenDotsPx(int spacingBetweenDotsPx) {
        this.spacingBetweenDotsPx = spacingBetweenDotsPx;
        this.reflectParametersInView();
    }

    public void setSpacingBetweenDotsDp(int spacingBetweenDotsDp) {
        DotIndicator dotIndicator = this;
        dotIndicator.setSpacingBetweenDotsPx(ViewUtils.convertDpToPx(dotIndicator.getContext(), spacingBetweenDotsDp));
    }

    public int getSpacingBetweenDots() {
        return this.spacingBetweenDotsPx;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSelectedItem(int index, boolean animate) {
        if (this.dots.size() <= 0) return;
        try {
            void var1_1;
            void var2_2;
            if (this.selectedDotIndex < this.dots.size()) {
                this.dots.get(this.selectedDotIndex).setInactive((boolean)var2_2);
            }
            this.dots.get((int)var1_1).setActive((boolean)var2_2);
            this.selectedDotIndex = var1_1;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public int getSelectedItemIndex() {
        return this.selectedDotIndex;
    }

    @Override
    public int getNumberOfItems() {
        return this.numberOfDots;
    }

    @Override
    public void setNumberOfItems(int numberOfItems) {
        this.numberOfDots = numberOfItems;
        this.reflectParametersInView();
    }

    @Override
    public int getTransitionDuration() {
        return this.dotTransitionDuration;
    }

    @Override
    public void setTransitionDuration(int transitionDurationMs) {
        this.dotTransitionDuration = transitionDurationMs;
        this.reflectParametersInView();
    }

    @Override
    public void setVisibility(boolean show) {
        int n = show ? 0 : 4;
        this.setVisibility(n);
    }

    @Override
    public boolean isVisible() {
        return this.getVisibility() == 0;
    }
}

