/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.library.R;
import com.instabug.library.util.InstabugSDKLogger;

public abstract class InstabugBaseFragment
extends Fragment {
    @Nullable
    private View view;
    @Nullable
    private Activity activity;
    private boolean isStateRestored;

    @LayoutRes
    protected abstract int getLayout();

    protected abstract String getTitle();

    protected abstract void consumeNewInstanceSavedArguments();

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.activity = activity;
    }

    public void onCreate(Bundle savedInstanceState) {
        InstabugBaseFragment instabugBaseFragment = this;
        super.onCreate(savedInstanceState);
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onCreateView called");
        if (instabugBaseFragment.getArguments() != null) {
            InstabugBaseFragment instabugBaseFragment2 = this;
            InstabugSDKLogger.v((Object)instabugBaseFragment2, "Arguments found, calling consumeNewInstanceSavedArguments with " + this.getArguments());
            instabugBaseFragment2.consumeNewInstanceSavedArguments();
        }
        this.isStateRestored = false;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        InstabugBaseFragment instabugBaseFragment = this;
        InstabugBaseFragment instabugBaseFragment2 = this;
        InstabugSDKLogger.v((Object)instabugBaseFragment2, "onCreateView called");
        instabugBaseFragment.view = inflater.inflate(instabugBaseFragment2.getLayout(), container, false);
        instabugBaseFragment.setTitle(instabugBaseFragment.getTitle());
        return instabugBaseFragment.view;
    }

    protected abstract void restoreState(Bundle var1);

    /*
     * WARNING - void declaration
     */
    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        InstabugSDKLogger.v((Object)this, "onViewCreated called");
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            void var2_2;
            InstabugSDKLogger.v((Object)this, "savedInstanceState found, calling restoreState");
            this.restoreState((Bundle)var2_2);
            this.isStateRestored = true;
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        InstabugBaseFragment instabugBaseFragment = this;
        super.onSaveInstanceState(outState);
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onSaveInstanceState called, calling saveState");
        this.saveState(outState);
    }

    public void onPause() {
        InstabugBaseFragment instabugBaseFragment = this;
        super.onPause();
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onPause called, calling saveState");
    }

    public void onResume() {
        InstabugBaseFragment instabugBaseFragment = this;
        super.onResume();
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onResume called, calling saveState");
    }

    protected abstract void saveState(Bundle var1);

    public boolean isStateRestored() {
        return this.isStateRestored;
    }

    public Activity getPreservedActivity() {
        InstabugBaseFragment instabugBaseFragment = this;
        InstabugSDKLogger.v((Object)instabugBaseFragment, "Returning preserved activity " + this.activity);
        return instabugBaseFragment.activity;
    }

    /*
     * WARNING - void declaration
     */
    public void setTitle(String title) {
        View view = this.view;
        if (view == null) {
            InstabugSDKLogger.v((Object)this, "Calling setTitle before inflating the view! Ignoring call");
            return;
        }
        if ((view = (TextView)view.findViewById(R.id.instabug_fragment_title)) != null) {
            void var1_1;
            InstabugSDKLogger.v((Object)this, "Setting fragment title to \"" + (String)var1_1 + "\"");
            view.setText((CharSequence)var1_1);
        } else {
            InstabugSDKLogger.v((Object)this, "instabug_fragment_title wasn't found, make sure your layout.xml contains it");
        }
    }
}

