/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.internal.video.InternalScreenRecordHelper;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.Report;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.util.h.c;
import com.instabug.library.visualusersteps.State;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Instabug {
    private static Instabug INSTANCE;
    private static final String TAG = "Instabug";
    private static InstabugState INSTABUG_STATE;
    private com.instabug.library.b delegate;

    private Instabug(@NonNull com.instabug.library.b delegate) {
        this.delegate = delegate;
    }

    static Instabug getInstance() throws IllegalStateException {
        Instabug instabug = INSTANCE;
        if (instabug != null) {
            return instabug;
        }
        throw new IllegalStateException("Instabug getInstance called before Instabug.Builder().build() was called");
    }

    @Nullable
    public static Context getApplicationContext() {
        return Instabug.getInstance().delegate.b();
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("isDebugEnabled").setType(Boolean.TYPE).setValue(isDebugEnabled));
        SettingsManager.getInstance().setDebugEnabled(isDebugEnabled);
        InstabugSDKLogger.i(TAG, "setDebugEnabled " + isDebugEnabled);
    }

    public static int getPrimaryColor() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static void setPrimaryColor(@ColorInt int primaryColorValue) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("primaryColorValue").setType(Integer.TYPE).setValue(String.valueOf(primaryColorValue)));
        SettingsManager.getInstance().setPrimaryColor(primaryColorValue);
        InstabugSDKLogger.i(TAG, "setPrimaryColor");
    }

    public static InstabugColorTheme getTheme() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getTheme();
    }

    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("fileUri").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(fileUri, fileNameWithExtension);
        InstabugSDKLogger.i(TAG, "addFileAttachment uriFile");
    }

    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("data").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(data, fileNameWithExtension);
        InstabugSDKLogger.i(TAG, "addFileAttachment bytes");
    }

    public static void clearFileAttachment() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().clearExtraAttachmentFiles();
        InstabugSDKLogger.i(TAG, "clearFileAttachment");
    }

    public static String getUserData() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i(TAG, "getUserData");
        return SettingsManager.getInstance().getUserData();
    }

    public static void setUserData(@NonNull String userData) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userData").setType(String.class));
        if (com.instabug.library.c.b().a(Feature.USER_DATA) == Feature.State.ENABLED) {
            String string;
            SettingsManager.getInstance().setUserData(StringUtility.trimString(string, 1000));
            InstabugSDKLogger.i(TAG, "setUserData");
        }
    }

    public static String getUserEmail() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i(TAG, "getUserEmail");
        return b.e();
    }

    public static String getAppToken() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getAppToken();
    }

    public static void identifyUser(@Nullable String username, @NonNull String email) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("username").setType(String.class), new Api.Parameter().setName("email"));
        b.a(Instabug.getApplicationContext(), username, email);
        InstabugSDKLogger.i(TAG, "identifyUser username: " + username + " email" + email);
    }

    public static void logoutUser() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        b.k();
        InstabugSDKLogger.i(TAG, "logoutUser");
    }

    public static void setState(InstabugState instabugState) {
        INSTABUG_STATE = instabugState;
    }

    public static InstabugState getState() {
        return INSTABUG_STATE;
    }

    public static boolean isBuilt() {
        return INSTANCE != null && Instabug.getState() != InstabugState.NOT_BUILT;
    }

    public static boolean isEnabled() {
        if (!Instabug.isBuilt()) {
            return false;
        }
        return com.instabug.library.c.b().c(Feature.INSTABUG) && com.instabug.library.c.b().a(Feature.INSTABUG) == Feature.State.ENABLED;
    }

    public static void enable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (!Instabug.isEnabled()) {
            com.instabug.library.c.b().b(Feature.INSTABUG, true);
            com.instabug.library.c.b().a(Feature.INSTABUG, Feature.State.ENABLED);
            com.instabug.library.c.b().d(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.h();
        }
        InstabugSDKLogger.i(TAG, "enable");
    }

    public static void disable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.isEnabled()) {
            com.instabug.library.c.b().a(Feature.INSTABUG, Feature.State.DISABLED);
            com.instabug.library.c.b().b(Feature.INSTABUG, false);
            com.instabug.library.c.b().d(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.j();
        }
        InstabugSDKLogger.i(TAG, "disable");
    }

    public static void pauseSdk() throws IllegalStateException {
        APIBuildChecker.check();
        if (Instabug.isEnabled()) {
            Instabug.getInstance().delegate.e();
        }
        InstabugSDKLogger.i(TAG, "pauseSdk");
    }

    public static void resumeSdk() throws IllegalStateException {
        APIBuildChecker.check();
        Instabug.getInstance().delegate.g();
        InstabugSDKLogger.i(TAG, "pauseSdk");
    }

    public static void setLocale(Locale locale) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
        Instabug.getInstance().delegate.a(locale);
        InstabugSDKLogger.i(TAG, "setLocale");
    }

    public static Locale getLocale(Context context) throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getInstabugLocale(context);
    }

    public static void addTags(String ... tags) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().addTags(StringUtility.trimStrings(tags));
        InstabugSDKLogger.i(TAG, "addTags");
    }

    public static ArrayList<String> getTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getTags();
    }

    public static void resetTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().resetTags();
        InstabugSDKLogger.i(TAG, "resetTags");
    }

    public static void setCustomTextPlaceHolders(InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugCustomTextPlaceHolder").setType(InstabugCustomTextPlaceHolder.class));
        SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder);
        InstabugSDKLogger.i(TAG, "setCustomTextPlaceHolders");
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i(TAG, "getAllUserAttributes");
        return c.a(UserAttributeCacheManager.retrieveAll()).a(com.instabug.library.util.h.a.g()).a();
    }

    public static void setUserAttribute(@NonNull String key, String value) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class), new Api.Parameter().setName("value").setType(String.class));
        c.a(new Pair((Object)key, (Object)value)).a(com.instabug.library.util.h.a.f()).a(com.instabug.library.util.h.a.d());
        InstabugSDKLogger.i(TAG, "setUserAttribute");
    }

    @Nullable
    public static String getUserAttribute(@NonNull String key) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        InstabugSDKLogger.i(TAG, "getUserAttribute");
        return c.a(key).a(com.instabug.library.util.h.a.e()).a(com.instabug.library.util.h.a.a());
    }

    public static void removeUserAttribute(@NonNull String key) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        c.a(key).a(com.instabug.library.util.h.a.e()).a(com.instabug.library.util.h.a.b());
        InstabugSDKLogger.i(TAG, "removeUserAttribute");
    }

    public static void clearAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        c.a(UserAttributeCacheManager.retrieveAll()).a(com.instabug.library.util.h.a.g()).a(com.instabug.library.util.h.a.c());
        InstabugSDKLogger.i(TAG, "clearAllUserAttributes");
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setWelcomeMessageState(WelcomeMessage.State welcomeMessageState) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("WelcomeMessageState").setType(String.class).setValue(welcomeMessageState.toString()));
        SettingsManager.getInstance().setWelcomeMessageState(welcomeMessageState);
        InstabugSDKLogger.i(TAG, "setWelcomeMessageState: " + welcomeMessageState.name());
    }

    public static void showWelcomeMessage(WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("showWelcomeMessage").setType(String.class).setValue(welcomeMessageState.toString()));
        if (!InstabugCore.isForegroundBusy()) {
            Instabug.getInstance().delegate.a(state);
        }
        InstabugSDKLogger.i(TAG, "showWelcomeMessage: " + state.name());
    }

    @Deprecated
    public static void setViewHierarchyState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.c.b().a(Feature.VIEW_HIERARCHY_V2, state);
        InstabugSDKLogger.i(TAG, "setViewHierarchyState: " + state.name());
    }

    @Deprecated
    public static void setAutoScreenRecordingMaxDuration(int autoScreenRecordingMaxDuration) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("setAutoScreenRecordingMaxDuration").setType(Boolean.class).setValue(String.valueOf(autoScreenRecordingMaxDuration)));
        SettingsManager.getInstance().setAutoScreenRecordingMaxDuration(autoScreenRecordingMaxDuration);
        Log.e((String)Instabug.class.getName(), (String)"AutoScreen recording is disabled please contact support for further details.");
        InstabugSDKLogger.i(TAG, "setAutoScreenRecordingMaxDuration " + autoScreenRecordingMaxDuration);
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.c.b().a(Feature.SESSION_PROFILER, state);
        InstabugSDKLogger.i(TAG, "setSessionProfilerState: " + state.name());
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        com.instabug.library.c.b().a(Feature.TRACK_USER_STEPS, state);
        InstabugSDKLogger.i(TAG, "setTrackingUserStepsState: " + state.name());
    }

    public static void setReproStepsState(State reproStepsState) {
        State state;
        if (reproStepsState == State.ENABLED) {
            com.instabug.library.c.b().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(true);
        } else if (state == State.ENABLED_WITH_NO_SCREENSHOTS) {
            com.instabug.library.c.b().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(false);
        } else if (state == State.DISABLED) {
            com.instabug.library.c.b().a(Feature.REPRO_STEPS, Feature.State.DISABLED);
        }
        InstabugSDKLogger.i(TAG, "setReproStepsState: " + state.name());
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        InstabugColorTheme instabugColorTheme;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugTheme));
        SettingsManager.getInstance().setTheme(instabugTheme);
        int n = a.a[instabugTheme.ordinal()];
        if (n != 1) {
            if (n == 2) {
                SettingsManager.getInstance().setPrimaryColor(-15893761);
                SettingsManager.getInstance().setStatusBarColor(-3815737);
            }
        } else {
            SettingsManager.getInstance().setPrimaryColor(-9580554);
            SettingsManager.getInstance().setStatusBarColor(-16119286);
        }
        InstabugSDKLogger.i(TAG, "setColorTheme: " + instabugColorTheme.name());
    }

    public static void logUserEvent(@NonNull String eventIdentifier) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class));
        InstabugUserEventLogger.getInstance().logUserEvent(eventIdentifier, new UserEventParam[0]);
        InstabugSDKLogger.i(TAG, "logUserEvent");
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("listener").setType(Report.OnReportCreatedListener.class));
        SettingsManager.getInstance().setOnReportCreatedListener(listener);
        InstabugSDKLogger.i(TAG, "onReportSubmitHandler");
    }

    @VisibleForTesting
    static void setAutoScreenRecordingDuration(@IntRange(from=30L, to=180L) int maxDuration) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("maxDuration").setType(Integer.class).setValue(maxDuration));
        SettingsManager.getInstance().setAutoScreenRecordingDuration(maxDuration);
        InstabugSDKLogger.i(TAG, "setAutoScreenRecordingDuration: " + maxDuration);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("asrAudioCapturingEnabled").setType(Feature.State.class).setValue(isASRAudioEnabled.name()));
        SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(isASRAudioEnabled);
        InstabugSDKLogger.i(TAG, "setAutoScreenRecordingAudioCapturingEnabled: " + isASRAudioEnabled.name());
    }

    public static void show() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().show();
        InstabugSDKLogger.i(TAG, "show");
    }

    public static void setViewsAsPrivate(View ... views) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            View[] viewArray;
            Instabug.getInstance().delegate.a(viewArray);
        }
        InstabugSDKLogger.i(TAG, "setViewsAsPrivate");
    }

    static {
        INSTABUG_STATE = InstabugState.NOT_BUILT;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class Builder {
        private String applicationToken;
        private Context applicationContext;
        @Nullable
        private Application application;
        private InstabugColorTheme instabugTheme;
        private int instabugPrimaryColor;
        private int instabugStatusBarColor;
        private InstabugInvocationEvent[] instabugInvocationEvents;
        private Feature.State userDataState;
        private Feature.State consoleLogState;
        private Feature.State instabugLogState;
        private Feature.State inAppMessagingState;
        private Feature.State crashReportingState;
        private Feature.State pushNotificationState;
        private Feature.State trackingUserStepsState;
        private State reproStepsState;
        private Feature.State viewHierarchyState;
        private Feature.State surveysState;
        private Feature.State userEventsState;
        private boolean emailFieldRequired;
        private boolean emailFieldVisibility;
        private boolean commentFieldRequired;
        private boolean introMessageEnabled;
        private boolean shouldPlaySounds;
        private boolean successDialogEnabled;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge;
        private int shakingThreshold;
        private int floatingButtonOffsetFromTop;
        private Locale instabugLocale;
        private boolean isSurveysAutoShowing;
        private boolean chatPromptOptionEnable;
        private boolean bugPromptOptionEnable;
        private boolean feedbackPromptOptionEnable;
        private List<Integer> deprecatedMethodsToBeLogedAfterBuild;

        public Builder(Application application, String applicationToken) {
            this(application, applicationToken, InstabugInvocationEvent.SHAKE);
        }

        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            this(application.getApplicationContext(), applicationToken, instabugInvocationEvent);
            this.application = application;
        }

        Builder(@NonNull Context applicationContext, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvents) {
            Context context = applicationContext;
            this.instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
            this.instabugPrimaryColor = -15893761;
            this.instabugStatusBarColor = -3815737;
            this.instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
            applicationContext = com.instabug.library.c.f;
            this.userDataState = applicationContext;
            this.consoleLogState = applicationContext;
            this.instabugLogState = applicationContext;
            this.inAppMessagingState = applicationContext;
            this.crashReportingState = applicationContext;
            this.pushNotificationState = applicationContext;
            this.trackingUserStepsState = applicationContext;
            this.reproStepsState = State.ENABLED;
            this.viewHierarchyState = Feature.State.DISABLED;
            this.userEventsState = this.surveysState = com.instabug.library.c.f;
            this.emailFieldRequired = true;
            this.emailFieldVisibility = true;
            this.commentFieldRequired = false;
            this.introMessageEnabled = true;
            this.shouldPlaySounds = false;
            this.successDialogEnabled = true;
            this.instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
            this.shakingThreshold = 650;
            this.floatingButtonOffsetFromTop = -1;
            this.instabugLocale = Locale.getDefault();
            this.isSurveysAutoShowing = true;
            this.chatPromptOptionEnable = true;
            this.bugPromptOptionEnable = true;
            this.feedbackPromptOptionEnable = true;
            this.deprecatedMethodsToBeLogedAfterBuild = new ArrayList<Integer>();
            this.applicationContext = context;
            this.instabugInvocationEvents = instabugInvocationEvents;
            this.applicationToken = applicationToken;
        }

        private void logDeprecatedApis() {
            Iterator<Integer> this_ = ((Builder)((Object)this_)).deprecatedMethodsToBeLogedAfterBuild.iterator();
            while (this_.hasNext()) {
                InstabugDeprecationLogger.getInstance().log((Integer)this_.next());
            }
        }

        private void setFeaturesStates(Boolean isInstabugEnabled) {
            Builder builder = this;
            InstabugSDKLogger.v(builder, "Setting user data feature state " + (Object)((Object)this.userDataState));
            com.instabug.library.c.b().a(Feature.USER_DATA, this.userDataState);
            InstabugSDKLogger.v(builder, "Setting console log feature state " + (Object)((Object)this.consoleLogState));
            com.instabug.library.c.b().a(Feature.CONSOLE_LOGS, this.consoleLogState);
            InstabugSDKLogger.v(builder, "Setting Instabug logs feature state " + (Object)((Object)this.instabugLogState));
            com.instabug.library.c.b().a(Feature.INSTABUG_LOGS, this.instabugLogState);
            InstabugSDKLogger.v(builder, "Setting crash reporting feature state " + (Object)((Object)this.crashReportingState));
            com.instabug.library.c.b().a(Feature.CRASH_REPORTING, this.crashReportingState);
            InstabugSDKLogger.v(builder, "Setting in-app messaging feature state " + (Object)((Object)this.inAppMessagingState));
            com.instabug.library.c.b().a(Feature.IN_APP_MESSAGING, this.inAppMessagingState);
            InstabugSDKLogger.v(builder, "Setting push notification feature state " + (Object)((Object)this.pushNotificationState));
            com.instabug.library.c.b().a(Feature.PUSH_NOTIFICATION, this.pushNotificationState);
            InstabugSDKLogger.v(builder, "Setting tracking user steps feature state " + (Object)((Object)this.trackingUserStepsState));
            com.instabug.library.c.b().a(Feature.TRACK_USER_STEPS, this.trackingUserStepsState);
            InstabugSDKLogger.v(builder, "Setting repro steps feature state " + (Object)((Object)this.reproStepsState));
            Instabug.setReproStepsState(builder.reproStepsState);
            InstabugSDKLogger.v(builder, "Setting view hierarchy  feature state " + (Object)((Object)this.viewHierarchyState));
            com.instabug.library.c.b().a(Feature.VIEW_HIERARCHY_V2, this.viewHierarchyState);
            InstabugSDKLogger.v(builder, "Setting surveys feature state " + (Object)((Object)this.surveysState));
            com.instabug.library.c.b().a(Feature.SURVEYS, this.surveysState);
            InstabugSDKLogger.v(builder, "Setting user events feature state " + (Object)((Object)this.userEventsState));
            com.instabug.library.c.b().a(Feature.USER_EVENTS, this.userEventsState);
            InstabugSDKLogger.v(builder, "Setting instabug overall state " + isInstabugEnabled);
            com.instabug.library.c.b().b(Feature.INSTABUG, isInstabugEnabled);
        }

        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue(TextUtils.join((CharSequence)",", (Object[])instabugInvocationEvents)));
            this.instabugInvocationEvents = instabugInvocationEvents;
            return this;
        }

        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.trackingUserStepsState = state;
            return this;
        }

        public Builder setReproStepsState(State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(State.class).setValue((Object)state));
            this.reproStepsState = state;
            return this;
        }

        public Builder setConsoleLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.consoleLogState = state;
            return this;
        }

        public Builder setInstabugLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.instabugLogState = state;
            return this;
        }

        public Builder setUserDataState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userDataState = state;
            return this;
        }

        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.inAppMessagingState = state;
            return this;
        }

        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.viewHierarchyState = state;
            return this;
        }

        public Builder setUserEventsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userEventsState = state;
            return this;
        }

        public Instabug build(Feature.State instabugInitialState) {
            com.instabug.library.b b2;
            SettingsManager.init(this.applicationContext);
            Object object = instabugInitialState == Feature.State.ENABLED;
            Builder builder = this;
            builder.setFeaturesStates((Boolean)object);
            object = b2;
            Builder builder2 = this;
            ((com.instabug.library.b)object)(this.applicationContext);
            INSTANCE = new Instabug((com.instabug.library.b)object);
            Instabug.setState(InstabugState.BUILT);
            InstabugSDKLogger.initLogger(Instabug.getApplicationContext());
            builder2.logDeprecatedApis();
            b2.a(builder2.applicationContext);
            InstabugInternalTrackingDelegate.init(builder.application);
            String string = SettingsManager.getInstance().getAppToken();
            String string2 = builder.applicationToken;
            if (string2 != null && string != null && !string2.equals(string)) {
                b.k();
            }
            SettingsManager.getInstance().setAppToken(this.applicationToken);
            ((com.instabug.library.b)object).h();
            SettingsManager.getInstance().setInstabugLocale(this.instabugLocale);
            SettingsManager.getInstance().setTheme(this.instabugTheme);
            SettingsManager.getInstance().setPrimaryColor(this.instabugPrimaryColor);
            SettingsManager.getInstance().setStatusBarColor(this.instabugStatusBarColor);
            InvocationManager.getInstance().setInstabugInvocationEvent(this.instabugInvocationEvents);
            InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(this.shakingThreshold);
            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(this.instabugFloatingButtonEdge);
            if (this.floatingButtonOffsetFromTop != -1) {
                InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(this.floatingButtonOffsetFromTop);
            }
            com.instabug.library.m.a.a(this.isSurveysAutoShowing);
            InstabugSDKLogger.i(Instabug.TAG, "Built");
            return INSTANCE;
        }

        public Instabug build() {
            if (Instabug.isBuilt()) {
                if (InternalScreenRecordHelper.getInstance().isRecording()) {
                    InternalScreenRecordHelper.getInstance().cancel();
                }
                Instabug.disable();
            }
            return this.build(Feature.State.ENABLED);
        }
    }
}

