/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.instacapture.screenshot.ScreenshotTaker;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.Action;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.predicate.MemoryNotLowPredicate;
import com.instabug.library.util.threading.PoolProvider;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

public class BitmapUtils {
    public static final String TAG = "BitmapUtils";

    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Bitmap bitmap = null;
        try {
            Uri uri2;
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            InstabugSDKLogger.e(TAG, "getBitmapFromFilePath returns null because of " + iOException.getMessage());
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public static void compressBitmapAndSave(@NonNull Context context, @NonNull File originalImageFile) {
        void var1_1;
        if (context != null && var1_1 != null) {
            Context context2;
            MemoryGuard.from(context2).withPredicate(new MemoryNotLowPredicate()).doAction(new Action((File)var1_1){
                final /* synthetic */ File a;
                {
                    this.a = file;
                }

                @Override
                public void onAffirmed() throws Throwable {
                    BitmapUtils.compressBitmapAndSave(this.a);
                }

                @Override
                public void onDenied() throws Throwable {
                    InstabugSDKLogger.e(BitmapUtils.TAG, "Not enough memory for compressing image");
                }
            });
            return;
        }
    }

    private static void compressBitmapAndSave(File originalImageFile) {
        FileOutputStream fileOutputStream;
        BitmapFactory.Options options;
        File file;
        BitmapFactory.Options options2;
        Object object = options2;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)object);
        int n = 1;
        while (true) {
            if (object.outWidth / n / 2 < 900) break;
            if (object.outHeight / n / 2 < 900) break;
            n *= 2;
            continue;
            break;
        }
        object = options;
        object();
        options.inSampleSize = n;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)object);
        Bitmap bitmap2 = bitmap;
        Bitmap bitmap3 = bitmap;
        File file2 = file;
        object = fileOutputStream;
        fileOutputStream = new FileOutputStream(file);
        bitmap2.compress(BitmapUtils.getImageMimeType(file2), 100, (OutputStream)object);
        try {
            bitmap3.recycle();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            InstabugSDKLogger.e(TAG, "compressBitmapAndSave bitmap doesn't compressed correctly " + fileNotFoundException.getMessage());
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String localPath, ImageView imageView) {
        new BitmapWorkerTask(imageView).execute(new String[]{localPath});
    }

    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight) {
        new BitmapWorkerTask(imageView, targetWidth, targetHeight).execute(new String[]{localPath});
    }

    public static void loadBitmap(String localPath, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        new BitmapWorkerTask(imageView, onImageLoadedListener).execute(new String[]{localPath});
    }

    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        new BitmapWorkerTask(imageView, targetWidth, targetHeight, onImageLoadedListener).execute(new String[]{localPath});
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String imageFilePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options2) {
        int n;
        int n2 = options2.outHeight;
        int options2 = options2.outWidth;
        int n3 = 1;
        int n4 = 500;
        int n5 = 500;
        if (n2 > 500 || n > n5) {
            void v0 = n;
            n = n2 / 2;
            n2 = v0 / 2;
            while (n / n3 >= n4 && n2 / n3 >= n5) {
                n3 *= 2;
            }
        }
        return n3;
    }

    public static void saveBitmapAsPNG(final Bitmap bitmap, final int quality, final File directory, final String fileNamePrefix, final OnSaveBitmapCallback callback) {
        PoolProvider.postBitmapTask(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block5: {
                    var1_1 = v0;
                    v0 = new File(directory, fileNamePrefix + "_" + System.currentTimeMillis() + ".png");
                    InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + var1_1.toString());
                    var2_3 = v1;
                    var2_3(new FileOutputStream(var1_1));
                    bitmap.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)var2_3);
                    v1.close();
                    var1_1 = Uri.fromFile((File)v0);
                    if (var1_1 == null) ** GOTO lbl16
                    try {
                        callback.onSuccess((Uri)var1_1);
                        break block5;
lbl16:
                        // 1 sources

                        callback.onError(new Throwable("Uri equal null"));
                    }
                    catch (IOException var1_2) {
                        callback.onError(var1_2);
                    }
                }
            }
        });
    }

    public static void saveBitmap(final Bitmap bitmap, final Context context, final OnSaveBitmapCallback callback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                BufferedOutputStream bufferedOutputStream;
                File file;
                Object object = DiskUtils.getInstabugDirectory(context);
                File file2 = file;
                file = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file2.toString());
                object = bufferedOutputStream;
                ((BufferedOutputStream)object)(new FileOutputStream(file2));
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object);
                bufferedOutputStream.close();
                object = Uri.fromFile((File)file);
                try {
                    new Handler(Looper.getMainLooper()).post(new Runnable((Uri)object){
                        final /* synthetic */ Uri a;
                        {
                            this.a = uri;
                        }

                        @Override
                        public void run() {
                            Uri uri = this.a;
                            if (uri != null) {
                                callback.onSuccess(uri);
                            } else {
                                callback.onError(new Throwable("Uri equal null"));
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    callback.onError(iOException);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void saveDrawableBitmap(Drawable drawable2, File file, OnSaveBitmapCallback callback) {
        void var2_2;
        Drawable drawable3;
        void var1_1;
        if (drawable2 == null) {
            return;
        }
        PoolProvider.postBitmapTask(new Runnable((File)var1_1, drawable3, (OnSaveBitmapCallback)var2_2){
            final /* synthetic */ File a;
            final /* synthetic */ Drawable b;
            final /* synthetic */ OnSaveBitmapCallback c;
            {
                this.a = file;
                this.b = drawable2;
                this.c = onSaveBitmapCallback;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                block3: {
                    void var1_3;
                    InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + this.a.getPath());
                    try {
                        BitmapUtils.drawableToBitmap(this.b, new g(){

                            /*
                             * Loose catch block
                             * WARNING - void declaration
                             */
                            @Override
                            public void a(Bitmap bitmap) {
                                void var0_3;
                                BufferedOutputStream bufferedOutputStream;
                                block17: {
                                    block18: {
                                        block16: {
                                            BufferedOutputStream bufferedOutputStream2;
                                            Object var2_5 = null;
                                            bufferedOutputStream = bufferedOutputStream2;
                                            Bitmap bitmap2 = bitmap;
                                            bufferedOutputStream(new FileOutputStream(a));
                                            bitmap2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bufferedOutputStream);
                                            bufferedOutputStream2.close();
                                            catch (IOException iOException) {
                                                break block16;
                                            }
                                            catch (Throwable throwable) {
                                                bufferedOutputStream = var2_5;
                                                break block17;
                                            }
                                            catch (IOException iOException) {
                                                bufferedOutputStream = var2_5;
                                            }
                                        }
                                        InstabugSDKLogger.e(BitmapUtils.TAG, "can't compress bitmap");
                                        if (bufferedOutputStream == null) break block18;
                                        try {
                                            bufferedOutputStream.close();
                                        }
                                        catch (IOException iOException) {
                                            InstabugSDKLogger.e(BitmapUtils.TAG, "can't close BufferedOutputStream");
                                        }
                                    }
                                    bitmap = Uri.fromFile((File)a);
                                    if (bitmap != null) {
                                        c.onSuccess((Uri)bitmap);
                                    } else {
                                        c.onError(new Throwable("Uri equal null"));
                                    }
                                    return;
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                if (bufferedOutputStream != null) {
                                    try {
                                        bufferedOutputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        InstabugSDKLogger.e(BitmapUtils.TAG, "can't close BufferedOutputStream");
                                    }
                                }
                                throw var0_3;
                            }
                        });
                        break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.c.onError((Throwable)var1_3);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void drawableToBitmap(Drawable drawable2, g onBitmapReady) {
        void var1_1;
        Drawable drawable3;
        Context context;
        if (drawable2 instanceof BitmapDrawable && (context = ((BitmapDrawable)drawable3).getBitmap()) != null) {
            var1_1.a(BitmapUtils.resizeBitmap((Bitmap)context, 24.0f, 24.0f));
        }
        if ((context = Instabug.getApplicationContext()) != null) {
            int n = DisplayUtils.dpToPx(context.getResources(), 72);
            final int n2 = drawable3.getIntrinsicWidth();
            final int n3 = drawable3.getIntrinsicHeight();
            if (n2 <= n && n3 <= n) {
                Canvas canvas;
                Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                final Canvas canvas2 = canvas;
                canvas = new Canvas(bitmap);
                PoolProvider.postMainThreadTask(new Runnable((g)var1_1, bitmap){
                    final /* synthetic */ g e;
                    final /* synthetic */ Bitmap f;
                    {
                        this.e = g2;
                        this.f = bitmap;
                    }

                    @Override
                    public void run() {
                        e e2 = this;
                        e e3 = this;
                        int n = e3.canvas2.getWidth();
                        int n22 = e3.canvas2.getHeight();
                        e2.drawable3.setBounds(0, 0, n, n22);
                        e2.drawable3.draw(canvas2);
                        PoolProvider.postBitmapTask(new Runnable(){

                            @Override
                            public void run() {
                                a a2 = object;
                                Object object = a2.this;
                                object = BitmapUtils.getTargetDimensions(object.n2, object.n3);
                                e e2 = a2.this;
                                e2.e.a(BitmapUtils.resizeBitmap(e2.f, (float)object[0], (float)object[1]));
                            }
                        });
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float[] getTargetDimensions(int realWidth, int realHeight) {
        void var1_1;
        int n;
        float f2 = 24.0f;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = f2;
        fArray[1] = f2;
        if (realHeight > realWidth) {
            fArray2[0] = (float)n / (float)var1_1 * f2;
        } else if (var1_1 < n) {
            fArray2[1] = (float)var1_1 / (float)n * f2;
        }
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap resizeBitmap(Bitmap bitmap, float targetWidth, float targetHeight) {
        Matrix matrix;
        Canvas canvas;
        Bitmap bitmap2;
        void var2_2;
        void var1_1;
        if (bitmap == null) {
            return null;
        }
        if (var1_1 == 0.0f && var2_2 == 0.0f) {
            return bitmap2;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)((int)var1_1), (int)((int)var2_2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2.getWidth() < bitmap2.getHeight() && var1_1 > var2_2) {
            return bitmap2;
        }
        if (bitmap2.getWidth() > bitmap2.getHeight() && var1_1 < var2_2) {
            return bitmap2;
        }
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap3);
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (bitmap2.getWidth() < bitmap2.getHeight()) {
            matrix2.setScale((float)(var1_1 / (float)bitmap2.getWidth()), (float)(var2_2 / (float)bitmap2.getHeight()));
        } else {
            matrix2.setScale((float)(var2_2 / (float)bitmap2.getHeight()), (float)(var1_1 / (float)bitmap2.getWidth()));
        }
        canvas2.drawBitmap(bitmap2, matrix2, new Paint());
        return bitmap3;
    }

    public static void saveBitmap(final Bitmap bitmap, final Uri imageUri, final Context context, final OnSaveBitmapCallback callback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap2 = bitmap;
                Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                final boolean bl = bitmap2.compress(compressFormat, 100, context.getContentResolver().openOutputStream(Uri.fromFile((File)new File(imageUri.getPath()))));
                try {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            if (bl && (this = callback) != null) {
                                this.onSuccess(null);
                            }
                        }
                    });
                }
                catch (FileNotFoundException fileNotFoundException) {
                    InstabugSDKLogger.e(BitmapUtils.TAG, fileNotFoundException.getMessage(), fileNotFoundException);
                }
            }
        });
    }

    public static void maskBitmap(Bitmap bitmap, SettingsManager settingsManager, @Nullable Canvas canvas) {
        Iterator<WeakReference<View>> iterator;
        HashSet hashSet;
        HashSet hashSet2;
        Canvas canvas2;
        if (canvas == null) {
            Canvas canvas3;
            canvas2 = canvas3;
            canvas3 = new Canvas((Bitmap)hashSet2);
        }
        hashSet2 = hashSet;
        hashSet = new HashSet();
        for (WeakReference<View> weakReference : ((SettingsManager)((Object)iterator)).getPrivateViews()) {
            if (weakReference != null && weakReference.get() != null) {
                View view = (View)weakReference.get();
                if (view == null || !ScreenshotTaker.isVisible(view)) continue;
                View view2 = view;
                view2.getLocationOnScreen(new int[2]);
                canvas2.drawRect(ScreenshotTaker.getVisibleRect(view2), new Paint());
                continue;
            }
            hashSet2.add(weakReference);
        }
        SettingsManager.getInstance().getPrivateViews().removeAll(hashSet2);
    }

    static interface g {
        public void a(Bitmap var1);
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

