/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Activity;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class PresentationManager {
    private static final String TAG = "PresentationManager";
    private static volatile PresentationManager INSTANCE;
    private volatile ArrayList<Runnable> screensList = new ArrayList();
    private WeakReference<Activity> currentActivity;
    private String lastRunnableName;
    private boolean isNotificationShowing = false;
    private boolean isInInstabugContext = false;

    private PresentationManager() {
    }

    public static PresentationManager getInstance() {
        PresentationManager presentationManager;
        if (INSTANCE != null) {
            presentationManager = INSTANCE;
        } else {
            PresentationManager presentationManager2;
            presentationManager = presentationManager2;
            INSTANCE = new PresentationManager();
        }
        return presentationManager;
    }

    private boolean hasPreviousRunnable(ArrayList<Runnable> screensList) {
        Iterator<Runnable> iterator = screensList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getClass().getName().equals(this.lastRunnableName)) continue;
            InstabugSDKLogger.v(TAG, "hasPreviousRunnable");
            return true;
        }
        InstabugSDKLogger.v(TAG, "hasPreviousRunnable false");
        return false;
    }

    public static void release() {
        INSTANCE = null;
    }

    public void show(Runnable runnable) {
        Object object;
        InstabugSDKLogger.v(TAG, "show");
        CharSequence charSequence = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("runnable is null: ");
        boolean bl = runnable == null;
        InstabugSDKLogger.v(charSequence, stringBuilder.append(bl).toString());
        if (object != null) {
            PresentationManager presentationManager = this;
            if (!presentationManager.hasPreviousRunnable(presentationManager.screensList)) {
                PresentationManager presentationManager2 = this;
                presentationManager2.screensList.add((Runnable)object);
                InstabugSDKLogger.v(TAG, "screensList Size:" + this.screensList.size());
                object = TAG;
                charSequence = new StringBuilder().append("currentActivity != null:");
                boolean bl2 = presentationManager2.currentActivity != null;
                InstabugSDKLogger.v(object, ((StringBuilder)charSequence).append(bl2).toString());
                InstabugSDKLogger.v(TAG, "currentActivity.get() != null:" + this.currentActivity.get());
                InstabugSDKLogger.v(TAG, "!(currentActivity.get() instanceof _InstabugActivity: " + (this.currentActivity.get() instanceof _InstabugActivity ^ true));
                InstabugSDKLogger.v(TAG, "!isNotificationShowing:" + (this.isNotificationShowing ^ true));
                InstabugSDKLogger.v(TAG, "!isInInstabugContext:" + (this.isInInstabugContext ^ true));
                if (!(this.screensList.size() != 1 || (object = this.currentActivity) == null || ((Reference)object).get() == null || this.currentActivity.get() instanceof _InstabugActivity || this.isNotificationShowing || this.isInInstabugContext)) {
                    this.notifyActivityChanged();
                }
                return;
            }
        }
    }

    public void notifyActivityChanged() {
        InstabugSDKLogger.v(TAG, "screensList.size(): " + this.screensList.size());
        InstabugSDKLogger.v(TAG, "!InstabugCore.isForegroundBusy(): " + (InstabugCore.isForegroundBusy() ^ true));
        if (this.screensList.size() > 0 && !InstabugCore.isForegroundBusy()) {
            PresentationManager presentationManager = this;
            presentationManager.lastRunnableName = presentationManager.screensList.get(0).getClass().getName();
            presentationManager.screensList.remove(0).run();
        }
    }

    public void setCurrentActivity(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    public String getCurrentActivityName() {
        WeakReference<Activity> this_ = ((PresentationManager)((Object)this_)).currentActivity;
        if (this_ != null && (this_ = (Activity)this_.get()) != null) {
            return this_.getLocalClassName();
        }
        return "";
    }

    public void setNotificationShowing(boolean isNotificationShowing) {
        this.isNotificationShowing = isNotificationShowing;
    }

    public void setInInstabugContext(boolean inInstabugContext) {
        this.isInInstabugContext = inInstabugContext;
    }
}

