/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.res.ResourcesCompat;
import com.instabug.library.R;
import com.instabug.library.view.ViewUtils;
import com.instabug.library.view.a;

public class IconView
extends TextView {
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_DP = 24;
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_PADDING_DP = 1;
    private Typeface font;
    @ColorInt
    int backgroundColor;
    float strokeWidth;
    @ColorInt
    int strokeColor;
    Paint paint;

    public IconView(Context context) {
        this(context, null);
    }

    public IconView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - void declaration
     */
    public IconView(Context context, AttributeSet attrs, int defStyle) {
        int n;
        void var2_2;
        TypedArray typedArray;
        IconView iconView = this;
        super(context, attrs, defStyle);
        iconView.backgroundColor = 0;
        iconView.strokeWidth = 0.0f;
        iconView.strokeColor = 0;
        if (iconView.isInEditMode()) {
            return;
        }
        IconView iconView2 = this;
        iconView2.font = ResourcesCompat.getFont((Context)typedArray, (int)R.font.font_icons);
        iconView2.setTypeface(iconView2.font);
        typedArray = typedArray.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.IconView);
        if (!typedArray.hasValue(R.styleable.IconView_android_textSize)) {
            this.setActionBarSize();
        }
        if (!typedArray.hasValue(R.styleable.IconView_android_padding)) {
            this.setActionBarPadding();
        }
        if (!typedArray.hasValue(R.styleable.IconView_android_textColor)) {
            this.setTextColor(com.instabug.library.settings.a.C().l());
        }
        if ((n = typedArray.getInt(R.styleable.IconView_instabug_icon, -1)) != -1) {
            this.setText(a.a(n));
        }
        typedArray.recycle();
        this.paint = new Paint(1);
    }

    private void setActionBarSize() {
        this.setTextSize(1, 24.0f);
    }

    private void setActionBarPadding() {
        IconView iconView = this;
        iconView.setPadding(ViewUtils.convertDpToPx(iconView.getContext(), 1.0f));
    }

    public void setPadding(int padding) {
        int n = padding;
        this.setPadding(n, n, n, n);
    }

    public void setBackgroundColor(@ColorInt int color2) {
        this.backgroundColor = color2;
        this.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    public void setStrokeColor(@ColorInt int strokeColor) {
        this.strokeColor = strokeColor;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        Canvas canvas2 = canvas;
        IconView iconView = this;
        IconView iconView2 = this;
        iconView2.paint.setColor(this.backgroundColor);
        iconView2.paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)iconView2.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f) - this.strokeWidth / 2.0f, this.paint);
        iconView.paint.setStrokeWidth(this.strokeWidth);
        iconView.paint.setColor(this.strokeColor);
        iconView.paint.setStyle(Paint.Style.STROKE);
        canvas2.drawCircle((float)iconView.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f) - this.strokeWidth / 2.0f, this.paint);
        super.onDraw(canvas2);
    }
}

