/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.util.f;
import java.util.Locale;

public class LocaleUtils {
    /*
     * WARNING - void declaration
     */
    public static void setLocale(Activity activity, Locale locale) {
        Activity activity2;
        void var1_1;
        Configuration configuration = activity.getApplicationContext().getResources().getConfiguration();
        int n = Build.VERSION.SDK_INT;
        if (n >= 24) {
            if (var1_1 != null) {
                configuration.setLocales(new LocaleList(new Locale[]{var1_1}));
                LocaleUtils.updateResources((Context)activity2, (Locale)var1_1);
            }
        } else if (n >= 17) {
            configuration.setLocale((Locale)var1_1);
        } else {
            configuration.locale = var1_1;
        }
        activity2.getResources().updateConfiguration(configuration, activity2.getResources().getDisplayMetrics());
    }

    @TargetApi(value=24)
    private static Context updateResources(Context context, Locale locale) {
        Context context2 = context;
        Locale.setDefault(locale);
        Configuration configuration = context2.getResources().getConfiguration();
        configuration.setLocale(locale);
        configuration.setLayoutDirection(locale);
        return context2.createConfigurationContext(configuration);
    }

    /*
     * WARNING - void declaration
     */
    public static String getLocaleStringResource(Locale requestedLocale, int resourceId, Context context) {
        String string2;
        Locale locale;
        void var1_1;
        void var2_2;
        if (Build.VERSION.SDK_INT >= 17) {
            string2 = LocaleUtils.getLocalizedStringResNewAPI((Context)var2_2, (int)var1_1, locale);
            if (string2 == null) {
                string2 = LocaleUtils.getLocalizedStringResOldAPI((Context)var2_2, (int)var1_1, locale);
            }
        } else {
            string2 = LocaleUtils.getLocalizedStringResOldAPI((Context)var2_2, (int)var1_1, locale);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @TargetApi(value=17)
    private static String getLocalizedStringResNewAPI(Context context, int resourceId, Locale requestedLocale) {
        void var1_1;
        Context context2;
        Configuration configuration = new Configuration(context.getResources().getConfiguration());
        configuration.setLocale(requestedLocale);
        context = context.createConfigurationContext(configuration);
        return context == null ? null : context2.getText((int)var1_1).toString();
    }

    @NonNull
    private static String getLocalizedStringResOldAPI(Context context, int resourceId2, Locale requestedLocale) {
        Context context2 = context = context.getResources();
        Configuration resourceId2 = context2.getConfiguration();
        Locale locale = requestedLocale;
        requestedLocale = resourceId2.locale;
        resourceId2.locale = locale;
        context2.updateConfiguration(resourceId2, null);
        String string2 = context.getString(resourceId2);
        resourceId2.locale = requestedLocale;
        context.updateConfiguration(resourceId2, null);
        return string2;
    }

    public static boolean isRTL(Locale locale) {
        Locale locale2;
        if (Build.VERSION.SDK_INT >= 17) {
            return TextUtils.getLayoutDirectionFromLocale((Locale)locale2) == 1;
        }
        byte by = Character.getDirectionality(locale2.getDisplayName().charAt(0));
        return by == 1 || by == 2;
    }

    public static String getCurrentLocaleResolved(Context context) {
        return new f(context).a();
    }

    public static String resolveLocale(Context context, Locale locale) {
        return new f(context).a(locale);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSupportedBySdk(Context context, Locale locale) {
        void var1_1;
        if (context != null && var1_1 != null) {
            Context context2;
            return new f(context2).c(var1_1.getLanguage());
        }
        return false;
    }
}

