/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.app.ProgressDialog;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.MediaController;
import android.widget.VideoView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.instabug.library.Feature;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.c;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PlaceHolderUtils;

public class VideoPlayerFragment
extends InstabugBaseFragment {
    public static final String VIDEO_PATH = "video.uri";
    public static final String TAG = "VideoPlayerFragment";
    private VideoView videoView;
    private int position = 0;
    private ProgressDialog progressDialog;
    private MediaController mediaControls;
    private String videoUri;

    public static VideoPlayerFragment newInstance(String videoUri) {
        VideoPlayerFragment videoPlayerFragment = new VideoPlayerFragment();
        Bundle bundle = new Bundle();
        bundle.putString(VIDEO_PATH, videoUri);
        videoPlayerFragment.setArguments(bundle);
        return videoPlayerFragment;
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_video_view;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.videoView = (VideoView)view.findViewById(R.id.video_view);
        if (c.b().a(Feature.WHITE_LABELING) == Feature.State.DISABLED) {
            this.getActivity().findViewById(R.id.instabug_pbi_footer).setVisibility(8);
        }
    }

    @Override
    public void onResume() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onResume();
        videoPlayerFragment.showToolbar(false);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onActivityCreated(savedInstanceState);
        if (videoPlayerFragment.mediaControls == null) {
            this.mediaControls = new MediaController((Context)this.getActivity());
        }
        VideoPlayerFragment videoPlayerFragment2 = this;
        videoPlayerFragment2.progressDialog = new ProgressDialog((Context)this.getActivity());
        videoPlayerFragment2.progressDialog.setMessage((CharSequence)"Loading...");
        videoPlayerFragment2.progressDialog.setCancelable(false);
        videoPlayerFragment2.progressDialog.show();
        try {
            videoPlayerFragment2.videoView.setMediaController(this.mediaControls);
            videoPlayerFragment2.videoView.setVideoURI(Uri.parse((String)this.videoUri));
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, exception.getMessage(), exception);
        }
        VideoPlayerFragment videoPlayerFragment3 = this;
        videoPlayerFragment3.videoView.requestFocus();
        videoPlayerFragment3.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                a a2 = this;
                a2.VideoPlayerFragment.this.progressDialog.dismiss();
                a2.VideoPlayerFragment.this.videoView.seekTo(VideoPlayerFragment.this.position);
                if (a2.VideoPlayerFragment.this.position == 0) {
                    VideoPlayerFragment.this.videoView.start();
                } else {
                    VideoPlayerFragment.this.videoView.pause();
                }
            }
        });
        videoPlayerFragment3.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                VideoPlayerFragment.this.progressDialog.dismiss();
                return false;
            }
        });
    }

    @Override
    protected String getTitle() {
        return PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VIDEO_PLAYER_TITLE, this.getString(R.string.instabug_str_video_player));
    }

    public void onDestroy() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onDestroy();
        videoPlayerFragment.showToolbar(true);
    }

    @Override
    protected void consumeNewInstanceSavedArguments() {
        this.videoUri = this.getArguments().getString(VIDEO_PATH);
    }

    @Override
    protected void restoreState(Bundle savedInstanceState) {
        this.position = savedInstanceState.getInt("Position");
        this.videoView.seekTo(this.position);
    }

    @Override
    protected void saveState(Bundle outState) {
        outState.putInt("Position", this.videoView.getCurrentPosition());
        this.videoView.pause();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (c.b().a(Feature.WHITE_LABELING) == Feature.State.DISABLED) {
            this.getActivity().findViewById(R.id.instabug_pbi_footer).setVisibility(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void showToolbar(boolean shouldShow) {
        if (this.getActivity() != null && ((AppCompatActivity)this.getActivity()).getSupportActionBar() != null) {
            void var1_1;
            if (var1_1 != false) {
                ((AppCompatActivity)this.getActivity()).getSupportActionBar().show();
            } else {
                ((AppCompatActivity)this.getActivity()).getSupportActionBar().hide();
            }
        }
    }
}

