/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;

public class ScreenUtility {
    public static int getScreenHeight(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public static boolean isLandscape(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels > displayMetrics.heightPixels;
    }

    public static boolean hasNavBar(Context context) {
        if (context == null) {
            return false;
        }
        boolean bl = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean bl2 = KeyCharacterMap.deviceHasKey((int)4);
        return !bl || !bl2;
    }

    public static int getNavigationBarWidth(Resources resources) {
        int n = resources.getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return resources.getDimensionPixelSize(n);
        }
        return 0;
    }

    public static int getNavigationBarHeight(Resources resources) {
        int n = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (n > 0) {
            return resources.getDimensionPixelSize(n);
        }
        return 0;
    }
}

