/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.webkit.URLUtil;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class FileUtils {
    private static final int NOT_FOUND = -1;
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';

    public static int getFileType(@NonNull File file) {
        if (file.isDirectory()) {
            return 2;
        }
        String string2 = file.getAbsolutePath();
        int n = FileUtils.getIndexOfExtension(string2);
        return n == -1 ? -1 : FileUtils.getTypeFromExtension(string2);
    }

    public static Intent getFileViewerIntent(@NonNull String pathOrUrl) {
        if (URLUtil.isNetworkUrl((String)pathOrUrl)) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)pathOrUrl));
        }
        String string2 = FileUtils.getExtension(pathOrUrl);
        Uri uri = Uri.fromFile((File)new File(pathOrUrl));
        return FileUtils.appropriateIntent(uri, string2);
    }

    public static String getExtension(@NonNull File file) {
        return FileUtils.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(@NonNull String absolutePath) {
        int n = FileUtils.getIndexOfExtension(absolutePath);
        return n == -1 ? "" : absolutePath.substring(n + 1);
    }

    public static boolean isVideoFile(@NonNull File file) {
        if (!file.isFile()) {
            return false;
        }
        String string2 = FileUtils.getExtension(file);
        return FileUtils.isVideoExtension(string2);
    }

    public static boolean isImageFile(@NonNull File file) {
        if (!file.isFile()) {
            return false;
        }
        String string2 = FileUtils.getExtension(file);
        return FileUtils.isImageExtension(string2);
    }

    public static boolean isTextFile(@NonNull File file) {
        if (!file.isFile()) {
            return false;
        }
        String string2 = FileUtils.getExtension(file.getAbsolutePath());
        return FileUtils.isTextExtension(string2);
    }

    public static boolean isVideoExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("mp4") || extension.equalsIgnoreCase("avi") || extension.equalsIgnoreCase("mpg") || extension.equalsIgnoreCase("3gp") || extension.equalsIgnoreCase("3gpp") || extension.equalsIgnoreCase("ts") || extension.equalsIgnoreCase("AAC") || extension.equalsIgnoreCase("webm") || extension.equalsIgnoreCase("mkv");
    }

    public static boolean isImageExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("gif") || extension.equalsIgnoreCase("png") || extension.equalsIgnoreCase("bmp") || extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("webp");
    }

    private static boolean isTextExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("txt");
    }

    public static void sortByLastModifiedAsc(@NonNull List<File> files) {
        Collections.sort(files, new Comparator<File>(){

            public int a(File file, File file2) {
                return Double.compare(file.lastModified(), file2.lastModified());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((File)object, (File)object2);
            }
        });
    }

    public static long getSize(@NonNull File file) {
        if (!file.exists()) {
            return 0L;
        }
        long l = file.length();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < (fileArray == null ? 0 : fileArray.length); ++i2) {
                l += FileUtils.getSize(fileArray[i2]);
            }
        }
        return l;
    }

    private static int getTypeFromExtension(String absolutePath) {
        String string2 = FileUtils.getExtension(absolutePath);
        if (FileUtils.isVideoExtension(string2)) {
            return 0;
        }
        if (FileUtils.isImageExtension(string2)) {
            return 1;
        }
        return -1;
    }

    private static Intent appropriateIntent(Uri uri, String extension) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (extension.equalsIgnoreCase("doc") || extension.equalsIgnoreCase("docx")) {
            intent.setDataAndType(uri, "application/msword");
        } else if (extension.equalsIgnoreCase("pdf")) {
            intent.setDataAndType(uri, "application/pdf");
        } else if (extension.equalsIgnoreCase("ppt") || extension.equalsIgnoreCase("pptx")) {
            intent.setDataAndType(uri, "application/vnd.ms-powerpoint");
        } else if (extension.equalsIgnoreCase("xls") || extension.equalsIgnoreCase("xlsx")) {
            intent.setDataAndType(uri, "application/vnd.ms-excel");
        } else if (extension.equalsIgnoreCase("zip") || extension.equalsIgnoreCase("rar")) {
            intent.setDataAndType(uri, "application/x-wav");
        } else if (extension.equalsIgnoreCase("rtf")) {
            intent.setDataAndType(uri, "application/rtf");
        } else if (extension.equalsIgnoreCase("wav") || extension.equalsIgnoreCase("mp3")) {
            intent.setDataAndType(uri, "audio/x-wav");
        } else if (extension.equalsIgnoreCase("gif")) {
            intent.setDataAndType(uri, "image/gif");
        } else if (extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("png")) {
            intent.setDataAndType(uri, "image/jpeg");
        } else if (extension.equalsIgnoreCase("txt")) {
            intent.setDataAndType(uri, "text/plain");
        } else if (extension.equalsIgnoreCase("3gp") || extension.equalsIgnoreCase("mpg") || extension.equalsIgnoreCase("mpeg") || extension.equalsIgnoreCase("mpe") || extension.equalsIgnoreCase("mp4") || extension.equalsIgnoreCase("avi")) {
            intent.setDataAndType(uri, "video/*");
        } else {
            intent.setDataAndType(uri, "*/*");
        }
        intent.addFlags(0x10000000);
        return intent;
    }

    private static int getIndexOfExtension(String filename) {
        int n = filename.lastIndexOf(46);
        int n2 = filename.lastIndexOf(47);
        return n2 > n ? -1 : n;
    }
}

