/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Activity;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PresentationManager {
    private static final String TAG = "PresentationManager";
    private static volatile PresentationManager INSTANCE;
    private volatile ArrayList<Runnable> screensList = new ArrayList();
    private WeakReference<Activity> currentActivity;
    private String lastRunnableName;
    private boolean isNotificationShowing = false;
    private boolean isInInstabugContext = false;

    private PresentationManager() {
    }

    public static PresentationManager getInstance() {
        return INSTANCE != null ? INSTANCE : (INSTANCE = new PresentationManager());
    }

    public void show(Runnable runnable) {
        InstabugSDKLogger.v(TAG, "show");
        InstabugSDKLogger.v(TAG, "runnable is null: " + (runnable == null));
        if (runnable == null || this.hasPreviousRunnable(this.screensList)) {
            return;
        }
        this.screensList.add(runnable);
        InstabugSDKLogger.v(TAG, "screensList Size:" + this.screensList.size());
        InstabugSDKLogger.v(TAG, "currentActivity != null:" + (this.currentActivity != null));
        InstabugSDKLogger.v(TAG, "currentActivity.get() != null:" + this.currentActivity.get());
        InstabugSDKLogger.v(TAG, "!(currentActivity.get() instanceof _InstabugActivity: " + !(this.currentActivity.get() instanceof _InstabugActivity));
        InstabugSDKLogger.v(TAG, "!isNotificationShowing:" + !this.isNotificationShowing);
        InstabugSDKLogger.v(TAG, "!isInInstabugContext:" + !this.isInInstabugContext);
        if (!(this.screensList.size() != 1 || this.currentActivity == null || this.currentActivity.get() == null || this.currentActivity.get() instanceof _InstabugActivity || this.isNotificationShowing || this.isInInstabugContext)) {
            this.notifyActivityChanged();
        }
    }

    private boolean hasPreviousRunnable(ArrayList<Runnable> screensList) {
        for (Runnable runnable : screensList) {
            if (!runnable.getClass().getName().equals(this.lastRunnableName)) continue;
            InstabugSDKLogger.v(TAG, "hasPreviousRunnable");
            return true;
        }
        InstabugSDKLogger.v(TAG, "hasPreviousRunnable false");
        return false;
    }

    public void notifyActivityChanged() {
        InstabugSDKLogger.v(TAG, "screensList.size(): " + this.screensList.size());
        InstabugSDKLogger.v(TAG, "!InstabugCore.isForegroundBusy(): " + !InstabugCore.isForegroundBusy());
        if (this.screensList.size() > 0 && !InstabugCore.isForegroundBusy()) {
            this.lastRunnableName = this.screensList.get(0).getClass().getName();
            Runnable runnable = this.screensList.remove(0);
            runnable.run();
        }
    }

    public void setCurrentActivity(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    public String getCurrentActivityName() {
        Activity activity;
        if (this.currentActivity != null && (activity = (Activity)this.currentActivity.get()) != null) {
            return activity.getLocalClassName();
        }
        return "";
    }

    public void setNotificationShowing(boolean isNotificationShowing) {
        this.isNotificationShowing = isNotificationShowing;
    }

    public void setInInstabugContext(boolean inInstabugContext) {
        this.isInInstabugContext = inInstabugContext;
    }

    public static void release() {
        INSTANCE = null;
    }
}

