/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.user;

import com.instabug.library.user.UserEventParam;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserEvent {
    private static final String EVENT = "event";
    private static final String TIMESTAMP = "timestamp";
    private static final String PARAMS = "params";
    private String eventIdentifier;
    private long date;
    private List<UserEventParam> params = new ArrayList<UserEventParam>();

    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    public UserEvent setEventIdentifier(String eventIdentifier) {
        this.eventIdentifier = eventIdentifier;
        return this;
    }

    public long getDate() {
        return this.date;
    }

    public UserEvent setDate(long date) {
        this.date = date;
        return this;
    }

    public List<UserEventParam> getParams() {
        return this.params;
    }

    public UserEvent addParam(UserEventParam userEventParam) {
        this.params.add(userEventParam);
        return this;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(EVENT, (Object)this.getEventIdentifier());
        jSONObject.put(TIMESTAMP, this.getDate());
        JSONObject jSONObject2 = new JSONObject();
        for (UserEventParam userEventParam : this.getParams()) {
            jSONObject2.put(userEventParam.getKey(), (Object)userEventParam.getValue());
        }
        jSONObject.put(PARAMS, (Object)jSONObject2);
        return jSONObject;
    }

    public static JSONArray toJson(List<UserEvent> userEvents) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (UserEvent userEvent : userEvents) {
            jSONArray.put((Object)userEvent.toJson());
        }
        return jSONArray;
    }

    public boolean equals(Object userEvent) {
        if (userEvent != null && userEvent instanceof UserEvent) {
            UserEvent userEvent2 = (UserEvent)userEvent;
            if (String.valueOf(userEvent2.getEventIdentifier()).equals(String.valueOf(this.getEventIdentifier())) && String.valueOf(userEvent2.getDate()).equals(String.valueOf(this.getDate()))) {
                if (userEvent2.getParams().size() == this.getParams().size()) {
                    for (int i2 = 0; i2 < this.params.size(); ++i2) {
                        if (userEvent2.getParams().get(i2).equals(this.getParams().get(i2))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.getEventIdentifier() != null) {
            return String.valueOf(this.getDate() + ": " + this.getEventIdentifier()).hashCode();
        }
        return -1;
    }
}

