/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.text.TextUtils;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class OnDiskCache<V extends Cacheable>
extends Cache<String, V> {
    public static final String TAG = "OnDiskCache";
    private final File cacheFile;
    private final File cacheDir;
    private Class<V> VClass;
    private final Charset charset;

    public OnDiskCache(Context context, String cacheId, String cacheFileName, Class<V> VClass) {
        super(cacheId);
        this.VClass = VClass;
        this.cacheDir = context.getCacheDir();
        this.cacheFile = new File(this.cacheDir + cacheFileName);
        if (!this.cacheFile.exists()) {
            try {
                this.cacheFile.createNewFile();
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, "Failed to create", iOException);
            }
        }
        this.charset = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();
        if (!this.checkCacheValidity()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getValues() {
        ArrayList<Cacheable> arrayList = new ArrayList<Cacheable>();
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.addVerboseLog(TAG, "Cache file doesn't exist");
            return arrayList;
        }
        File file = this.cacheFile;
        synchronized (file) {
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), this.charset));
                do {
                    String string3;
                    if ((string3 = this.getValue(string2 = bufferedReader.readLine())) == null || string3.isEmpty()) continue;
                    Cacheable cacheable = (Cacheable)this.VClass.newInstance();
                    cacheable.fromJson(this.getValue(string2));
                    arrayList.add(cacheable);
                } while (string2 != null);
            }
            catch (InstantiationException instantiationException) {
                InstabugSDKLogger.e(TAG, "InstantiationException happened while fetching values", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                InstabugSDKLogger.e(TAG, "IllegalAccessException went wrong while fetching", illegalAccessException);
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, "IOException went wrong while fetching values", iOException);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(TAG, "JSONException went wrong while fetching values", jSONException);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(TAG, "Failed to close file reader", iOException);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V get(String key) {
        if (key == null) {
            InstabugSDKLogger.d(TAG, "Key equal null");
            return null;
        }
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(TAG, "Cache file doesn't exist");
            return null;
        }
        BufferedReader bufferedReader = null;
        Cacheable cacheable = null;
        try {
            cacheable = (Cacheable)this.VClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            InstabugSDKLogger.e(TAG, "InstantiationException happened while fetching value for key " + key, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            InstabugSDKLogger.e(TAG, "IllegalAccessException went wrong while fetching value for key " + key, illegalAccessException);
        }
        File file = this.cacheFile;
        synchronized (file) {
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), this.charset));
                do {
                    String string3;
                    if ((string3 = this.getKey(string2 = bufferedReader.readLine())) == null || !string3.equals(key)) continue;
                    cacheable.fromJson(this.getValue(string2));
                    Cacheable cacheable2 = cacheable;
                    return (V)cacheable2;
                } while (string2 != null);
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, "IOException went wrong while fetching value for key " + key, iOException);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(TAG, "JSONException went wrong while fetching value for key " + key, jSONException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e("OOM while fetching value for key " + key, outOfMemoryError.toString());
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(TAG, "Failed to close file reader", iOException);
                }
            }
            InstabugSDKLogger.d(TAG, "No value found for key " + key + ", returning null");
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public V put(String key, V value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V delete(String key) {
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(TAG, "Cache file doesn't exist");
            return null;
        }
        File file = new File(this.cacheDir + "/cache.tmp");
        Cacheable cacheable = null;
        try {
            cacheable = (Cacheable)this.VClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            InstabugSDKLogger.e(TAG, "InstantiationException happened while deleting value for key " + key, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            InstabugSDKLogger.e(TAG, "IllegalAccessException went wrong while deleting value for key " + key, illegalAccessException);
        }
        File file2 = this.cacheFile;
        synchronized (file2) {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), this.charset));
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), this.charset));
                do {
                    String string3;
                    if ((string3 = this.getKey(string2 = bufferedReader.readLine())) == null) continue;
                    if (string3.equals(key)) {
                        cacheable.fromJson(this.getValue(string2));
                        continue;
                    }
                    bufferedWriter.write(string2 + "\n");
                } while (string2 != null);
                bufferedReader.close();
                bufferedWriter.flush();
                bufferedWriter.close();
                if (this.cacheFile.delete() && !file.renameTo(this.cacheFile)) {
                    InstabugSDKLogger.e(TAG, "Couldn't rename temp cache file");
                }
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, "IOException went wrong while deleting value for key " + key, iOException);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(TAG, "JSONException went wrong while deleting value for key " + key, jSONException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e("OOM while deleting value for key " + key, outOfMemoryError.toString());
            }
        }
        return (V)cacheable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(TAG, "Cache file doesn't exist");
            return -1L;
        }
        File file = this.cacheFile;
        synchronized (file) {
            return this.cacheFile.getTotalSpace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        if (this.cacheFile.exists()) {
            InstabugSDKLogger.d(TAG, "Cache file  exist");
            File file = this.cacheFile;
            synchronized (file) {
                this.cacheFile.delete();
            }
        }
        try {
            this.cacheFile.createNewFile();
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(TAG, "Failed to create cache file", iOException);
        }
    }

    public String getValue(String line) {
        if (line != null && !line.isEmpty() && line.contains(":")) {
            return line.substring(line.indexOf(":") + 1);
        }
        return null;
    }

    public String getKey(String line) {
        if (line != null && !line.isEmpty() && line.contains(":")) {
            return line.substring(0, line.indexOf(":"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCacheValidity() {
        if (!this.cacheFile.exists()) {
            InstabugSDKLogger.d(TAG, "Cache file doesn't exist");
            return false;
        }
        File file = this.cacheFile;
        synchronized (file) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cacheFile), this.charset));
                String string2 = bufferedReader.readLine();
                if (string2 == null) return true;
                String string3 = this.getValue(string2);
                if (TextUtils.isEmpty((CharSequence)string3)) return true;
                new JSONObject(string3);
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e(TAG, "IOException went wrong while fetching values", iOException);
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(TAG, "JSONException went wrong while fetching values", jSONException);
                boolean bl = false;
                return bl;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e("OOM while fetching values ", outOfMemoryError.toString());
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(TAG, "Failed to close file reader", iOException);
                }
            }
            return true;
        }
    }
}

