/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class InMemoryCache<K, V>
extends Cache<K, V> {
    private final LinkedHashMap<K, V> map = new LinkedHashMap();

    public InMemoryCache(String mId) {
        this(mId, 1);
    }

    public InMemoryCache(String mId, int mAppVersion) {
        super(mId, mAppVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V get(K key) {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (value != null && key != null) {
            V v;
            LinkedHashMap<K, V> linkedHashMap = this.map;
            synchronized (linkedHashMap) {
                v = this.map.put(key, value);
            }
            if (v == null) {
                this.notifyItemAdded(value);
                return value;
            }
            this.notifyItemUpdated(v, value);
            return v;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V delete(K key) {
        Object v;
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            v = this.map.remove(key);
        }
        if (v != null) {
            this.notifyItemRemoved(v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            this.map.clear();
        }
        this.notifyCacheInvalidated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getValues() {
        ArrayList<V> arrayList = new ArrayList<V>();
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            for (K k2 : this.map.keySet()) {
                arrayList.add(this.get(k2));
            }
        }
        return arrayList;
    }
}

