/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.ContentValues;
import android.database.Cursor;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.model.Attachment;
import java.util.ArrayList;

public class AttachmentsDbHelper {
    private static final String[] ATTACHMENT_COLUMN = new String[]{"attachments._id", "name", "local_path", "url", "type", "attachment_state", "video_encoded", "duration", "report_id", "encrypted"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long insert(Attachment attachment, String reportId) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("url", attachment.getUrl());
            contentValues.put("attachment_state", attachment.getAttachmentState().name());
            contentValues.put("duration", attachment.getDuration());
            contentValues.put("local_path", attachment.getLocalPath());
            contentValues.put("name", attachment.getName());
            contentValues.put("type", attachment.getType().name());
            contentValues.put("video_encoded", Boolean.valueOf(attachment.isVideoEncoded()));
            contentValues.put("report_id", reportId);
            contentValues.put("encrypted", Boolean.valueOf(attachment.isEncrypted()));
            long l = sQLiteDatabaseWrapper.insert("attachments", null, contentValues);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
            long l2 = l;
            return l2;
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    public static ArrayList<Attachment> retrieve(String reportId, SQLiteDatabaseWrapper db) {
        String[] stringArray = new String[]{"attachments._id", "name", "local_path", "url", "type", "attachment_state", "video_encoded", "duration", "report_id", "encrypted"};
        String[] stringArray2 = new String[]{reportId};
        Cursor cursor = db.query("attachments", stringArray, "report_id=?", stringArray2, null, null, null, null);
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Attachment attachment = new Attachment();
                int n = cursor.getColumnIndex("_id");
                attachment.setId(cursor.getInt(n));
                int n2 = cursor.getColumnIndex("name");
                attachment.setName(cursor.getString(n2));
                int n3 = cursor.getColumnIndex("attachment_state");
                attachment.setAttachmentState(Enum.valueOf(Attachment.AttachmentState.class, cursor.getString(n3)));
                int n4 = cursor.getColumnIndex("duration");
                attachment.setDuration(cursor.getString(n4));
                int n5 = cursor.getColumnIndex("url");
                attachment.setUrl(cursor.getString(n5));
                int n6 = cursor.getColumnIndex("local_path");
                attachment.setLocalPath(cursor.getString(n6));
                int n7 = cursor.getColumnIndex("video_encoded");
                attachment.setVideoEncoded(cursor.getInt(n7) != 0);
                int n8 = cursor.getColumnIndex("type");
                attachment.setType(Enum.valueOf(Attachment.Type.class, cursor.getString(n8)));
                int n9 = cursor.getColumnIndex("encrypted");
                attachment.setEncrypted(cursor.getInt(n9) != 0);
                arrayList.add(attachment);
            } while (cursor.moveToNext());
        }
        if (cursor != null) {
            cursor.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Attachment> retrieve(String reportId) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            ArrayList<Attachment> arrayList;
            String[] stringArray = new String[]{reportId};
            Cursor cursor = sQLiteDatabaseWrapper.query("attachments", ATTACHMENT_COLUMN, "report_id=?", stringArray, null, null, null, null);
            ArrayList<ArrayList<Attachment>> arrayList2 = new ArrayList<ArrayList<Attachment>>();
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    arrayList = new Attachment();
                    int n = cursor.getColumnIndex("_id");
                    ((Attachment)((Object)arrayList)).setId(cursor.getInt(n));
                    int n2 = cursor.getColumnIndex("name");
                    ((Attachment)((Object)arrayList)).setName(cursor.getString(n2));
                    int n3 = cursor.getColumnIndex("attachment_state");
                    ((Attachment)((Object)arrayList)).setAttachmentState(Enum.valueOf(Attachment.AttachmentState.class, cursor.getString(n3)));
                    int n4 = cursor.getColumnIndex("duration");
                    ((Attachment)((Object)arrayList)).setDuration(cursor.getString(n4));
                    int n5 = cursor.getColumnIndex("url");
                    ((Attachment)((Object)arrayList)).setUrl(cursor.getString(n5));
                    int n6 = cursor.getColumnIndex("local_path");
                    ((Attachment)((Object)arrayList)).setLocalPath(cursor.getString(n6));
                    int n7 = cursor.getColumnIndex("video_encoded");
                    ((Attachment)((Object)arrayList)).setVideoEncoded(cursor.getInt(n7) != 0);
                    int n8 = cursor.getColumnIndex("type");
                    ((Attachment)((Object)arrayList)).setType(Enum.valueOf(Attachment.Type.class, cursor.getString(n8)));
                    int n9 = cursor.getColumnIndex("encrypted");
                    ((Attachment)((Object)arrayList)).setEncrypted(cursor.getInt(n9) > 0);
                    arrayList2.add(arrayList);
                } while (cursor.moveToNext());
            }
            if (cursor != null) {
                cursor.close();
            }
            sQLiteDatabaseWrapper.setTransactionSuccessful();
            arrayList = arrayList2;
            return arrayList;
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(long id2, ContentValues cv) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.update("attachments", cv, "_id=" + id2, null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(String name, String reportId, ContentValues cv) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.update("attachments", cv, "name='" + name + "' and " + "report_id" + "='" + reportId + "'", null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    public static synchronized void delete(long id2) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.delete("attachments", "_id=" + id2, null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    public static synchronized void delete(String name, String reportId) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.delete("attachments", "name='" + name + "' and " + "report_id" + "='" + reportId + "'", null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    public static synchronized void deleteAll() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.delete("attachments", null, null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }
}

