/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class AttachmentsUtility {
    public static final String TAG = "AttachmentsUtility";
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    public static File getVideoFile(Context context) {
        File file = AttachmentsUtility.getNewDirectory(context, "videos");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        String string2 = "video-" + simpleDateFormat.format(new Date()) + ".mp4";
        return new File(file, string2);
    }

    public static File getFilesAttachmentDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "attachments");
    }

    public static File getNewDirectory(Context context, String directoryName) {
        File file = new File(DiskUtils.getInstabugDirectory(context) + "/" + directoryName + "/");
        if (!file.exists() && file.mkdirs()) {
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "frames");
    }

    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(uri, stringArray, null, null, null);
        if (cursor != null) {
            int n = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(n);
        }
        return null;
    }

    @Nullable
    public static Uri getNewFileAttachmentUri(Context context, Uri originalUri, String fileNameWithExtension) {
        File file;
        if (originalUri == null) {
            return null;
        }
        String string2 = originalUri.getLastPathSegment().toLowerCase();
        File file2 = AttachmentsUtility.getFilesAttachmentDirectory(context);
        String string3 = string2;
        if (fileNameWithExtension != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(originalUri)) {
            string3 = fileNameWithExtension;
        }
        if ((file = new File(file2, string3)).exists()) {
            file = new File(file2, String.valueOf(System.currentTimeMillis()) + "_" + string3);
        }
        try {
            DiskUtils.copyFromUriIntoFile(context, originalUri, file);
            if (!AttachmentsUtility.validateFileSize(file, 50.0)) {
                InstabugSDKLogger.w(TAG, "Attachment file size exceeds than the limit 50.0");
                return null;
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)file);
    }

    public static Uri getNewFileAttachmentUri(Context context, Uri originalUri) {
        return AttachmentsUtility.getNewFileAttachmentUri(context, originalUri, null);
    }

    public static File getAttachmentFile(Context context, String fileName) {
        File file = AttachmentsUtility.getFilesAttachmentDirectory(context);
        File file2 = new File(file, fileName);
        if (file2.exists()) {
            file2 = new File(file, String.valueOf(System.currentTimeMillis()) + "_" + fileName);
        }
        return file2;
    }

    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        File file = AttachmentsUtility.getAttachmentFile(context, fileName);
        try {
            AttachmentsUtility.saveBytesToFile(data, file);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)file);
    }

    private static void saveBytesToFile(byte[] data, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(data);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private static boolean validateFileSize(File file, double maxFileSize) {
        long l = file.length();
        double d2 = (double)l / 1048576.0;
        if (d2 > maxFileSize) {
            InstabugSDKLogger.w(TAG, "External attachment file size is " + l + " bytes or " + d2 + " MBs > maxFileSize " + maxFileSize);
            return false;
        }
        return true;
    }

    public static void encryptAttachments(List<Attachment> attachments) {
        InstabugSDKLogger.d(TAG, "encryptAttachments");
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                if (attachment.isEncrypted()) continue;
                InstabugCore.encrypt(attachment.getLocalPath());
                attachment.setEncrypted(true);
            }
        }
    }

    public static void encryptAttachmentsAndUpdateDb(List<Attachment> attachments) {
        InstabugSDKLogger.d(TAG, "encryptAttachmentsAndUpdateDb");
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                if (attachment.isEncrypted()) continue;
                InstabugCore.encrypt(attachment.getLocalPath());
                attachment.setEncrypted(true);
                ContentValues contentValues = new ContentValues();
                contentValues.put("encrypted", Boolean.valueOf(true));
                AttachmentsDbHelper.update(attachment.getId(), contentValues);
            }
        }
    }

    public static void decryptAttachmentAndUpdateDb(Attachment attachment) {
        InstabugSDKLogger.d(TAG, "decryptAttachmentAndUpdateDb");
        if (attachment.isEncrypted()) {
            InstabugCore.decrypt(attachment.getLocalPath());
            attachment.setEncrypted(false);
            ContentValues contentValues = new ContentValues();
            contentValues.put("encrypted", Boolean.valueOf(false));
            AttachmentsDbHelper.update(attachment.getId(), contentValues);
        }
    }
}

