/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.c;
import com.instabug.library.core.eventbus.UserEventsEventBus;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugDateFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InstabugUserEventLogger {
    private static final long DELAY = 1L;
    private static volatile InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 10000;
    private List<UserEvent> userEvents = new ArrayList<UserEvent>();
    private ConcurrentHashMap<String, Integer> userEventsCount = new ConcurrentHashMap();
    private ScheduledExecutorService insertionExecutor;

    private InstabugUserEventLogger() {
    }

    public static InstabugUserEventLogger getInstance() {
        if (instabugUserEventLogger == null) {
            instabugUserEventLogger = new InstabugUserEventLogger();
        }
        return instabugUserEventLogger;
    }

    public synchronized void logUserEvent(@NonNull String eventIdentifier, UserEventParam ... userEventParams) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class), new Api.Parameter().setName("userEventParams").setType(UserEventParam.class));
        if (c.a().c(Feature.USER_EVENTS) == Feature.State.ENABLED) {
            UserEvent userEvent = new UserEvent().setEventIdentifier(eventIdentifier).setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
            for (UserEventParam userEventParam : userEventParams) {
                userEvent.addParam(userEventParam);
            }
            if (this.userEvents.size() >= 10000) {
                this.userEvents.remove(0);
            }
            this.userEvents.add(userEvent);
            Object object = this.userEventsCount.get(eventIdentifier);
            if (object != null) {
                object = (Integer)object + 1;
                this.userEventsCount.put(eventIdentifier, (Integer)object);
            } else {
                this.userEventsCount.put(eventIdentifier, 1);
            }
            UserEventsEventBus.getInstance().post(userEvent);
        }
        this.runInsertionHandler(b.g(), !b.i());
    }

    private void runInsertionHandler(final String uuid, final boolean anonymous) {
        if (this.insertionExecutor == null) {
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
            scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : InstabugUserEventLogger.this.userEventsCount.entrySet()) {
                        InstabugUserEventLogger.this.incrementEventLoggingCount((String)entry.getKey(), (Integer)entry.getValue(), uuid, anonymous);
                    }
                    InstabugUserEventLogger.this.userEventsCount.clear();
                    InstabugUserEventLogger.this.insertionExecutor = null;
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }

    @VisibleForTesting
    int getLoggingEventCount(@NonNull String userEventIdentifier) throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userEventIdentifier").setType(String.class));
        return com.instabug.library.logging.c.a(userEventIdentifier, b.g());
    }

    public List<UserEvent> getUserEvents() throws IllegalStateException {
        return this.userEvents;
    }

    public void clearAll() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        this.userEvents.clear();
    }

    public void clearLoggingData() throws IllegalStateException {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        com.instabug.library.logging.c.a(b.g());
    }

    private void incrementEventLoggingCount(@NonNull String eventIdentifier, int incrementBy, String uuid, boolean anonymous) {
        int n = com.instabug.library.logging.c.a(eventIdentifier, b.g());
        com.instabug.library.logging.c.a(eventIdentifier, n += incrementBy, uuid, anonymous);
    }
}

