/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation.invocationdialog;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.widget.FrameLayout;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.R;
import com.instabug.library.bugreporting.model.Bug;
import com.instabug.library.core.ui.BaseFragmentActivity;
import com.instabug.library.invocation.invocationdialog.InstabugDialogItem;
import com.instabug.library.invocation.invocationdialog.b;
import com.instabug.library.invocation.invocationdialog.c;
import com.instabug.library.invocation.invocationdialog.e;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.util.StatusBarUtils;
import java.util.ArrayList;
import java.util.List;

public class InstabugDialogActivity
extends BaseFragmentActivity<c>
implements View.OnClickListener,
b.a,
b.c,
e.a {
    public static final String KEY_DIALOG_ITEMS = "dialog_items";
    public static final String KEY_DIALOG_TITLE = "dialog_title";
    public static final String KEY_SCREENSHOT_URI = "screenshot_uri";
    private static final String KEY_SHOULD_BE_KILLED = "should_be_killed";
    private View[] sharedViews;
    private boolean shouldBeKilled = false;
    private Uri screenshotUri;

    public static Intent getIntent(Context context, String title, Uri screenshot, ArrayList<InstabugDialogItem> items, boolean shouldBeKilled) {
        Intent intent = new Intent(context, InstabugDialogActivity.class);
        intent.putExtra(KEY_DIALOG_TITLE, title);
        intent.putExtra(KEY_SCREENSHOT_URI, (Parcelable)screenshot);
        intent.putExtra(KEY_DIALOG_ITEMS, items);
        intent.putExtra(KEY_SHOULD_BE_KILLED, shouldBeKilled);
        intent.addFlags(0x10000000);
        return intent;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        FrameLayout frameLayout;
        this.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        super.onCreate(savedInstanceState);
        if (ScreenUtility.hasNavBar((Context)this) && !ScreenUtility.isLandscape((Activity)this) && (frameLayout = (FrameLayout)this.findViewById(R.id.ib_fragment_container)) != null) {
            frameLayout.setPadding(frameLayout.getPaddingLeft(), frameLayout.getPaddingTop(), frameLayout.getPaddingRight(), frameLayout.getPaddingBottom() + ScreenUtility.getNavigationBarHeight(this.getResources()));
        }
        this.screenshotUri = (Uri)this.getIntent().getParcelableExtra(KEY_SCREENSHOT_URI);
        this.runOnSdkInvokedRunnable();
        StatusBarUtils.setStatusBarForDialog((Activity)this);
    }

    private c createPresenter() {
        return new c(this);
    }

    private void runOnSdkInvokedRunnable() {
        if (SettingsManager.getInstance().getOnSdkInvokedCallback() != null) {
            SettingsManager.getInstance().getOnSdkInvokedCallback().onSdkInvoked();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        String string = this.getIntent().getStringExtra(KEY_DIALOG_TITLE);
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra(KEY_DIALOG_ITEMS);
        if (arrayList == null) {
            this.finish();
            return;
        }
        this.setContent(string, arrayList);
        if (intent.getBooleanExtra(KEY_SHOULD_BE_KILLED, false)) {
            this.shouldBeKilled = true;
        }
    }

    @Override
    protected int getLayout() {
        return R.layout.ib_lyt_activity_dialog;
    }

    @Override
    protected void initViews() {
        if (this.presenter == null) {
            this.presenter = this.createPresenter();
        }
        if (this.getIntent().getSerializableExtra(KEY_DIALOG_ITEMS) == null) {
            this.finish();
            return;
        }
        this.findViewById(R.id.ib_fragment_container).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.ib_dialog_container).setOnClickListener((View.OnClickListener)this);
        if (this.getIntent().getBooleanExtra(KEY_SHOULD_BE_KILLED, false)) {
            this.shouldBeKilled = true;
        }
        this.getSupportFragmentManager().beginTransaction().replace(R.id.ib_fragment_container, (Fragment)e.a(this.getIntent().getStringExtra(KEY_DIALOG_TITLE), (ArrayList)this.getIntent().getSerializableExtra(KEY_DIALOG_ITEMS))).commit();
    }

    @Override
    public void onDialogItemClicked(InstabugDialogItem item, View ... sharedViews) {
        this.sharedViews = sharedViews;
        ((c)this.presenter).a(item, this.screenshotUri);
        if (this.shouldBeKilled) {
            this.finish();
        }
    }

    @Override
    public void removeScreenshotIfNeeded(InstabugDialogItem chatsListAction) {
        ((c)this.presenter).a(chatsListAction);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ib_fragment_container || v.getId() == R.id.ib_dialog_container) {
            ((c)this.presenter).f();
            this.finish();
        }
    }

    public void onBackPressed() {
        this.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        ((c)this.presenter).e();
        super.onBackPressed();
    }

    public void finish() {
        OnSdkDismissedCallback onSdkDismissedCallback;
        this.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        if (!((c)this.presenter).g() && (onSdkDismissedCallback = SettingsManager.getInstance().getOnSdkDismissedCallback()) != null) {
            onSdkDismissedCallback.onSdkDismissed(OnSdkDismissedCallback.DismissType.CANCEL, Bug.Type.NOT_AVAILABLE);
        }
        super.finish();
    }

    @Override
    public void onStart() {
        super.onStart();
        ((c)this.presenter).a();
    }

    @Override
    public void onStop() {
        super.onStop();
        ((c)this.presenter).b();
    }

    @Override
    protected void onDestroy() {
        if (this.isFinishing() && !((c)this.presenter).g()) {
            ((c)this.presenter).a(this.screenshotUri);
        }
        super.onDestroy();
    }

    @Override
    protected void onResume() {
        super.onResume();
        SettingsManager.getInstance().setPromptOptionsScreenShown(true);
    }

    @Override
    protected void onPause() {
        super.onPause();
        SettingsManager.getInstance().setPromptOptionsScreenShown(false);
    }

    public List<InstabugDialogItem> getDialogItems() {
        if (this.getIntent() != null) {
            return (ArrayList)this.getIntent().getSerializableExtra(KEY_DIALOG_ITEMS);
        }
        return null;
    }

    @Override
    public void onInitialScreenShotNotRequired() {
        ((c)this.presenter).a(this.screenshotUri);
    }

    @Override
    public void setContent(String title, ArrayList<InstabugDialogItem> items) {
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        try {
            if (this.sharedViews != null) {
                for (View view : this.sharedViews) {
                    fragmentTransaction.addSharedElement(view, ViewCompat.getTransitionName((View)view));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        fragmentTransaction.setCustomAnimations(0, R.anim.ib_core_anim_invocation_dialog_exit).addToBackStack(null).replace(R.id.ib_fragment_container, (Fragment)e.a(title, items)).commit();
    }

    @Override
    public int getSlidInLeftAnimation() {
        return R.anim.ib_core_anim_slide_in_left;
    }

    @Override
    public int getSlidInRightAnimation() {
        return R.anim.ib_core_anim_slide_in_right;
    }

    @Override
    public int getSlidOutLeftAnimation() {
        return R.anim.ib_core_anim_slide_out_left;
    }

    @Override
    public int getSlidOutRightAnimation() {
        return R.anim.ib_core_anim_slide_out_right;
    }

    @Override
    public int getFadeInAnimation() {
        return R.anim.ib_core_anim_fade_in;
    }

    @Override
    public int getEnterAnimation() {
        return ((c)this.presenter).c();
    }

    @Override
    public int getExitAnimation() {
        return ((c)this.presenter).d();
    }
}

