/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.Nullable;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.concurrent.atomic.AtomicInteger;

public class SQLiteDatabaseWrapper {
    private AtomicInteger mOpenCounter = new AtomicInteger();
    private SQLiteDatabase database;
    private SQLiteOpenHelper databaseHelper;

    SQLiteDatabaseWrapper(SQLiteOpenHelper helper) {
        this.databaseHelper = helper;
    }

    synchronized void open() {
        if (this.mOpenCounter.incrementAndGet() == 1) {
            this.database = this.databaseHelper.getWritableDatabase();
        }
    }

    public synchronized void close() {
        if (this.mOpenCounter.decrementAndGet() == 0 && this.database.isOpen()) {
            this.database.close();
        }
    }

    public void beginTransaction() {
        try {
            if (this.databaseInitializedAndOpen()) {
                this.database.beginTransaction();
            } else {
                this.logOperationFailedWarning();
            }
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB transaction failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
        }
    }

    private boolean databaseInitializedAndOpen() {
        return this.database != null && this.database.isOpen();
    }

    private void logOperationFailedWarning() {
        if (this.database == null) {
            InstabugSDKLogger.w(this, "Attempted to do operation on an uninitialized database. Falling back silently");
        } else if (!this.database.isOpen()) {
            InstabugSDKLogger.w(this, "Attempted to do operation on a closed database. Falling back silently");
        } else {
            InstabugSDKLogger.w(this, "Failed to do database operation. Falling back silently");
        }
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            if (this.databaseInitializedAndOpen()) {
                return this.database.insert(table, nullColumnHack, values);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB insertion failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    public long insertWithOnConflict(String tableName, String nullColumnHack, ContentValues values) {
        try {
            if (this.databaseInitializedAndOpen()) {
                return this.database.insertWithOnConflict(tableName, nullColumnHack, values, 4);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB insertion with on conflict failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    public long insertWithOnConflictReplace(String tableName, String nullColumnHack, ContentValues values) {
        try {
            if (this.databaseInitializedAndOpen()) {
                return this.database.insertWithOnConflict(tableName, nullColumnHack, values, 5);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB insertion with on conflict replace failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    public void execSQL(String sql) {
        try {
            if (this.databaseInitializedAndOpen()) {
                this.database.execSQL(sql);
            } else {
                this.logOperationFailedWarning();
            }
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB execution a sql failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
        }
    }

    public void setTransactionSuccessful() {
        try {
            if (this.databaseInitializedAndOpen()) {
                this.database.setTransactionSuccessful();
            } else {
                this.logOperationFailedWarning();
            }
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB transaction not successful due to: " + sQLException.getMessage());
            this.logOperationFailedWarning();
        }
    }

    public synchronized void endTransaction() {
        try {
            if (this.databaseInitializedAndOpen()) {
                this.database.endTransaction();
            } else {
                this.logOperationFailedWarning();
            }
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB end transaction not successful due to: " + sQLException.getMessage());
            this.logOperationFailedWarning();
        }
    }

    @Nullable
    public Cursor rawQuery(String sql, String[] selectionArgs) {
        try {
            if (this.databaseInitializedAndOpen()) {
                return this.database.rawQuery(sql, selectionArgs);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB raw query failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    public void delete(String table, String whereClause, String[] whereArgs) {
        try {
            if (this.databaseInitializedAndOpen()) {
                this.database.delete(table, whereClause, whereArgs);
            } else {
                this.logOperationFailedWarning();
            }
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB deletion failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
        }
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        try {
            if (this.databaseInitializedAndOpen()) {
                return this.database.update(table, values, whereClause, whereArgs);
            }
            this.logOperationFailedWarning();
            return -1;
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB update failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1;
        }
    }

    @Nullable
    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        try {
            if (this.databaseInitializedAndOpen()) {
                return this.database.query(table, columns, selection, selectionArgs, groupBy, having, orderBy);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB query failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    @Nullable
    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        try {
            if (this.databaseInitializedAndOpen()) {
                return this.database.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB query failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    public long queryNumEntries(String tableName) {
        try {
            if (this.databaseInitializedAndOpen()) {
                return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)tableName);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (SQLException sQLException) {
            InstabugLog.e("DB query num entries failed: " + sQLException.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }
}

