/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.c;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d.a;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.internal.video.InternalScreenRecordHelper;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.Report;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.visualusersteps.State;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class Instabug {
    private static Instabug INSTANCE = null;
    private static InstabugState INSTABUG_STATE = InstabugState.NOT_BUILT;
    private com.instabug.library.b delegate;

    private Instabug(@NonNull com.instabug.library.b delegate) {
        this.delegate = delegate;
    }

    static Instabug getInstance() throws IllegalStateException {
        if (INSTANCE == null) {
            throw new IllegalStateException("Instabug getInstance called before Instabug.Builder().build() was called");
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getApplicationContext() {
        return Instabug.getInstance().delegate.l();
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("isDebugEnabled").setType(Boolean.TYPE).setValue(isDebugEnabled));
        SettingsManager.getInstance().setDebugEnabled(isDebugEnabled);
    }

    public static int getPrimaryColor() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static void setPrimaryColor(@ColorInt int primaryColorValue) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("primaryColorValue").setType(Integer.TYPE).setValue(String.valueOf(primaryColorValue)));
        SettingsManager.getInstance().setPrimaryColor(primaryColorValue);
    }

    public static InstabugColorTheme getTheme() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getTheme();
    }

    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("fileUri").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(fileUri, fileNameWithExtension);
    }

    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter().setName("data").setType(Uri.class), new Api.Parameter().setName("fileNameWithExtension").setType(String.class));
        SettingsManager.getInstance().addExtraAttachmentFile(data, fileNameWithExtension);
    }

    public static void clearFileAttachment() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchLoggingApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().clearExtraAttachmentFiles();
    }

    public static String getUserData() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getUserData();
    }

    public static void setUserData(@NonNull String userData) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("userData").setType(String.class));
        if (c.a().c(Feature.USER_DATA) == Feature.State.ENABLED) {
            userData = StringUtility.trimString(userData, 1000);
            SettingsManager.getInstance().setUserData(userData);
        }
    }

    public static String getUserEmail() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return b.c();
    }

    public static String getAppToken() throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getAppToken();
    }

    public static void identifyUser(@NonNull String username, @NonNull String email) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("username").setType(String.class), new Api.Parameter().setName("email"));
        b.a(Instabug.getApplicationContext(), username, email);
    }

    public static void logoutUser() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        b.b();
    }

    public static void setState(InstabugState instabugState) {
        INSTABUG_STATE = instabugState;
    }

    public static InstabugState getState() {
        return INSTABUG_STATE;
    }

    public static boolean isBuilt() {
        return INSTANCE != null && Instabug.getState() != InstabugState.NOT_BUILT;
    }

    public static boolean isEnabled() {
        if (!Instabug.isBuilt()) {
            return false;
        }
        return c.a().a(Feature.INSTABUG) && c.a().c(Feature.INSTABUG) == Feature.State.ENABLED;
    }

    public static void enable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (!Instabug.isEnabled()) {
            c.a().a(Feature.INSTABUG, true);
            c.a().a(Feature.INSTABUG, Feature.State.ENABLED);
            c.a().a(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.a();
        }
    }

    public static void disable() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.isEnabled()) {
            c.a().a(Feature.INSTABUG, Feature.State.DISABLED);
            c.a().a(Feature.INSTABUG, false);
            c.a().a(Instabug.getApplicationContext());
            Instabug.getInstance().delegate.h();
        }
    }

    public static void pauseSdk() throws IllegalStateException {
        APIBuildChecker.check();
        if (Instabug.isEnabled()) {
            Instabug.getInstance().delegate.i();
        }
    }

    public static void resumeSdk() throws IllegalStateException {
        APIBuildChecker.check();
        Instabug.getInstance().delegate.j();
    }

    public static void setLocale(Locale locale) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale));
        Instabug.getInstance().delegate.a(locale);
    }

    public static Locale getLocale(Context context) throws IllegalStateException {
        APIBuildChecker.check();
        return SettingsManager.getInstance().getInstabugLocale(context);
    }

    public static void addTags(String ... tags) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        tags = StringUtility.trimStrings(tags);
        SettingsManager.getInstance().addTags(tags);
    }

    public static ArrayList<String> getTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return SettingsManager.getInstance().getTags();
    }

    public static void resetTags() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().resetTags();
    }

    public static void setCustomTextPlaceHolders(InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugCustomTextPlaceHolder").setType(InstabugCustomTextPlaceHolder.class));
        SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder);
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        return com.instabug.library.util.a.c.a(UserAttributeCacheManager.retrieveAll()).a(com.instabug.library.util.a.a.b()).a();
    }

    public static void setUserAttribute(@NonNull String key, String value) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class), new Api.Parameter().setName("value").setType(String.class));
        com.instabug.library.util.a.c.a(new Pair((Object)key, (Object)value)).a(com.instabug.library.util.a.a.c()).a(com.instabug.library.util.a.a.e());
    }

    @Nullable
    public static String getUserAttribute(@NonNull String key) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        return com.instabug.library.util.a.c.a(key).a(com.instabug.library.util.a.a.a()).a(com.instabug.library.util.a.a.g());
    }

    public static void removeUserAttribute(@NonNull String key) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("key").setType(String.class));
        com.instabug.library.util.a.c.a(key).a(com.instabug.library.util.a.a.a()).a(com.instabug.library.util.a.a.d());
    }

    public static void clearAllUserAttributes() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        com.instabug.library.util.a.c.a(UserAttributeCacheManager.retrieveAll()).a(com.instabug.library.util.a.a.b()).a(com.instabug.library.util.a.a.f());
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setWelcomeMessageState(WelcomeMessage.State welcomeMessageState) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("WelcomeMessageState").setType(String.class).setValue(welcomeMessageState.toString()));
        SettingsManager.getInstance().setWelcomeMessageState(welcomeMessageState);
    }

    public static void showWelcomeMessage(WelcomeMessage.State welcomeMessageState) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("showWelcomeMessage").setType(String.class).setValue(welcomeMessageState.toString()));
        if (!InstabugCore.isForegroundBusy()) {
            Instabug.getInstance().delegate.a(welcomeMessageState);
        }
    }

    @Deprecated
    public static void setViewHierarchyState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        c.a().a(Feature.VIEW_HIERARCHY_V2, state);
    }

    @Deprecated
    public static void setAutoScreenRecordingMaxDuration(int autoScreenRecordingMaxDuration) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter().setName("setAutoScreenRecordingMaxDuration").setType(Boolean.class).setValue(String.valueOf(autoScreenRecordingMaxDuration)));
        SettingsManager.getInstance().setAutoScreenRecordingMaxDuration(autoScreenRecordingMaxDuration);
        Log.e((String)Instabug.class.getName(), (String)"AutoScreen recording is disabled please contact support for further details.");
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        c.a().a(Feature.SESSION_PROFILER, state);
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
        c.a().a(Feature.TRACK_USER_STEPS, state);
    }

    public static void setReproStepsState(State reproStepsState) {
        if (reproStepsState == State.ENABLED) {
            c.a().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(true);
        } else if (reproStepsState == State.ENABLED_WITH_NO_SCREENSHOTS) {
            c.a().a(Feature.REPRO_STEPS, Feature.State.ENABLED);
            SettingsManager.getInstance().setReproStepsScreenshotEnabled(false);
        } else if (reproStepsState == State.DISABLED) {
            c.a().a(Feature.REPRO_STEPS, Feature.State.DISABLED);
        }
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugTheme));
        SettingsManager.getInstance().setTheme(instabugTheme);
        switch (instabugTheme) {
            case InstabugColorThemeDark: {
                SettingsManager.getInstance().setPrimaryColor(-9580554);
                SettingsManager.getInstance().setStatusBarColor(-16119286);
                break;
            }
            case InstabugColorThemeLight: {
                SettingsManager.getInstance().setPrimaryColor(-15893761);
                SettingsManager.getInstance().setStatusBarColor(-3815737);
            }
        }
    }

    public static void logUserEvent(@NonNull String eventIdentifier) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("eventIdentifier").setType(String.class));
        InstabugUserEventLogger.getInstance().logUserEvent(eventIdentifier, new UserEventParam[0]);
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("listener").setType(Report.OnReportCreatedListener.class));
        SettingsManager.getInstance().setOnReportCreatedListener(listener);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingDuration(@IntRange(from=30L, to=180L) int maxDuration) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("maxDuration").setType(Integer.class).setValue(maxDuration));
        SettingsManager.getInstance().setAutoScreenRecordingDuration(maxDuration);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("asrAudioCapturingEnabled").setType(Feature.State.class).setValue(isASRAudioEnabled.name()));
        SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(isASRAudioEnabled);
    }

    public static void show() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().show();
    }

    public static void setViewsAsPrivate(View ... views) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            Instabug.getInstance().delegate.a(views);
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class Builder {
        private String applicationToken;
        private Context applicationContext;
        private Application application;
        private InstabugColorTheme instabugTheme = InstabugColorTheme.InstabugColorThemeLight;
        private int instabugPrimaryColor = -15893761;
        private int instabugStatusBarColor = -3815737;
        private InstabugInvocationEvent[] instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
        private Feature.State userDataState = c.a;
        private Feature.State consoleLogState = c.a;
        private Feature.State instabugLogState = c.a;
        private Feature.State inAppMessagingState = c.a;
        private Feature.State crashReportingState = c.a;
        private Feature.State pushNotificationState = c.a;
        private Feature.State trackingUserStepsState = c.a;
        private State reproStepsState = State.ENABLED;
        private Feature.State viewHierarchyState = Feature.State.DISABLED;
        private Feature.State surveysState = c.a;
        private Feature.State userEventsState = c.a;
        private boolean emailFieldRequired = true;
        private boolean emailFieldVisibility = true;
        private boolean commentFieldRequired = false;
        private boolean introMessageEnabled = true;
        private boolean shouldPlaySounds = false;
        private boolean successDialogEnabled = true;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
        private int shakingThreshold = 650;
        private int floatingButtonOffsetFromTop = -1;
        private Locale instabugLocale = Locale.getDefault();
        private boolean isSurveysAutoShowing = true;
        private boolean chatPromptOptionEnable = true;
        private boolean bugPromptOptionEnable = true;
        private boolean feedbackPromptOptionEnable = true;
        private List<Integer> deprecatedMethodsToBeLogedAfterBuild = new ArrayList<Integer>();

        public Builder(Application application, String applicationToken) {
            this(application, applicationToken, InstabugInvocationEvent.SHAKE);
        }

        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            this(application.getApplicationContext(), applicationToken, instabugInvocationEvent);
            this.application = application;
        }

        Builder(@NonNull Context applicationContext, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvents) {
            this.applicationContext = applicationContext;
            this.instabugInvocationEvents = instabugInvocationEvents;
            this.applicationToken = applicationToken;
        }

        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue(TextUtils.join((CharSequence)",", (Object[])instabugInvocationEvents)));
            this.instabugInvocationEvents = instabugInvocationEvents;
            return this;
        }

        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.trackingUserStepsState = state;
            return this;
        }

        public Builder setReproStepsState(State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(State.class).setValue((Object)state));
            this.reproStepsState = state;
            return this;
        }

        public Builder setConsoleLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.consoleLogState = state;
            return this;
        }

        public Builder setInstabugLogState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.instabugLogState = state;
            return this;
        }

        public Builder setUserDataState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userDataState = state;
            return this;
        }

        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.inAppMessagingState = state;
            return this;
        }

        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.viewHierarchyState = state;
            return this;
        }

        public Builder setUserEventsState(@NonNull Feature.State state) {
            AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state));
            this.userEventsState = state;
            return this;
        }

        public Instabug build(Feature.State instabugInitialState) {
            SettingsManager.init(this.applicationContext);
            boolean bl = instabugInitialState == Feature.State.ENABLED;
            this.setFeaturesStates(bl);
            com.instabug.library.b b2 = new com.instabug.library.b(this.applicationContext);
            INSTANCE = new Instabug(b2);
            Instabug.setState(InstabugState.BUILT);
            this.logDeprecatedApis();
            b2.a(this.applicationContext);
            InstabugInternalTrackingDelegate.init(this.application);
            String string2 = SettingsManager.getInstance().getAppToken();
            if (this.applicationToken != null && string2 != null && !this.applicationToken.equals(string2)) {
                b.b();
            }
            SettingsManager.getInstance().setAppToken(this.applicationToken);
            b2.a();
            SettingsManager.getInstance().setInstabugLocale(this.instabugLocale);
            SettingsManager.getInstance().setTheme(this.instabugTheme);
            SettingsManager.getInstance().setPrimaryColor(this.instabugPrimaryColor);
            SettingsManager.getInstance().setStatusBarColor(this.instabugStatusBarColor);
            InvocationManager.getInstance().setInstabugInvocationEvent(this.instabugInvocationEvents);
            InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(this.shakingThreshold);
            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(this.instabugFloatingButtonEdge);
            if (this.floatingButtonOffsetFromTop != -1) {
                InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(this.floatingButtonOffsetFromTop);
            }
            a.a(this.isSurveysAutoShowing);
            return INSTANCE;
        }

        private void logDeprecatedApis() {
            for (Integer n : this.deprecatedMethodsToBeLogedAfterBuild) {
                InstabugDeprecationLogger.getInstance().log(n);
            }
        }

        public Instabug build() {
            if (Instabug.isBuilt()) {
                if (InternalScreenRecordHelper.getInstance().isRecording()) {
                    InternalScreenRecordHelper.getInstance().cancel();
                }
                Instabug.disable();
            }
            return this.build(Feature.State.ENABLED);
        }

        private void setFeaturesStates(Boolean isInstabugEnabled) {
            InstabugSDKLogger.v(this, "Setting user data feature state " + (Object)((Object)this.userDataState));
            c.a().a(Feature.USER_DATA, this.userDataState);
            InstabugSDKLogger.v(this, "Setting console log feature state " + (Object)((Object)this.consoleLogState));
            c.a().a(Feature.CONSOLE_LOGS, this.consoleLogState);
            InstabugSDKLogger.v(this, "Setting Instabug logs feature state " + (Object)((Object)this.instabugLogState));
            c.a().a(Feature.INSTABUG_LOGS, this.instabugLogState);
            InstabugSDKLogger.v(this, "Setting crash reporting feature state " + (Object)((Object)this.crashReportingState));
            c.a().a(Feature.CRASH_REPORTING, this.crashReportingState);
            InstabugSDKLogger.v(this, "Setting in-app messaging feature state " + (Object)((Object)this.inAppMessagingState));
            c.a().a(Feature.IN_APP_MESSAGING, this.inAppMessagingState);
            InstabugSDKLogger.v(this, "Setting push notification feature state " + (Object)((Object)this.pushNotificationState));
            c.a().a(Feature.PUSH_NOTIFICATION, this.pushNotificationState);
            InstabugSDKLogger.v(this, "Setting tracking user steps feature state " + (Object)((Object)this.trackingUserStepsState));
            c.a().a(Feature.TRACK_USER_STEPS, this.trackingUserStepsState);
            InstabugSDKLogger.v(this, "Setting repro steps feature state " + (Object)((Object)this.reproStepsState));
            Instabug.setReproStepsState(this.reproStepsState);
            InstabugSDKLogger.v(this, "Setting view hierarchy  feature state " + (Object)((Object)this.viewHierarchyState));
            c.a().a(Feature.VIEW_HIERARCHY_V2, this.viewHierarchyState);
            InstabugSDKLogger.v(this, "Setting surveys feature state " + (Object)((Object)this.surveysState));
            c.a().a(Feature.SURVEYS, this.surveysState);
            InstabugSDKLogger.v(this, "Setting user events feature state " + (Object)((Object)this.userEventsState));
            c.a().a(Feature.USER_EVENTS, this.userEventsState);
            InstabugSDKLogger.v(this, "Setting instabug overall state " + isInstabugEnabled);
            c.a().a(Feature.INSTABUG, isInstabugEnabled);
        }
    }
}

