/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import com.instabug.library.util.InstabugSDKLogger;

public class PermissionsUtils {
    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String permission2) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                int n = ContextCompat.checkSelfPermission((Context)context, (String)permission2);
                boolean bl = n == 0;
                InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + permission2 + " state is " + (bl ? "" : "NOT ") + "granted");
                return bl;
            }
            int n = context.checkCallingOrSelfPermission(permission2);
            boolean bl = n == 0;
            InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + permission2 + " state is " + (bl ? "" : "NOT ") + "granted");
            return bl;
        }
        catch (Error | Exception throwable) {
            return true;
        }
    }

    public static void requestPermission(@NonNull Activity activity, @NonNull String permission2, int requestCode, @Nullable Runnable onShouldNotShowPermissionRationale, @Nullable Runnable afterPermissionGrantedRunnable) {
        if (!PermissionsUtils.isPermissionGranted((Context)activity, permission2)) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                PermissionsUtils.runIfValid(onShouldNotShowPermissionRationale);
            }
            InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + permission2 + " not granted, requesting it");
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{permission2}, (int)requestCode);
        } else {
            InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + permission2 + " already granted, running after permission granted runnable");
            PermissionsUtils.runIfValid(afterPermissionGrantedRunnable);
        }
    }

    public static void requestPermission(Fragment fragment, String permission2, int requestCode, @Nullable Runnable onShouldNotShowPermissionRationale, Runnable afterPermissionGrantedRunnable) {
        if (!PermissionsUtils.isPermissionGranted(fragment.getContext(), permission2)) {
            if (!fragment.shouldShowRequestPermissionRationale(permission2)) {
                PermissionsUtils.runIfValid(onShouldNotShowPermissionRationale);
            }
            InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + permission2 + " not granted, requesting it");
            fragment.requestPermissions(new String[]{permission2}, requestCode);
        } else {
            InstabugSDKLogger.d(PermissionsUtils.class, "Permission " + permission2 + " already granted, running after permission granted runnable");
            PermissionsUtils.runIfValid(afterPermissionGrantedRunnable);
        }
    }

    private static void runIfValid(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }
}

