/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.executor.DeleteOperationExecutor;
import com.instabug.library.internal.storage.executor.ReadOperationExecutor;
import com.instabug.library.internal.storage.executor.WriteOperationExecutor;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public final class DiskUtils {
    private final Context context;

    private DiskUtils(Context context) {
        this.context = context;
    }

    public static File getInstabugDirectory(Context context) {
        String string2;
        if (context.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                string2 = context.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                string2 = DiskUtils.getInternalStoragePath(context);
                InstabugSDKLogger.i(AttachmentsUtility.class, "External storage not available, saving file to internal storage.");
            }
        } else {
            string2 = DiskUtils.getInternalStoragePath(context);
            InstabugSDKLogger.i(AttachmentsUtility.class, "External storage not available, saving file to internal storage.");
        }
        File file = new File(string2 + "/instabug/");
        if (!file.exists() && file.mkdirs()) {
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    private static String getInternalStoragePath(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    public static void saveBitmapOnDisk(Bitmap bitmap, File file) throws IOException {
        if (bitmap != null && file != null) {
            InstabugSDKLogger.v(DiskUtils.class, "starting save viewHierarchy image, path: " + file.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            InstabugSDKLogger.v(DiskUtils.class, "viewHierarchy image saved, path: " + file.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
        }
    }

    public static void cleanDirectory(File directory) {
        File[] fileArray;
        if (directory.exists() && directory.isDirectory() && (fileArray = directory.listFiles()) != null) {
            for (File file : fileArray) {
                if (!file.delete()) continue;
                InstabugSDKLogger.v(DiskUtils.class, "file deleted successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis());
            }
        }
    }

    public static void copyFromUriIntoFile(Context context, Uri source, File target) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(context.getContentResolver().openInputStream(source));
        InstabugSDKLogger.d(AttachmentsUtility.class, "Target file path: " + target.getPath());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(context.getContentResolver().openOutputStream(Uri.fromFile((File)target)));
        byte[] byArray = new byte[32768];
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    public static void deleteFile(final String fileLocalPath) {
        PoolProvider.postIOTask(new Runnable(){

            @Override
            public void run() {
                File file = new File(fileLocalPath);
                file.delete();
            }
        });
    }

    public static DiskUtils with(Context context) {
        return new DiskUtils(context);
    }

    public static boolean isFileExist(String path) {
        return new File(path).exists();
    }

    public ReadOperationExecutor readOperation(@NonNull DiskOperation<String, Void> operation) {
        return new ReadOperationExecutor(operation);
    }

    public WriteOperationExecutor writeOperation(@NonNull DiskOperation<Uri, Context> operation) {
        return new WriteOperationExecutor(this.context, operation);
    }

    public DeleteOperationExecutor deleteOperation(@NonNull DiskOperation<Boolean, Void> operation) {
        return new DeleteOperationExecutor(operation);
    }

    public static File createStateTextFile(Context context) {
        return new File(context.getFilesDir().getAbsolutePath() + File.pathSeparator + "crash_state" + File.pathSeparator + System.currentTimeMillis() + ".txt");
    }
}

