/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics.model;

import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Api {
    private static final String KEY_TIME_STAMP = "time_stamp";
    private static final String KEY_METHOD = "method";
    private static final String KEY_IS_DEPRECATED = "is_deprecated";
    private static final String KEY_PARAMETERS = "parameters";
    private static final String KEY_COUNT = "count";
    private long timeStamp;
    private String apiName;
    private boolean isDeprecated;
    private int count = 1;
    private ArrayList<Parameter> parameters;

    public Api() {
        this.setTimeStamp(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Api setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public String getApiName() {
        return this.apiName;
    }

    public Api setApiName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Api setDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public Api setParameters(ArrayList<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_TIME_STAMP, this.getTimeStamp()).put(KEY_METHOD, (Object)this.getApiName()).put(KEY_IS_DEPRECATED, this.isDeprecated()).put(KEY_COUNT, this.getCount()).put(KEY_PARAMETERS, (Object)Parameter.toJson(this.getParameters()));
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(Api.class, jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public static JSONArray toJson(ArrayList<Api> apis) {
        JSONArray jSONArray = new JSONArray();
        for (Api api : apis) {
            jSONArray.put((Object)api.toJson());
        }
        return jSONArray;
    }

    public static class Parameter {
        private static final String KEY_NAME = "name";
        private static final String KEY_TYPE = "type";
        private static final String KEY_VALUE = "value";
        private String name;
        private String type;
        private String value;

        public String getName() {
            return this.name;
        }

        public Parameter setName(String name) {
            this.name = name;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Parameter setType(Class<?> cls) {
            this.type = cls.getSimpleName();
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public Parameter setValue(Object value) {
            this.value = value == null ? "null" : value.toString();
            return this;
        }

        public JSONObject toJson() {
            JSONObject jSONObject = new JSONObject();
            try {
                if (this.getName() != null) {
                    jSONObject.put(KEY_NAME, (Object)this.getName());
                }
                if (this.getType() != null) {
                    jSONObject.put(KEY_TYPE, (Object)this.getType());
                }
                if (this.getValue() != null) {
                    jSONObject.put(KEY_VALUE, (Object)this.getValue());
                }
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
            }
            return jSONObject;
        }

        public static Parameter fromJson(JSONObject parameterJsonObject) {
            Parameter parameter = new Parameter();
            try {
                if (parameterJsonObject.has(KEY_NAME)) {
                    parameter.name = parameterJsonObject.getString(KEY_NAME);
                }
                if (parameterJsonObject.has(KEY_TYPE)) {
                    parameter.type = parameterJsonObject.getString(KEY_TYPE);
                }
                if (parameterJsonObject.has(KEY_VALUE)) {
                    parameter.value = parameterJsonObject.getString(KEY_VALUE);
                }
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
            }
            return parameter;
        }

        public static JSONArray toJson(ArrayList<Parameter> parameters) {
            JSONArray jSONArray = new JSONArray();
            for (Parameter parameter : parameters) {
                jSONArray.put((Object)parameter.toJson());
            }
            return jSONArray;
        }

        public static ArrayList<Parameter> fromJson(JSONArray parametersJsonArray) {
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            for (int k = 0; k < parametersJsonArray.length(); ++k) {
                try {
                    arrayList.add(Parameter.fromJson(parametersJsonArray.getJSONObject(k)));
                    continue;
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
                }
            }
            return arrayList;
        }
    }
}

