/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics;

import android.content.Context;
import android.content.SharedPreferences;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.analytics.util.a;
import com.instabug.library.analytics.util.b;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.model.b;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.threading.PoolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE", "DLS_DEAD_LOCAL_STORE"})
public class AnalyticsObserver {
    private static final String LAST_UPLOADED_AT = "analytics_last_uploaded";
    private static AnalyticsObserver INSTANCE;
    private static String HAVE_BEEN_CLEANED;
    private LinkedHashMap<String, Api> loggingApisLinkedHashMap = new LinkedHashMap();
    private List<Api> sdkApisArrayList = Collections.synchronizedList(new ArrayList());

    public static AnalyticsObserver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnalyticsObserver();
        }
        return INSTANCE;
    }

    private AnalyticsObserver() {
        Consumer<b.a> consumer = new Consumer<b.a>(){

            public void a(final b.a a2) {
                PoolProvider.postIOTask(new Runnable(){

                    @Override
                    public void run() {
                        AnalyticsObserver.this.handleAPIsUsageWithSessionStateChanged(a2);
                        b.a();
                    }
                });
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((b.a)((Object)object));
            }
        };
        SessionStateEventBus.getInstance().subscribe(consumer);
    }

    public void catchApiUsage(Api.Parameter ... parameters) {
        String string = this.getCallerMethodName();
        this.catchApiUsage(string, false, parameters);
    }

    public void catchDeprecatedApiUsage(Api.Parameter ... parameters) {
        String string = this.getCallerMethodName();
        this.catchApiUsage(string, true, parameters);
    }

    public void catchLoggingApiUsage(Api.Parameter ... parameters) {
        String string = this.getCallerMethodName();
        this.catchLoggingApiUsage(string, false, parameters);
    }

    public void catchDeprecatedLoggingApiUsage(Api.Parameter ... parameters) {
        String string = this.getCallerMethodName();
        this.catchLoggingApiUsage(string, true, parameters);
    }

    private void catchApiUsage(String apiName, boolean isDeprecated, Api.Parameter ... parameters) {
        this.sdkApisArrayList.add(this.createApiUsageInfo(apiName, isDeprecated, parameters));
    }

    private void catchLoggingApiUsage(String apiName, boolean isDeprecated, Api.Parameter ... parameters) {
        if (this.loggingApisLinkedHashMap.containsKey(apiName)) {
            Api api = this.loggingApisLinkedHashMap.get(apiName);
            api.incrementCount();
            this.loggingApisLinkedHashMap.put(apiName, api);
        } else {
            this.loggingApisLinkedHashMap.put(apiName, this.createApiUsageInfo(apiName, isDeprecated, parameters));
        }
    }

    private Api createApiUsageInfo(String apiName, boolean isDeprecated, Api.Parameter ... parameters) {
        Api api = new Api();
        api.setApiName(apiName);
        api.setDeprecated(isDeprecated);
        ArrayList<Api.Parameter> arrayList = parameters != null ? new ArrayList<Api.Parameter>(Arrays.asList(parameters)) : new ArrayList();
        api.setParameters(arrayList);
        return api;
    }

    private String getCallerMethodName() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        return stackTraceElementArray[4].getMethodName();
    }

    private void handleAPIsUsageWithSessionStateChanged(b.a sessionState) {
        long l = SettingsManager.getInstance().getSessionStartedAt();
        if (sessionState == b.a.FINISH) {
            ArrayList<Api> arrayList = new ArrayList<Api>();
            arrayList.addAll(this.sdkApisArrayList);
            a.a(arrayList, l);
            a.a(this.loggingApisLinkedHashMap.values(), l);
            this.sdkApisArrayList.clear();
            this.loggingApisLinkedHashMap.clear();
        }
    }

    public static long getLastUploadedAt(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("instabug", 0);
        return sharedPreferences.getLong(LAST_UPLOADED_AT, 0L);
    }

    public static void setLastUploadedAt(long analyticsUploadedAt, Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("instabug", 0);
        sharedPreferences.edit().putLong(LAST_UPLOADED_AT, analyticsUploadedAt).apply();
    }

    public static boolean haveBeenCleanedBefore(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("instabug", 0);
        return sharedPreferences.getBoolean(HAVE_BEEN_CLEANED, false);
    }

    public static void setBeingCleaned(boolean isCleaned, Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("instabug", 0);
        sharedPreferences.edit().putBoolean(HAVE_BEEN_CLEANED, isCleaned).apply();
    }

    static {
        HAVE_BEEN_CLEANED = "have_been_cleaned";
    }
}

