/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.MotionEvent;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.a.a;
import com.instabug.library.invocation.a.b;
import com.instabug.library.invocation.a.d;
import com.instabug.library.invocation.a.e;
import com.instabug.library.invocation.a.f;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class InvocationManager {
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings = new InvocationSettings();
    private InstabugInvocationEvent[] currentInstabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
    private List<a> currentInvokers = new ArrayList<a>();
    private a lastUsedInvoker;
    private Disposable currentActivityLifeCycleDisposable;
    private Disposable featurePlanUpdateDisposable;
    private boolean isInvocationAvailable = true;
    private com.instabug.library.invocation.b invocationRequestListenerImp;

    private InvocationManager() {
        this.subscribeToCarenActivityLifeCycle();
        this.invocationRequestListenerImp = new com.instabug.library.invocation.b();
    }

    public static void init() {
        InstabugSDKLogger.v(InvocationManager.class, "initializing invocationManager");
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else {
            INSTANCE.listen();
        }
    }

    public static InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    public void release() {
        if (this.currentActivityLifeCycleDisposable != null && !this.currentActivityLifeCycleDisposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        if (this.featurePlanUpdateDisposable != null && !this.featurePlanUpdateDisposable.isDisposed()) {
            this.featurePlanUpdateDisposable.dispose();
            this.featurePlanUpdateDisposable = null;
        }
        this.invocationRequestListenerImp = null;
    }

    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        this.currentInstabugInvocationEvents = this.removeDuplicates(instabugInvocationEvent);
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                a2.b();
            }
            this.currentInvokers.clear();
        }
        block7: for (InstabugInvocationEvent instabugInvocationEvent2 : instabugInvocationEvent) {
            if (instabugInvocationEvent2 == InstabugInvocationEvent.NONE && instabugInvocationEvent.length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                this.currentInvokers = new ArrayList<a>();
            }
            switch (instabugInvocationEvent2) {
                case SHAKE: {
                    e e2 = new e(Instabug.getApplicationContext(), this.invocationRequestListenerImp);
                    e2.a(this.currentInvocationSettings.getShakeThreshold());
                    this.currentInvokers.add(e2);
                    continue block7;
                }
                case FLOATING_BUTTON: {
                    this.currentInvokers.add(new b(this.invocationRequestListenerImp));
                    continue block7;
                }
                case TWO_FINGER_SWIPE_LEFT: {
                    this.currentInvokers.add(new f(Instabug.getApplicationContext(), this.invocationRequestListenerImp));
                    continue block7;
                }
                case SCREENSHOT: {
                    this.currentInvokers.add(new d(this.invocationRequestListenerImp));
                    continue block7;
                }
            }
        }
        if (this.currentInvokers != null) {
            this.setLastUsedInvoker(null);
            for (a a3 : this.currentInvokers) {
                a3.a();
            }
        }
    }

    @VisibleForTesting
    InstabugInvocationEvent[] removeDuplicates(InstabugInvocationEvent[] events) {
        ArrayList<InstabugInvocationEvent> arrayList = new ArrayList<InstabugInvocationEvent>();
        HashSet<InstabugInvocationEvent> hashSet = new HashSet<InstabugInvocationEvent>();
        for (InstabugInvocationEvent instabugInvocationEvent : events) {
            if (hashSet.contains((Object)instabugInvocationEvent)) continue;
            arrayList.add(instabugInvocationEvent);
            hashSet.add(instabugInvocationEvent);
        }
        InstabugInvocationEvent[] instabugInvocationEventArray = new InstabugInvocationEvent[arrayList.size()];
        return arrayList.toArray(instabugInvocationEventArray);
    }

    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        return Arrays.copyOf(this.currentInstabugInvocationEvents, this.currentInstabugInvocationEvents.length);
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    List<a> getCurrentInvokers() {
        return this.currentInvokers;
    }

    public a getLastUsedInvoker() {
        return this.lastUsedInvoker;
    }

    public void setLastUsedInvoker(a lastUsedInvoker) {
        this.lastUsedInvoker = lastUsedInvoker;
    }

    private void listen() {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && this.isInvocationAvailable && this.isPromptOptionsAvailable() && this.currentInvokers != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (a a2 : this.currentInvokers) {
                a2.a();
            }
        }
    }

    public void handle(MotionEvent motionEvent) {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (a a2 : this.currentInvokers) {
                if (!(a2 instanceof f)) continue;
                ((f)a2).a(motionEvent);
                break;
            }
        }
    }

    public void sleep() {
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                a2.b();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable = false;
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable = true;
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return com.instabug.library.core.plugin.a.e();
    }

    private void subscribeToCarenActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                switch (activityLifeCycleEvent) {
                    case RESUMED: {
                        InstabugSDKLogger.v(this, "current activity resumed");
                        InvocationManager.this.listen();
                        break;
                    }
                    case PAUSED: {
                        InstabugSDKLogger.v(this, "current activity paused");
                        InvocationManager.this.sleep();
                        break;
                    }
                }
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((ActivityLifeCycleEvent)((Object)object));
            }
        });
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    public void notifyPrimaryColorChanged() {
        if (Instabug.isEnabled() && this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                if (!(a2 instanceof b)) continue;
                a2.b();
                a2.a();
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        boolean bl = !this.isPromptOptionsAvailable();
        b b2 = this.getFloatingButtonInvoker();
        if (b2 != null) {
            if (bl) {
                b2.b();
            } else {
                b2.c();
            }
        }
    }

    @Nullable
    private b getFloatingButtonInvoker() {
        b b2 = null;
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                if (!(a2 instanceof b)) continue;
                b2 = (b)a2;
                break;
            }
        }
        return b2;
    }

    public void show() {
        this.invocationRequestListenerImp.a();
        this.lastUsedInvoker = null;
    }

    public void invoke(int invocationMode) {
        this.invocationRequestListenerImp.a(invocationMode);
    }

    @VisibleForTesting
    public static void tearDown() {
        INSTANCE = null;
    }

    public void forceInvoke(int invocationMode) {
        this.invocationRequestListenerImp.b(invocationMode);
    }
}

