/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.Toast;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.memory.MemoryUtils;

public class InitialScreenshotHelper {
    private static Uri screenshotUri;

    public static void captureScreenshot(final @NonNull InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        final Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity == null) {
            return;
        }
        if (MemoryUtils.isLowMemory((Context)activity)) {
            InstabugSDKLogger.e(InitialScreenshotHelper.class, "Couldn't take initial screenshot due to low memory");
            initialScreenshotCapturingListenr.onScreenshotCapturingFailed(new Throwable("Your activity is currently in low memory"));
            String string2 = LocaleUtils.getLocaleStringResource(Instabug.getLocale((Context)activity), R.string.instabug_str_capturing_screenshot_error, (Context)activity);
            Toast.makeText((Context)activity, (CharSequence)string2, (int)0).show();
            return;
        }
        if (InitialScreenshotHelper.isUsingMediaProjection()) {
            ScreenshotProvider.a(true, activity, new ScreenshotProvider.ScreenshotCapturingListener(){

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    InitialScreenshotHelper.saveBitmap(bitmap, activity, initialScreenshotCapturingListenr);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    InstabugSDKLogger.e(this, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                    initialScreenshotCapturingListenr.onScreenshotCapturingFailed(throwable);
                }
            });
        } else {
            ScreenshotProvider.a(activity, new ScreenshotProvider.ScreenshotCapturingListener(){

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    InitialScreenshotHelper.saveBitmap(bitmap, activity, initialScreenshotCapturingListenr);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    InstabugSDKLogger.e(this, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                    initialScreenshotCapturingListenr.onScreenshotCapturingFailed(throwable);
                }
            });
        }
    }

    private static void saveBitmap(Bitmap bitmap, Activity activity, final InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        BitmapUtils.saveBitmap(bitmap, (Context)activity, new BitmapUtils.OnSaveBitmapCallback(){

            @Override
            public void onSuccess(Uri screenshotUri) {
                screenshotUri = screenshotUri;
                initialScreenshotCapturingListenr.onScreenshotCapturedSuccessfully(screenshotUri);
            }

            @Override
            public void onError(Throwable throwable) {
                InstabugSDKLogger.e(this, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                initialScreenshotCapturingListenr.onScreenshotCapturingFailed(throwable);
            }
        });
    }

    private static boolean isUsingMediaProjection() {
        return SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
    }

    public static interface InitialScreenshotCapturingListener {
        public void onScreenshotCapturedSuccessfully(Uri var1);

        public void onScreenshotCapturingFailed(Throwable var1);
    }
}

