/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.json.JSONException;

public final class ObjectMapper {
    @Nullable
    public static String toJson(Cacheable cacheable) {
        try {
            return cacheable.toJson();
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(ObjectMapper.class, jSONException.getMessage(), jSONException);
            return null;
        }
    }

    @Nullable
    public static <T extends Cacheable> T fromJson(String json, Class<T> clazz) {
        if (json != null) {
            try {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                Cacheable cacheable = (Cacheable)constructor.newInstance(new Object[0]);
                cacheable.fromJson(json);
                return (T)cacheable;
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(ObjectMapper.class, jSONException.getMessage(), jSONException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                InstabugSDKLogger.e(ObjectMapper.class, "The object must have a public default constructor", noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                InstabugSDKLogger.e(ObjectMapper.class, "The object must have a public default constructor", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                InstabugSDKLogger.e(ObjectMapper.class, "The object must have a public default constructor", instantiationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                InstabugSDKLogger.e(ObjectMapper.class, "The object must have a public default constructor", invocationTargetException);
            }
        }
        return null;
    }
}

