/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

public class InstabugViewPager
extends ViewPager {
    private boolean swipeable = true;
    private boolean autoHeight = false;

    public InstabugViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.swipeable) {
            return super.onTouchEvent(event);
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.swipeable) {
            return super.onInterceptTouchEvent(event);
        }
        return false;
    }

    public void setSwipeable(boolean swipeEnabled) {
        this.swipeable = swipeEnabled;
    }

    public void scrollForward(boolean smoothScroll) {
        if (this.getAdapter() != null && this.getAdapter().getCount() - 1 > this.getCurrentItem()) {
            this.setCurrentItem(this.getCurrentItem() + 1, smoothScroll);
        }
    }

    public void scrollBackward(boolean smoothScroll) {
        this.scrollBackwardWithOffset(smoothScroll, 1);
    }

    public void scrollBackwardWithOffset(boolean smoothScroll, int offset) {
        if (this.getAdapter() != null && this.getCurrentItem() > 0) {
            this.setCurrentItem(this.getCurrentItem() - offset, smoothScroll);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.autoHeight) {
            int n = 0;
            for (int k = 0; k < this.getChildCount(); ++k) {
                View view = this.getChildAt(k);
                view.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                int n2 = view.getMeasuredHeight();
                if (n2 <= n) continue;
                n = n2;
            }
            if (n != 0) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n, (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setAutoHeight(boolean autoHeight) {
        this.autoHeight = autoHeight;
    }
}

