/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.operation;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperationCallback;
import com.instabug.library.util.threading.PoolProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class ReadStateFromFileDiskOperation
implements DiskOperation<String, Void> {
    private final Uri uri;

    public ReadStateFromFileDiskOperation(Uri uri) {
        this.uri = uri;
    }

    @Override
    public String execute(Void aVoid) throws IOException {
        return this.getTextFromFile();
    }

    @Override
    public void executeAsync(Void aVoid, final @Nullable DiskOperationCallback<String> callback) {
        PoolProvider.postIOTask(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    try {
                        callback.onSuccess(ReadStateFromFileDiskOperation.this.getTextFromFile());
                    }
                    catch (IOException iOException) {
                        callback.onFailure(iOException);
                    }
                }
            }
        });
    }

    private String getTextFromFile() throws IOException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        File file = new File(this.uri.getPath());
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF8"));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }
}

