/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.ui;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.view.View;
import android.view.ViewStub;
import android.widget.ImageButton;
import android.widget.TextView;
import com.instabug.library.R;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.SystemServiceUtils;

public abstract class ToolbarFragment<P extends BaseContract.Presenter>
extends InstabugBaseFragment<P> {
    protected ImageButton toolbarImageButtonDone;
    protected ImageButton toolbarImageButtonClose;

    @Override
    @CallSuper
    protected void initViews(View rootView, Bundle savedInstanceState) {
        this.initToolbarViews();
        ViewStub viewStub = (ViewStub)this.findViewById(R.id.instabug_content);
        viewStub.setLayoutResource(this.getContentLayout());
        viewStub.inflate();
        this.initContentViews(rootView, savedInstanceState);
        this.setTitle(this.getTitle());
    }

    private void initToolbarViews() {
        this.toolbarImageButtonDone = (ImageButton)this.findViewById(R.id.instabug_btn_toolbar_right);
        this.toolbarImageButtonDone.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SystemServiceUtils.hideInputMethod((Activity)ToolbarFragment.this.getActivity());
                ToolbarFragment.this.onDoneButtonClicked();
            }
        });
        this.toolbarImageButtonClose = (ImageButton)this.findViewById(R.id.instabug_btn_toolbar_left);
        this.toolbarImageButtonClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ToolbarFragment.this.onCloseButtonClicked();
            }
        });
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_fragment_toolbar;
    }

    @LayoutRes
    protected abstract int getContentLayout();

    protected abstract void initContentViews(View var1, Bundle var2);

    protected void setTitle(String title) {
        if (this.rootView == null) {
            InstabugSDKLogger.v(this, "Calling setTitle before inflating the view! Ignoring call");
            return;
        }
        TextView textView = (TextView)this.findViewById(R.id.instabug_fragment_title);
        InstabugSDKLogger.v(this, "Setting fragment title to \"" + title + "\"");
        textView.setText((CharSequence)title);
    }

    protected abstract String getTitle();

    protected abstract void onDoneButtonClicked();

    protected void onCloseButtonClicked() {
        SystemServiceUtils.hideInputMethod((Activity)this.getActivity());
        this.getActivity().onBackPressed();
    }
}

