/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.instabug.library.Instabug;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class InstabugDeprecationLogger {
    private static final String PREFIX_SECTION = "#section-";
    @VisibleForTesting
    static String baseUrl = "https://docs.instabug.com/docs/android-sdk-8-1-migration-guide";
    private static InstabugDeprecationLogger INSTANCE;

    private InstabugDeprecationLogger() {
    }

    public static InstabugDeprecationLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugDeprecationLogger();
        }
        return INSTANCE;
    }

    @VisibleForTesting
    static void tearDown() {
        INSTANCE = null;
    }

    private static void setBaseUrl(String baseUrl) {
        if (baseUrl != null && baseUrl.trim().length() > 0) {
            InstabugDeprecationLogger.baseUrl = baseUrl;
        }
    }

    public void log(int section) {
        Context context;
        if (Instabug.isBuilt() && (context = Instabug.getApplicationContext()) != null) {
            boolean bl;
            boolean bl2 = bl = (context.getApplicationInfo().flags & 2) != 0;
            if (bl) {
                Log.i((String)"INSTABUG", (String)(" \n+-------------------------------------------------------------------------------------------+\n|                           [Instabug] Our APIs have changed!                               |\n+-------------------------------------------------------------------------------------------+\n| The main objective of this release is to give you more controls over the enabled Instabug |\n| products in the SDK. Some APIs have been renamed, moved to new classes or deprecated      |\n|                                                                                           |\n|                                                                                           |\n| Starting from version 8.1 of the SDK, you'll need to migrate to our new APIs. Old         |\n| APIs are currently deprecated, and while they still function, they will be completely     |\n| removed in a future release.                                                              |\n|                                                                                           |\n| For more details about this API's replacement, check the docs here:                       |\n| " + this.getMigrationPageUrl(section) + "                                                      |\n+-------------------------------------------------------------------------------------------+"));
            }
        }
    }

    public void log(String message) {
        Context context;
        if (Instabug.isBuilt() && (context = Instabug.getApplicationContext()) != null) {
            boolean bl;
            boolean bl2 = bl = (context.getApplicationInfo().flags & 2) != 0;
            if (bl) {
                Log.i((String)"INSTABUG", (String)message);
            }
        }
    }

    @VisibleForTesting
    String getMigrationPageUrl() {
        return baseUrl;
    }

    @VisibleForTesting
    String getMigrationPageUrl(int section) {
        return baseUrl + PREFIX_SECTION + this.getSection(section);
    }

    private String getSection(int section) {
        switch (section) {
            case 0: {
                return "invoke";
            }
            case 1: {
                return "invoke-with-mode";
            }
            case 2: {
                return "setpromptoptions";
            }
            case 3: {
                return "setinvocationoptions";
            }
            case 4: {
                return "setonnewreplyreceivedcallback";
            }
            case 5: {
                return "setreplynotificationenabled";
            }
            case 6: {
                return "getunreadmessagescount";
            }
            case 7: {
                return "setpushnotificationstate";
            }
            case 8: {
                return "setpushnotificationregistrationtoken";
            }
            case 9: {
                return "shownotification";
            }
            case 10: {
                return "setinappreplynotificationsound";
            }
            case 11: {
                return "setcrashreportingstate";
            }
            case 12: {
                return "setsurveysstate";
            }
            case 13: {
                return "isinstabugnotification";
            }
            case 14: {
                return "setnotificationicon";
            }
            case 15: {
                return "setpushnotificationchannelid";
            }
            case 16: {
                return "setsystemreplynotificationsoundenabled";
            }
            case 17: {
                return "setshouldplayconversationsounds";
            }
        }
        return "";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MigrationSection {
        public static final int METHOD_INVOKE = 0;
        public static final int METHOD_INVOKE_WITH_MODE = 1;
        public static final int METHOD_SET_PROMPT_OPTIONS = 2;
        public static final int METHOD_SET_INVOCATION_OPTIONS = 3;
        public static final int METHOD_SET_ON_NEW_REPLY_RECEIVED_CALLBACK = 4;
        public static final int METHOD_SET_REPLY_NOTIFICATION_ENABLED = 5;
        public static final int METHOD_GET_UNREAD_MESSAGES_COUNT = 6;
        public static final int METHOD_SET_PUSH_NOTIFICATION_STATE = 7;
        public static final int METHOD_SET_PUSH_NOTIFICATION_REGISTRATION_TOKEN = 8;
        public static final int METHOD_SHOW_NOTIFICATION = 9;
        public static final int METHOD_SET_IN_APP_REPLY_NOTIFICATION_SOUND = 10;
        public static final int METHOD_SET_CRASH_REPORT_STATE = 11;
        public static final int METHOD_SET_SURVEY_STATE = 12;
        public static final int METHOD_IS_INSTABUG_NOTIFICATION = 13;
        public static final int METHOD_SET_NOTIFICATION_ICON = 14;
        public static final int METHOD_SET_NOTIFICATION_CHANNEL_ID = 15;
        public static final int METHOD_SET_SYSTEM_REPLY_NOTIFICATION_SOUND_ENABLED = 16;
        public static final int METHOD_SET_SHOULD_PLAY_CONV_SOUNDS = 17;
    }
}

