/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom.pagerindicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.instabug.library.R;
import com.instabug.library.ui.custom.pagerindicator.Dot;
import com.instabug.library.ui.custom.pagerindicator.SelectionIndicator;
import com.instabug.library.view.ViewUtils;
import java.util.ArrayList;

public final class DotIndicator
extends RelativeLayout
implements SelectionIndicator {
    private static final String TAG = "[DotIndicator]";
    private static final int DEFAULT_NUMBER_OF_DOTS = 1;
    private static final int DEFAULT_SELECTED_DOT_INDEX = 0;
    private static final int DEFAULT_UNSELECTED_DOT_DIAMETER_DP = 6;
    private static final int DEFAULT_SELECTED_DOT_DIAMETER_DP = 9;
    private static final int DEFAULT_UNSELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SPACING_BETWEEN_DOTS_DP = 7;
    private static final int DEFAULT_DOT_TRANSITION_DURATION_MS = 200;
    private final ArrayList<Dot> dots = new ArrayList();
    private int numberOfDots;
    private int selectedDotIndex;
    private int unselectedDotDiameterPx;
    private int selectedDotDiameterPx;
    private int unselectedDotColor;
    private int selectedDotColor;
    private int spacingBetweenDotsPx;
    private int dotTransitionDuration;

    public DotIndicator(Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public DotIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public DotIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public DotIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.IBDotIndicator, defStyleAttr, defStyleRes);
        int n = ViewUtils.convertDpToPx(this.getContext(), 9.0f);
        int n2 = ViewUtils.convertDpToPx(this.getContext(), 6.0f);
        int n3 = ViewUtils.convertDpToPx(this.getContext(), 7.0f);
        this.numberOfDots = typedArray.getInt(R.styleable.IBDotIndicator_ibViewPagerNumberOfDots, 1);
        this.selectedDotIndex = typedArray.getInt(R.styleable.IBDotIndicator_ibViewPagerSelectedDotIndex, 0);
        this.unselectedDotDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerUnselectedDotDiameter, n2);
        this.selectedDotDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerSelectedDotDiameter, n);
        this.unselectedDotColor = typedArray.getColor(R.styleable.IBDotIndicator_ibViewPagerUnselectedDotColor, -1);
        this.selectedDotColor = typedArray.getColor(R.styleable.IBDotIndicator_ibViewPagerSelectedDotColor, -1);
        this.spacingBetweenDotsPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerSpacingBetweenDots, n3);
        this.dotTransitionDuration = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerTransitionDuration, 200);
        typedArray.recycle();
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.setGravity(17);
        this.reflectParametersInView();
    }

    private void reflectParametersInView() {
        this.removeAllViews();
        this.dots.clear();
        for (int k = 0; k < this.numberOfDots; ++k) {
            Dot dot = new Dot(this.getContext());
            dot.setInactiveDiameterPx(this.unselectedDotDiameterPx).setActiveDiameterPx(this.selectedDotDiameterPx).setActiveColor(this.selectedDotColor).setInactiveColor(this.unselectedDotColor).setTransitionDuration(this.dotTransitionDuration);
            if (k == this.selectedDotIndex) {
                dot.setActive(false);
            } else {
                dot.setInactive(false);
            }
            int n = Math.max(this.selectedDotDiameterPx, this.unselectedDotDiameterPx);
            int n2 = k * (this.spacingBetweenDotsPx + this.unselectedDotDiameterPx);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n, n);
            layoutParams.setMargins(n2, 0, 0, 0);
            if (Build.VERSION.SDK_INT >= 17) {
                layoutParams.setMarginStart(n2);
            }
            dot.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addView((View)dot);
            this.dots.add(k, dot);
        }
    }

    public void redrawDots() {
        this.reflectParametersInView();
    }

    public void setUnselectedDotDiameterPx(int unselectedDotDiameterPx) {
        this.unselectedDotDiameterPx = unselectedDotDiameterPx;
        this.reflectParametersInView();
    }

    public void setUnselectedDotDiameterDp(int unselectedDotDiameterDp) {
        int n = ViewUtils.convertDpToPx(this.getContext(), unselectedDotDiameterDp);
        this.setUnselectedDotDiameterPx(n);
    }

    public int getUnselectedDotDiameter() {
        return this.unselectedDotDiameterPx;
    }

    public void setSelectedDotDiameterPx(int selectedDotDiameterPx) {
        this.selectedDotDiameterPx = selectedDotDiameterPx;
        this.reflectParametersInView();
    }

    public void setSelectedDotDiameterDp(int selectedDotDiameterDp) {
        int n = ViewUtils.convertDpToPx(this.getContext(), selectedDotDiameterDp);
        this.setSelectedDotDiameterPx(n);
    }

    public int getSelectedDotDiameter() {
        return this.selectedDotDiameterPx;
    }

    public int getUnselectedDotColor() {
        return this.unselectedDotColor;
    }

    public void setUnselectedDotColor(int unselectedDotColor) {
        this.unselectedDotColor = unselectedDotColor;
        this.reflectParametersInView();
    }

    public int getSelectedDotColor() {
        return this.selectedDotColor;
    }

    public void setSelectedDotColor(int selectedDotColor) {
        this.selectedDotColor = selectedDotColor;
        this.reflectParametersInView();
    }

    public void setSpacingBetweenDotsPx(int spacingBetweenDotsPx) {
        this.spacingBetweenDotsPx = spacingBetweenDotsPx;
        this.reflectParametersInView();
    }

    public void setSpacingBetweenDotsDp(int spacingBetweenDotsDp) {
        int n = ViewUtils.convertDpToPx(this.getContext(), spacingBetweenDotsDp);
        this.setSpacingBetweenDotsPx(n);
    }

    public int getSpacingBetweenDots() {
        return this.spacingBetweenDotsPx;
    }

    @Override
    public void setSelectedItem(int index, boolean animate) {
        if (this.dots.size() > 0) {
            try {
                if (this.selectedDotIndex < this.dots.size()) {
                    this.dots.get(this.selectedDotIndex).setInactive(animate);
                }
                this.dots.get(index).setActive(animate);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
            this.selectedDotIndex = index;
        }
    }

    @Override
    public int getSelectedItemIndex() {
        return this.selectedDotIndex;
    }

    @Override
    public int getNumberOfItems() {
        return this.numberOfDots;
    }

    @Override
    public void setNumberOfItems(int numberOfItems) {
        this.numberOfDots = numberOfItems;
        this.reflectParametersInView();
    }

    @Override
    public int getTransitionDuration() {
        return this.dotTransitionDuration;
    }

    @Override
    public void setTransitionDuration(int transitionDurationMs) {
        this.dotTransitionDuration = transitionDurationMs;
        this.reflectParametersInView();
    }

    @Override
    public void setVisibility(boolean show) {
        this.setVisibility(show ? 0 : 4);
    }

    @Override
    public boolean isVisible() {
        return this.getVisibility() == 0;
    }
}

