/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.MotionEvent;
import com.instabug.library.Feature;
import com.instabug.library._InstabugActivity;
import com.instabug.library.b;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.model.g;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.d;
import com.instabug.library.tracking.e;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.g;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    private static InstabugInternalTrackingDelegate INSTANCE;
    private WeakReference<Activity> currentActivity;

    public static void init(Application application) {
        if (INSTANCE == null) {
            INSTANCE = new InstabugInternalTrackingDelegate(application);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    private InstabugInternalTrackingDelegate(Application application) {
        if (application != null) {
            this.registerActivityLifecycleListener(application);
        }
    }

    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, application.getClass().getSimpleName() + " created");
            e.a().a(application.getClass().getName(), g.a.APPLICATION_CREATED);
        }
    }

    void handleActivityCreatedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " created");
                e.a().a(activity.getClass().getName(), g.a.ACTIVITY_CREATED);
            }
            if (this.isReproStepsEnable()) {
                g.a().a(g.a.ACTIVITY_CREATED, activity.getClass().getSimpleName(), activity.getClass().getName(), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.CREATED);
        }
    }

    void handleActivityStartedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " started");
                e.a().a(activity.getClass().getName(), g.a.ACTIVITY_STARTED);
            }
            if (this.isReproStepsEnable()) {
                g.a().a(g.a.ACTIVITY_STARTED, activity.getClass().getSimpleName(), activity.getClass().getName(), null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STARTED);
    }

    void handleActivityResumedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            this.currentActivity = new WeakReference<Activity>(activity);
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " resumed");
                e.a().a(activity.getClass().getName(), g.a.ACTIVITY_RESUMED);
            }
            if (this.isReproStepsEnable()) {
                g.a().a(g.a.ACTIVITY_RESUMED, activity.getClass().getSimpleName(), activity.getClass().getName(), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.RESUMED);
        }
    }

    void handleActivityPausedEvent(Activity activity) {
        Activity activity2 = null;
        if (this.currentActivity != null) {
            activity2 = (Activity)this.currentActivity.get();
        }
        if (this.isNotInstabugActivity(activity)) {
            if (activity2 == null) {
                InstabugSDKLogger.w(this, "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!activity.equals(activity2)) {
                InstabugSDKLogger.w(this, "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " paused");
                e.a().a(activity.getClass().getName(), g.a.ACTIVITY_PAUSED);
            }
            if (this.isReproStepsEnable()) {
                g.a().a(g.a.ACTIVITY_PAUSED, activity.getClass().getSimpleName(), activity.getClass().getName(), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.PAUSED);
        }
    }

    void handleActivityStoppedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " stopped");
                e.a().a(activity.getClass().getName(), g.a.ACTIVITY_STOPPED);
            }
            if (this.isReproStepsEnable()) {
                g.a().a(g.a.ACTIVITY_STOPPED, activity.getClass().getSimpleName(), activity.getClass().getName(), null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STOPPED);
    }

    void handleActivityDestroyedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " destroyed");
                e.a().a(activity.getClass().getName(), g.a.ACTIVITY_DESTROYED);
            }
            if (this.isReproStepsEnable()) {
                g.a().a(g.a.ACTIVITY_DESTROYED, activity.getClass().getSimpleName(), activity.getClass().getName(), null);
            }
            if (activity != null) {
                String string2 = activity.getLocalClassName();
                if (this.currentActivity != null && this.currentActivity.get() != null && string2.equals(((Activity)this.currentActivity.get()).getLocalClassName())) {
                    this.currentActivity.clear();
                }
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    public void onFragmentAttached(Fragment fragment) {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            Activity activity = (Activity)this.currentActivity.get();
            if (this.isUserTrackingStepsEnable()) {
                e.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.FRAGMENT_ATTACHED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.a().a(g.a.FRAGMENT_ATTACHED, fragment.getClass().getSimpleName(), fragment.getClass().getName(), null);
        }
    }

    public void onFragmentViewCreated(Fragment fragment) {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            Activity activity = (Activity)this.currentActivity.get();
            if (this.isUserTrackingStepsEnable()) {
                e.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.FRAGMENT_VIEW_CREATED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.a().a(g.a.FRAGMENT_VIEW_CREATED, fragment.getClass().getSimpleName(), fragment.getClass().getName(), null);
        }
    }

    public void onFragmentStarted(Fragment fragment) {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            Activity activity = (Activity)this.currentActivity.get();
            if (this.isUserTrackingStepsEnable()) {
                e.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.FRAGMENT_STARTED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.a().a(g.a.FRAGMENT_STARTED, fragment.getClass().getSimpleName(), fragment.getClass().getName(), null);
        }
    }

    public void onFragmentResumed(Fragment fragment) {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            Activity activity = (Activity)this.currentActivity.get();
            if (this.isUserTrackingStepsEnable()) {
                e.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.FRAGMENT_RESUMED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.a().a(g.a.FRAGMENT_RESUMED, fragment.getClass().getSimpleName(), fragment.getClass().getName(), null);
        }
    }

    public void onFragmentPaused(Fragment fragment) {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            Activity activity = (Activity)this.currentActivity.get();
            if (this.isUserTrackingStepsEnable()) {
                e.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.FRAGMENT_PAUSED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.a().a(g.a.FRAGMENT_PAUSED, fragment.getClass().getSimpleName(), fragment.getClass().getName(), null);
        }
    }

    public void onFragmentStopped(Fragment fragment) {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            Activity activity = (Activity)this.currentActivity.get();
            if (this.isUserTrackingStepsEnable()) {
                e.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.FRAGMENT_STOPPED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.a().a(g.a.FRAGMENT_STOPPED, fragment.getClass().getSimpleName(), fragment.getClass().getName(), null);
        }
    }

    public void onFragmentDetached(Fragment fragment) {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            Activity activity = (Activity)this.currentActivity.get();
            if (this.isUserTrackingStepsEnable()) {
                e.a().a(fragment.getClass().getName(), activity.getClass().getName(), g.a.FRAGMENT_DETACHED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.a().a(g.a.FRAGMENT_DETACHED, fragment.getClass().getSimpleName(), fragment.getClass().getName(), null);
        }
    }

    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment) {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            Activity activity = (Activity)this.currentActivity.get();
            if (this.isUserTrackingStepsEnable()) {
                e.a().a(fragment.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + isVisible, g.a.FRAGMENT_VISIBILITY_CHANGED);
            }
        }
        if (this.isReproStepsEnable()) {
            g.a().a(g.a.FRAGMENT_VISIBILITY_CHANGED, fragment.getClass().getSimpleName(), fragment.getClass().getName(), null);
        }
    }

    public void trackTouchEvent(MotionEvent event, Activity activity) {
        d.a().a(activity, event);
    }

    public Activity getCurrentActivity() {
        Activity activity = null;
        if (this.currentActivity != null) {
            activity = (Activity)this.currentActivity.get();
        }
        if (activity != null) {
            return activity;
        }
        return null;
    }

    @Nullable
    public Activity getTargetActivity() {
        Activity activity = null;
        Activity activity2 = null;
        if (this.currentActivity != null) {
            activity2 = (Activity)this.currentActivity.get();
        }
        if (activity2 != null && activity2.getParent() != null) {
            activity = activity2.getParent();
            while (activity.getParent() != null) {
                activity = activity.getParent();
            }
        } else if (activity2 != null) {
            activity = activity2;
        }
        return activity;
    }

    private void registerActivityLifecycleListener(Application application) {
        InstabugSDKLogger.v(this, "Registering activity lifecycle listener");
        a a2 = new a();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)a2);
        application.registerComponentCallbacks((ComponentCallbacks)a2);
    }

    private boolean isUserTrackingStepsEnable() {
        return b.a().c(Feature.TRACK_USER_STEPS) == Feature.State.ENABLED;
    }

    private boolean isReproStepsEnable() {
        return b.a().c(Feature.REPRO_STEPS) == Feature.State.ENABLED;
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return !(activity instanceof _InstabugActivity);
    }
}

