/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.app.Activity;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.MotionEvent;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.b;
import com.instabug.library.core.InitialScreenshotHelper;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventSubscriber;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.a.a;
import com.instabug.library.invocation.a.d;
import com.instabug.library.invocation.a.e;
import com.instabug.library.invocation.a.f;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class InvocationManager
implements com.instabug.library.invocation.a {
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings = new InvocationSettings();
    private InstabugInvocationEvent[] currentInstabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
    private List<a> currentInvokers = new ArrayList<a>();
    private a lastUsedInvoker;
    private Disposable currentActivityLifeCycleDisposable;
    private Disposable featurePlanUpdateDisposable;
    private boolean isInvocationAvailable = true;

    private InvocationManager() {
        this.subscribeToCarenActivityLifeCycle();
        this.subscribeToFeaturePlanUpdate();
    }

    private void subscribeToFeaturePlanUpdate() {
        this.featurePlanUpdateDisposable = SDKCoreEventSubscriber.subscribe(new Consumer<SDKCoreEvent>(){

            public void a(SDKCoreEvent sDKCoreEvent) {
                if (sDKCoreEvent.getType().equals("features") && sDKCoreEvent.getValue().equals("fetched")) {
                    InvocationManager.this.invalidateDefaultPromptOptions();
                }
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((SDKCoreEvent)object);
            }
        });
    }

    public static void init() {
        InstabugSDKLogger.v(InvocationManager.class, "initializing invocationManager");
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else {
            INSTANCE.listen();
        }
    }

    public static InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    public void release() {
        if (this.currentActivityLifeCycleDisposable != null && !this.currentActivityLifeCycleDisposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        if (this.featurePlanUpdateDisposable != null && !this.featurePlanUpdateDisposable.isDisposed()) {
            this.featurePlanUpdateDisposable.dispose();
            this.featurePlanUpdateDisposable = null;
        }
    }

    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        boolean bl;
        this.currentInstabugInvocationEvents = this.removeDuplicates(instabugInvocationEvent);
        boolean bl2 = bl = this.currentInvokers != null && this.currentInvokers.size() > 0;
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                a2.b();
            }
            this.currentInvokers.clear();
        }
        block7: for (InstabugInvocationEvent instabugInvocationEvent2 : instabugInvocationEvent) {
            if (instabugInvocationEvent2 == InstabugInvocationEvent.NONE && instabugInvocationEvent.length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                this.currentInvokers = new ArrayList<a>();
            }
            switch (instabugInvocationEvent2) {
                case SHAKE: {
                    e e2 = new e(Instabug.getApplicationContext(), this);
                    e2.a(this.currentInvocationSettings.getShakeThreshold());
                    this.currentInvokers.add(e2);
                    continue block7;
                }
                case FLOATING_BUTTON: {
                    this.currentInvokers.add(new com.instabug.library.invocation.a.b(this));
                    continue block7;
                }
                case TWO_FINGER_SWIPE_LEFT: {
                    this.currentInvokers.add(new f(Instabug.getApplicationContext(), this));
                    continue block7;
                }
                case SCREENSHOT: {
                    this.currentInvokers.add(new d(this));
                    continue block7;
                }
            }
        }
        if (this.currentInvokers != null && bl) {
            this.setLastUsedInvoker(null);
            for (a a3 : this.currentInvokers) {
                a3.a();
            }
        }
    }

    @VisibleForTesting
    InstabugInvocationEvent[] removeDuplicates(InstabugInvocationEvent[] events) {
        ArrayList<InstabugInvocationEvent> arrayList = new ArrayList<InstabugInvocationEvent>();
        HashSet<InstabugInvocationEvent> hashSet = new HashSet<InstabugInvocationEvent>();
        for (InstabugInvocationEvent instabugInvocationEvent : events) {
            if (hashSet.contains((Object)instabugInvocationEvent)) continue;
            arrayList.add(instabugInvocationEvent);
            hashSet.add(instabugInvocationEvent);
        }
        InstabugInvocationEvent[] instabugInvocationEventArray = new InstabugInvocationEvent[arrayList.size()];
        return arrayList.toArray(instabugInvocationEventArray);
    }

    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        return Arrays.copyOf(this.currentInstabugInvocationEvents, this.currentInstabugInvocationEvents.length);
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    public void enableInvocationOption(int invocationOption, boolean notifyChanges) {
        this.currentInvocationSettings.enabledPromptOption(invocationOption);
        if (notifyChanges) {
            this.notifyInvocationOptionChanged();
        }
    }

    public void disableInvocationOption(int invocationOption, boolean notifyChanges) {
        this.currentInvocationSettings.disabledPromptOption(invocationOption);
        if (notifyChanges) {
            this.notifyInvocationOptionChanged();
        }
    }

    List<a> getCurrentInvokers() {
        return this.currentInvokers;
    }

    public a getLastUsedInvoker() {
        return this.lastUsedInvoker;
    }

    public void setLastUsedInvoker(a lastUsedInvoker) {
        this.lastUsedInvoker = lastUsedInvoker;
    }

    private void listen() {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && this.isInvocationAvailable && this.isPromptOptionsAvailable() && this.currentInvokers != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (a a2 : this.currentInvokers) {
                a2.a();
            }
        }
    }

    public void handle(MotionEvent motionEvent) {
        if (Instabug.getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (a a2 : this.currentInvokers) {
                if (!(a2 instanceof f)) continue;
                ((f)a2).a(motionEvent);
                break;
            }
        }
    }

    public void sleep() {
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                a2.b();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable = false;
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable = true;
    }

    public void invoke() {
        if (!InstabugCore.isForegroundBusy()) {
            this.invoke(this.currentInvocationSettings.getDefaultInvocationMode());
        }
    }

    public void invoke(int invocationMode) {
        if (this.isInstabugEnabled() && !InstabugCore.isForegroundBusy()) {
            switch (invocationMode) {
                case 0: 
                case 3: 
                case 4: {
                    this.invoke(invocationMode, null);
                    break;
                }
                case 1: 
                case 2: {
                    SettingsManager.getInstance();
                    boolean bl = SettingsManager.isInitialScreenShotAllowed();
                    if (bl) {
                        this.captureScreenshotThenInvoke(invocationMode);
                        break;
                    }
                    this.invoke(invocationMode, null);
                    break;
                }
            }
        }
    }

    public void invokeChats() {
        PluginPromptOption pluginPromptOption = this.getPromptOptionByIdentifier(2);
        if (pluginPromptOption != null) {
            pluginPromptOption.invoke();
        }
    }

    @Nullable
    private PluginPromptOption getPromptOptionByIdentifier(@PluginPromptOption.PromptOptionIdentifier int identifier) {
        ArrayList<PluginPromptOption> arrayList = this.getAvailablePromptOptions();
        for (PluginPromptOption pluginPromptOption : arrayList) {
            if (pluginPromptOption.getPromptOptionIdentifier() != identifier) continue;
            return pluginPromptOption;
        }
        return null;
    }

    @VisibleForTesting
    void invoke(int invocationMode, @Nullable Uri screenshotUri) {
        this.startPreInvocationRunnable();
        if (SettingsManager.getInstance().isScreenCurrentlyRecorded()) {
            AutoScreenRecordingEventBus.getInstance().post(ScreenRecordingService.Action.STOP_TRIM_KEEP);
        }
        switch (invocationMode) {
            case 0: {
                this.invokeWithAvailableOptions(screenshotUri);
                break;
            }
            case 1: 
            case 2: {
                PluginPromptOption pluginPromptOption = PluginPromptOption.getPromptOptionByInvocationMode(invocationMode);
                if (pluginPromptOption != null) {
                    pluginPromptOption.invoke(screenshotUri);
                    break;
                }
                InstabugSDKLogger.w(InvocationManager.class, "'" + invocationMode + "' invocationMode isn't available");
                break;
            }
            case 4: {
                List<PluginPromptOption> list = PluginPromptOption.getAllPromptOptionsByInvocationMode(invocationMode);
                if (list.size() > 1) {
                    list.get(1).invoke();
                    break;
                }
                if (list.isEmpty()) break;
                list.get(0).invoke();
                break;
            }
            case 3: {
                com.instabug.library.d.a.b();
                break;
            }
        }
    }

    private void startPreInvocationRunnable() {
        if (SettingsManager.getInstance().getOnInvokeCallback() != null) {
            SettingsManager.getInstance().getOnInvokeCallback().onInvoke();
        }
    }

    private boolean isInvocationOptionsAreChatsAndReplies(List<PluginPromptOption> promptOptions) {
        boolean bl = true;
        for (PluginPromptOption pluginPromptOption : promptOptions) {
            if (pluginPromptOption.getPromptOptionIdentifier() != 0 && pluginPromptOption.getPromptOptionIdentifier() != 1) continue;
            bl = false;
        }
        return bl;
    }

    @VisibleForTesting
    void invokeWithAvailableOptions(Uri screenshotUri) {
        ArrayList<PluginPromptOption> arrayList = this.getAvailablePromptOptions();
        SettingsManager.getInstance();
        boolean bl = SettingsManager.isInitialScreenShotAllowed();
        if (arrayList.size() >= 2) {
            if (this.isInvocationOptionsAreChatsAndReplies(arrayList)) {
                this.launchPromptOptionActivity(screenshotUri);
                return;
            }
            if (screenshotUri == null && bl) {
                this.captureScreenshotThenLaunchPromptOptionActivity();
            } else {
                this.launchPromptOptionActivity(screenshotUri);
            }
        } else if (arrayList.size() == 1) {
            PluginPromptOption pluginPromptOption = arrayList.get(0);
            int n = pluginPromptOption.getInvocationMode();
            switch (n) {
                case 1: 
                case 2: {
                    if (screenshotUri == null && bl) {
                        this.captureScreenshotThenInvoke(n);
                        break;
                    }
                    this.invoke(n, screenshotUri);
                    break;
                }
                case 4: 
                case 5: {
                    pluginPromptOption.invoke();
                    break;
                }
            }
        } else {
            InstabugSDKLogger.w(InvocationManager.class, "No plugins prompt options available");
        }
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        ArrayList<PluginPromptOption> arrayList = new ArrayList<PluginPromptOption>();
        for (PluginPromptOption pluginPromptOption : com.instabug.library.core.plugin.a.e()) {
            if (!this.currentInvocationSettings.getEnabledPromptOptions()[pluginPromptOption.getInvocationMode()]) continue;
            arrayList.add(pluginPromptOption);
        }
        return arrayList;
    }

    public boolean isInvocationOptionEnabled(int invocationOption) {
        return this.currentInvocationSettings.getEnabledPromptOptions()[invocationOption];
    }

    @VisibleForTesting
    void captureScreenshotThenLaunchPromptOptionActivity() {
        InitialScreenshotHelper.captureScreenshot(new InitialScreenshotHelper.InitialScreenshotCapturingListener(){

            @Override
            public void onScreenshotCapturedSuccessfully(Uri screenshotUri) {
                InvocationManager.this.launchPromptOptionActivity(screenshotUri);
            }

            @Override
            public void onScreenshotCapturingFailed(Throwable throwable) {
                InvocationManager.this.launchPromptOptionActivity(null);
            }
        });
    }

    @VisibleForTesting
    void captureScreenshotThenInvoke(final int invocationMode) {
        InitialScreenshotHelper.captureScreenshot(new InitialScreenshotHelper.InitialScreenshotCapturingListener(){

            @Override
            public void onScreenshotCapturedSuccessfully(Uri screenshotUri) {
                InvocationManager.this.invoke(invocationMode, screenshotUri);
            }

            @Override
            public void onScreenshotCapturingFailed(Throwable throwable) {
                InvocationManager.this.invoke(invocationMode, null);
            }
        });
    }

    @Override
    public void onInvocationRequested(Uri screenshotUri) {
        this.invoke(this.currentInvocationSettings.getDefaultInvocationMode(), screenshotUri);
    }

    @Override
    public void onInvocationRequested() {
        this.invoke();
    }

    @VisibleForTesting
    void launchPromptOptionActivity(Uri screenshotUri) {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            com.instabug.library.ui.a.a.a().a(activity, screenshotUri);
        }
    }

    private void subscribeToCarenActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                switch (activityLifeCycleEvent) {
                    case RESUMED: {
                        InstabugSDKLogger.v(this, "current activity resumed");
                        InvocationManager.this.listen();
                        break;
                    }
                    case PAUSED: {
                        InstabugSDKLogger.v(this, "current activity paused");
                        InvocationManager.this.sleep();
                        break;
                    }
                }
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((ActivityLifeCycleEvent)((Object)object));
            }
        });
    }

    private boolean isInstabugEnabled() {
        return b.a().c(Feature.INSTABUG) == Feature.State.ENABLED && b.a().a(Feature.INSTABUG);
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    public void notifyPrimaryColorChanged() {
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                if (!(a2 instanceof com.instabug.library.invocation.a.b)) continue;
                a2.b();
                a2.a();
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        boolean bl = !this.isPromptOptionsAvailable();
        com.instabug.library.invocation.a.b b2 = this.getFloatingButtonInvoker();
        if (b2 != null) {
            if (bl) {
                b2.b();
            } else {
                b2.c();
            }
        }
    }

    @Nullable
    private com.instabug.library.invocation.a.b getFloatingButtonInvoker() {
        com.instabug.library.invocation.a.b b2 = null;
        if (this.currentInvokers != null) {
            for (a a2 : this.currentInvokers) {
                if (!(a2 instanceof com.instabug.library.invocation.a.b)) continue;
                b2 = (com.instabug.library.invocation.a.b)a2;
                break;
            }
        }
        return b2;
    }

    public void show() {
        this.invoke();
    }

    public void resetDefaultPromptOptions() {
        this.currentInvocationSettings.resetDefaultInvocationMode();
        this.currentInvocationSettings.resetAllInvocationOption(false);
    }

    public void resetDefaultPromptOptionsIncludingReportOptions() {
        this.currentInvocationSettings.resetDefaultInvocationMode();
        this.currentInvocationSettings.resetAllInvocationOption(true);
    }

    public void invalidateDefaultPromptOptions() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean[] blArray = this.currentInvocationSettings.getEnabledPromptOptions();
        block6: for (int k = 0; k < blArray.length; ++k) {
            boolean bl5 = blArray[k];
            if (!bl5) continue;
            switch (k) {
                case 4: {
                    bl = true;
                    continue block6;
                }
                case 1: {
                    bl2 = true;
                    continue block6;
                }
                case 2: {
                    bl3 = true;
                    continue block6;
                }
                case 5: {
                    if (!InstabugCore.isExperimentalFeatureAvailable(Feature.FEATURE_REQUESTS)) continue block6;
                    bl4 = true;
                    continue block6;
                }
            }
        }
        this.setDefaultPromptOption(bl, bl2, bl3, bl4);
    }

    private void setDefaultPromptOption(boolean isChat, boolean isBug, boolean isFeedback, boolean isFeatureRequest) {
        if (isChat && (isBug || isFeedback) || isBug && isFeedback || isFeatureRequest && (isBug || isFeedback) || isFeatureRequest && isChat) {
            this.currentInvocationSettings.setDefaultInvocationMode(0);
        } else if (isChat) {
            this.currentInvocationSettings.setDefaultInvocationMode(0);
        } else if (isBug) {
            this.currentInvocationSettings.setDefaultInvocationMode(1);
        } else if (isFeedback) {
            this.currentInvocationSettings.setDefaultInvocationMode(2);
        } else if (isFeatureRequest) {
            this.currentInvocationSettings.setDefaultInvocationMode(5);
        }
        if (!(isChat || isBug || isFeedback || isFeatureRequest)) {
            this.currentInvocationSettings.enabledPromptOption(1);
            this.currentInvocationSettings.setDefaultInvocationMode(1);
        }
    }

    @VisibleForTesting
    public static void tearDown() {
        INSTANCE = null;
    }
}

