/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.net.Uri;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportHelper {
    public static void update(State state, Report report) {
        if (state == null) {
            return;
        }
        state.setTags(ReportHelper.getAppendedUserTags(report.getTags()));
        state.updateConsoleLog(report.getConsoleLog());
        for (Map.Entry<Uri, String> entry : report.getFileAttachments().entrySet()) {
            Uri uri = entry.getKey();
            String string2 = entry.getValue();
            Instabug.addFileAttachment(uri, string2);
        }
        if (InstabugCore.getFeatureState(Feature.USER_DATA) == Feature.State.ENABLED && report.getUserData() != null) {
            String string3 = report.getUserData() == null ? Instabug.getUserData() : report.getUserData();
            state.setUserData(string3);
        }
        state.setUserAttributes(ReportHelper.getUserAppendedAttributes(report.getUserAttributes()));
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            state.setInstabugLog(InstabugLog.getLogs());
        }
    }

    private static String getAppendedUserTags(List<String> tags) {
        Instabug.getTags().addAll(tags);
        return InstabugCore.getTagsAsString();
    }

    private static String getUserAppendedAttributes(HashMap<String, String> userAttributes) {
        for (Map.Entry<String, String> entry : userAttributes.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            UserAttributeCacheManager.insert(string2, string3);
        }
        return UserAttributesDbHelper.getUserAttributes();
    }
}

