/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.util.Pair;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.instabug.library.Instabug;
import com.instabug.library.instacapture.c.a;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public final class ScreenshotTaker {
    private ScreenshotTaker() {
    }

    public static Observable<Bitmap> getScreenshotBitmap(Activity activity, @Nullable @IdRes int[] ignoredViewsIds) {
        Bitmap bitmap;
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        View view = activity.getWindow().getDecorView();
        List<RootViewInfo> list = FieldHelper.getRootViews(activity, ignoredViewsIds);
        InstabugSDKLogger.d(ScreenshotTaker.class, "viewRoots count: " + list.size());
        try {
            bitmap = (long)(view.getWidth() * view.getHeight() * 4) < a.a((Context)activity) ? Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        }
        catch (IllegalArgumentException | OutOfMemoryError throwable) {
            return null;
        }
        return ScreenshotTaker.drawRootsToBitmap(list, bitmap, ignoredViewsIds);
    }

    private static Observable<Bitmap> drawRootsToBitmap(List<RootViewInfo> viewRoots, final Bitmap bitmap, final @Nullable @IdRes int[] ignoredViewsIds) {
        return Observable.fromIterable(viewRoots).flatMap((Function)new Function<RootViewInfo, ObservableSource<Bitmap>>(){

            public ObservableSource<Bitmap> a(RootViewInfo rootViewInfo) throws Exception {
                return ScreenshotTaker.drawRootToBitmap(rootViewInfo, bitmap, ignoredViewsIds);
            }

            public /* synthetic */ Object apply(Object object) throws Exception {
                return this.a((RootViewInfo)object);
            }
        });
    }

    private static Observable<Bitmap> drawRootToBitmap(final RootViewInfo rootViewInfo, final Bitmap bitmap, final @Nullable @IdRes int[] ignoredViewsIds) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Pair<Canvas, HashMap<View, Integer>>>(){

            public void subscribe(ObservableEmitter<Pair<Canvas, HashMap<View, Integer>>> emitter) throws Exception {
                Canvas canvas;
                if ((rootViewInfo.getLayoutParams().flags & 2) == 2) {
                    canvas = new Canvas(bitmap);
                    int n = (int)(255.0f * rootViewInfo.getLayoutParams().dimAmount);
                    canvas.drawARGB(n, 0, 0, 0);
                }
                canvas = new Canvas(bitmap);
                canvas.translate((float)rootViewInfo.getLeft(), (float)rootViewInfo.getTop());
                HashMap<View, Integer> hashMap = new HashMap<View, Integer>();
                if (ignoredViewsIds != null) {
                    for (int j = 0; j < ignoredViewsIds.length; ++j) {
                        View view = rootViewInfo.getView().findViewById(ignoredViewsIds[j]);
                        if (view == null) continue;
                        hashMap.put(view, view.getVisibility());
                    }
                }
                emitter.onNext((Object)new Pair((Object)canvas, hashMap));
            }
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).map((Function)new Function<Pair<Canvas, HashMap<View, Integer>>, Pair<Canvas, HashMap<View, Integer>>>(){

            public Pair<Canvas, HashMap<View, Integer>> a(Pair<Canvas, HashMap<View, Integer>> pair) throws Exception {
                for (View view : ((HashMap)pair.second).keySet()) {
                    view.setVisibility(4);
                }
                rootViewInfo.getView().draw((Canvas)pair.first);
                return pair;
            }

            public /* synthetic */ Object apply(Object object) throws Exception {
                return this.a((Pair<Canvas, HashMap<View, Integer>>)((Pair)object));
            }
        }).observeOn(Schedulers.single()).map((Function)new Function<Pair<Canvas, HashMap<View, Integer>>, HashMap<View, Integer>>(){

            public HashMap<View, Integer> a(Pair<Canvas, HashMap<View, Integer>> pair) throws Exception {
                ScreenshotTaker.drawUnDrawableViews(rootViewInfo.getView(), (Canvas)pair.first);
                Collection<WeakReference<View>> collection = SettingsManager.getInstance().getPrivateViews();
                HashSet<WeakReference<View>> hashSet = new HashSet<WeakReference<View>>();
                for (WeakReference<View> weakReference : collection) {
                    if (weakReference != null && weakReference.get() != null) {
                        View view = (View)weakReference.get();
                        if (view == null || !ScreenshotTaker.isVisible(view)) continue;
                        int[] nArray = new int[2];
                        view.getLocationOnScreen(nArray);
                        ((Canvas)pair.first).drawRect(ScreenshotTaker.getVisibleRect(view), new Paint());
                        continue;
                    }
                    hashSet.add(weakReference);
                }
                SettingsManager.getInstance().getPrivateViews().removeAll(hashSet);
                return (HashMap)pair.second;
            }

            public /* synthetic */ Object apply(Object object) throws Exception {
                return this.a((Pair<Canvas, HashMap<View, Integer>>)((Pair)object));
            }
        }).observeOn(AndroidSchedulers.mainThread()).map((Function)new Function<HashMap<View, Integer>, Bitmap>(){

            public Bitmap a(HashMap<View, Integer> hashMap) throws Exception {
                for (Map.Entry<View, Integer> entry : hashMap.entrySet()) {
                    entry.getKey().setVisibility(entry.getValue().intValue());
                }
                return bitmap;
            }

            public /* synthetic */ Object apply(Object object) throws Exception {
                return this.a((HashMap)object);
            }
        });
    }

    public static boolean isVisible(View view) {
        if (!view.isShown()) {
            return false;
        }
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        Rect rect2 = new Rect(0, 0, DisplayUtils.getDisplayWidthInPx(Instabug.getApplicationContext()), DisplayUtils.getDisplayHeightInPx(Instabug.getApplicationContext()));
        return rect.intersect(rect2);
    }

    private static Rect getVisibleRect(@Nullable View childView) {
        Rect rect = new Rect();
        if (childView == null || childView.getVisibility() != 0 || childView.getRootView().getParent() == null) {
            return new Rect(0, 0, 0, 0);
        }
        if (!childView.getGlobalVisibleRect(rect)) {
            return new Rect(0, 0, 0, 0);
        }
        return rect;
    }

    private static ArrayList<View> drawUnDrawableViews(View v, Canvas canvas) {
        if (!(v instanceof ViewGroup)) {
            ArrayList<View> arrayList = new ArrayList<View>();
            arrayList.add(v);
            return arrayList;
        }
        ArrayList<View> arrayList = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)v;
        for (int j = 0; j < viewGroup.getChildCount(); ++j) {
            View view = viewGroup.getChildAt(j);
            ArrayList<View> arrayList2 = new ArrayList<View>();
            arrayList2.add(v);
            arrayList2.addAll(ScreenshotTaker.drawUnDrawableViews(view, canvas));
            int[] nArray = new int[2];
            view.getLocationOnScreen(nArray);
            if (Build.VERSION.SDK_INT >= 14 && view instanceof TextureView) {
                ScreenshotTaker.drawTextureView((TextureView)view, nArray, canvas);
            }
            if (view instanceof GLSurfaceView) {
                ScreenshotTaker.drawGLSurfaceView((GLSurfaceView)view, nArray, canvas);
            }
            if (Build.VERSION.SDK_INT >= 11 && view instanceof WebView) {
                ScreenshotTaker.drawWebView((WebView)view, canvas);
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public static void drawGLSurfaceView(GLSurfaceView surfaceView, int[] locationOnScreen, Canvas canvas) {
        InstabugSDKLogger.d(ScreenshotTaker.class, "Drawing GLSurfaceView");
        if (surfaceView.getWindowToken() != null) {
            final int n = surfaceView.getWidth();
            final int n2 = surfaceView.getHeight();
            boolean bl = false;
            boolean bl2 = false;
            int[] nArray = new int[n * (0 + n2)];
            final IntBuffer intBuffer = IntBuffer.wrap(nArray);
            intBuffer.position(0);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            surfaceView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                    eGL10.eglWaitGL();
                    GL10 gL10 = (GL10)eGL10.eglGetCurrentContext().getGL();
                    gL10.glFinish();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    gL10.glReadPixels(0, 0, n, 0 + n2, 6408, 5121, (Buffer)intBuffer);
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            int[] nArray2 = new int[n * n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                for (int j = 0; j < n; ++j) {
                    int n5;
                    int n6 = nArray[n3 * n + j];
                    int n7 = n6 >> 16 & 0xFF;
                    int n8 = n6 << 16 & 0xFF0000;
                    nArray2[(n2 - n4 - 1) * n + j] = n5 = n6 & 0xFF00FF00 | n8 | n7;
                }
                ++n3;
                ++n4;
            }
            Bitmap bitmap = Bitmap.createBitmap((int[])nArray2, (int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Paint paint = new Paint();
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            canvas.drawBitmap(bitmap, (float)locationOnScreen[0], (float)locationOnScreen[1], paint);
            bitmap.recycle();
        }
    }

    @TargetApi(value=14)
    public static void drawTextureView(TextureView textureView, int[] locationOnScreen, Canvas canvas) {
        InstabugSDKLogger.d(ScreenshotTaker.class, "Drawing TextureView");
        try {
            Bitmap bitmap = textureView.getBitmap();
            if (bitmap != null) {
                Paint paint = new Paint();
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                canvas.drawBitmap(bitmap, (float)locationOnScreen[0], (float)locationOnScreen[1], paint);
                bitmap.recycle();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e(ScreenshotTaker.class, ScreenshotTaker.class.getSimpleName(), outOfMemoryError);
        }
    }

    @TargetApi(value=11)
    public static void drawWebView(WebView webView, Canvas canvas) {
        int n = webView.getLayerType();
        if (n == 2) {
            webView.setLayerType(0, null);
            webView.setDrawingCacheEnabled(true);
            webView.buildDrawingCache(true);
            Bitmap bitmap = webView.getDrawingCache();
            if (bitmap != null) {
                Paint paint = new Paint();
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                int[] nArray = new int[2];
                webView.getLocationOnScreen(nArray);
                canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
                bitmap.recycle();
            }
            webView.setDrawingCacheEnabled(false);
            webView.setLayerType(n, null);
        }
    }
}

