/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.ComponentCallbacks;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import com.instabug.library.Feature;
import com.instabug.library._InstabugActivity;
import com.instabug.library.b;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.model.e;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.c;
import com.instabug.library.tracking.d;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    private static InstabugInternalTrackingDelegate INSTANCE;
    private WeakReference<Activity> currentActivity;

    public static void init(Application application) {
        if (INSTANCE == null) {
            INSTANCE = new InstabugInternalTrackingDelegate(application);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    private InstabugInternalTrackingDelegate(Application application) {
        if (application != null) {
            this.registerActivityLifecycleListener(application);
        }
    }

    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, application.getClass().getSimpleName() + " created");
            d.a().a(application.getClass().getName(), e.a.APPLICATION_CREATED);
        }
    }

    void handleActivityCreatedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " created");
                d.a().a(activity.getClass().getName(), e.a.ACTIVITY_CREATED);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(e.a.ACTIVITY_CREATED, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.CREATED);
        }
    }

    void handleActivityStartedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " started");
                d.a().a(activity.getClass().getName(), e.a.ACTIVITY_STARTED);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(e.a.ACTIVITY_STARTED, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STARTED);
    }

    void handleActivityResumedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            this.currentActivity = new WeakReference<Activity>(activity);
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " resumed");
                d.a().a(activity.getClass().getName(), e.a.ACTIVITY_RESUMED);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(e.a.ACTIVITY_RESUMED, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.RESUMED);
        }
    }

    void handleActivityPausedEvent(Activity activity) {
        Activity activity2 = null;
        if (this.currentActivity != null) {
            activity2 = (Activity)this.currentActivity.get();
        }
        if (this.isNotInstabugActivity(activity)) {
            if (activity2 == null) {
                InstabugSDKLogger.w(this, "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!activity.equals(activity2)) {
                InstabugSDKLogger.w(this, "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " paused");
                d.a().a(activity.getClass().getName(), e.a.ACTIVITY_PAUSED);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(e.a.ACTIVITY_PAUSED, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.PAUSED);
        }
    }

    void handleActivityStoppedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " stopped");
                d.a().a(activity.getClass().getName(), e.a.ACTIVITY_STOPPED);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(e.a.ACTIVITY_STOPPED, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STOPPED);
    }

    void handleActivityDestroyedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " destroyed");
                d.a().a(activity.getClass().getName(), e.a.ACTIVITY_DESTROYED);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(e.a.ACTIVITY_DESTROYED, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
            if (activity != null) {
                String string2 = activity.getLocalClassName();
                if (this.currentActivity != null && this.currentActivity.get() != null && string2.equals(((Activity)this.currentActivity.get()).getLocalClassName())) {
                    this.currentActivity.clear();
                }
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    public void onFragmentAttached(Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_ATTACHED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_ATTACHED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentViewCreated(Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_VIEW_CREATED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_VIEW_CREATED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentStarted(Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_STARTED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_STARTED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentResumed(Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_RESUMED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_RESUMED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentPaused(Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_PAUSED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_PAUSED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentStopped(Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_STOPPED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_STOPPED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentDetached(Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_DETACHED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_DETACHED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentAttached(android.support.v4.app.Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_ATTACHED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_ATTACHED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentViewCreated(android.support.v4.app.Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_VIEW_CREATED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_VIEW_CREATED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentStarted(android.support.v4.app.Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_STARTED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_STARTED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentResumed(android.support.v4.app.Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_RESUMED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_RESUMED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentPaused(android.support.v4.app.Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_PAUSED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_PAUSED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentStopped(android.support.v4.app.Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_STOPPED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_STOPPED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentDetached(android.support.v4.app.Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), e.a.FRAGMENT_DETACHED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_DETACHED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), "Fragment visibility: " + isVisible, e.a.FRAGMENT_VISIBILITY_CHANGED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_VISIBILITY_CHANGED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentVisibilityChanged(boolean isVisible, android.support.v4.app.Fragment fragment, Activity parentActivity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), parentActivity.getClass().getName(), "Fragment visibility: " + isVisible, e.a.FRAGMENT_VISIBILITY_CHANGED);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(e.a.FRAGMENT_VISIBILITY_CHANGED, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void trackTouchEvent(MotionEvent event, Activity activity) {
        c.a().a(activity, event);
    }

    public Activity getCurrentActivity() {
        Activity activity = null;
        if (this.currentActivity != null) {
            activity = (Activity)this.currentActivity.get();
        }
        if (activity != null) {
            return activity;
        }
        return null;
    }

    @Nullable
    public Activity getTargetActivity() {
        Activity activity = null;
        Activity activity2 = null;
        if (this.currentActivity != null) {
            activity2 = (Activity)this.currentActivity.get();
        }
        if (activity2 != null && activity2.getParent() != null) {
            activity = activity2.getParent();
            while (activity.getParent() != null) {
                activity = activity.getParent();
            }
        } else if (activity2 != null) {
            activity = activity2;
        }
        return activity;
    }

    private void registerActivityLifecycleListener(Application application) {
        InstabugSDKLogger.v(this, "Registering activity lifecycle listener");
        a a2 = new a();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)a2);
        application.registerComponentCallbacks((ComponentCallbacks)a2);
    }

    private boolean isUserTrackingStepsEnable() {
        return b.a().c(Feature.TRACK_USER_STEPS) == Feature.State.ENABLED;
    }

    private boolean isReproStepsEnable() {
        return b.a().c(Feature.REPRO_STEPS) == Feature.State.ENABLED;
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return !(activity instanceof _InstabugActivity);
    }
}

