/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import com.instabug.library.util.InstabugSDKLogger;

public class VideoManipulationUtils {
    public static Bitmap extractVideoFrame(String videoPath) throws IllegalArgumentException {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(videoPath);
        return mediaMetadataRetriever.getFrameAtTime();
    }

    public static Bitmap extractFirstVideoFrame(String videoPath) throws IllegalArgumentException {
        return VideoManipulationUtils.extractVideoFrame(videoPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long extractVideoDuration(String videoPath) throws IllegalArgumentException {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        long l = -1L;
        try {
            mediaMetadataRetriever.setDataSource(videoPath);
            String string2 = mediaMetadataRetriever.extractMetadata(9);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                l = Long.parseLong(string2);
            }
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(VideoManipulationUtils.class, exception.getClass().getSimpleName(), exception);
        }
        finally {
            mediaMetadataRetriever.release();
        }
        return l;
    }
}

