/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import java.util.List;

public class StringUtility {
    public static String trimString(String s) {
        return StringUtility.trimString(s, 4096);
    }

    public static String trimString(String s, int limit) {
        if (s == null) {
            return "null";
        }
        if (s.length() > limit) {
            s = s.substring(0, limit);
        }
        return s;
    }

    public static String[] trimStrings(String[] strings) {
        for (int j = 0; j < strings.length; ++j) {
            strings[j] = StringUtility.trimString(strings[j]);
        }
        return strings;
    }

    public static boolean isNumeric(String s) {
        return s.matches("\\d+(?:\\.\\d+)?");
    }

    public static int compareVersion(String version1, String version2) throws NumberFormatException {
        String[] stringArray = version1.split("\\.");
        String[] stringArray2 = version2.split("\\.");
        for (int j = 0; j < stringArray.length || j < stringArray2.length; ++j) {
            if (j < stringArray.length && j < stringArray2.length) {
                if (Integer.parseInt(stringArray[j]) < Integer.parseInt(stringArray2[j])) {
                    return -1;
                }
                if (Integer.parseInt(stringArray[j]) <= Integer.parseInt(stringArray2[j])) continue;
                return 1;
            }
            if (j < stringArray.length) {
                if (Integer.parseInt(stringArray[j]) == 0) continue;
                return 1;
            }
            if (j >= stringArray2.length || Integer.parseInt(stringArray2[j]) == 0) continue;
            return -1;
        }
        return 0;
    }

    public static String removeExtension(String fileName) {
        return fileName.replaceFirst("[.][^.]+$", "");
    }

    public static String toCommaSeparated(List<String> strings) {
        StringBuilder stringBuilder = new StringBuilder();
        if (strings == null || strings.size() == 0) {
            return stringBuilder.toString();
        }
        for (int j = 0; j < strings.size() - 1; ++j) {
            stringBuilder.append(strings.get(j));
            stringBuilder.append(",");
        }
        stringBuilder.append(strings.get(strings.size() - 1));
        return stringBuilder.toString();
    }
}

